/*
 * Copyright (C) 2018 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package dulab.adap.datamodel;

public class Adduct {

    private final String name;
    private final double mass;
    private final int numMolecules;
    private final int charge;


    public Adduct(String name, double mass, int numMolecules, int charge) {
        this.name = name;
        this.mass = mass;
        this.numMolecules = numMolecules;
        this.charge = charge;
    }

    public String getName() {
        return name;
    }

    public double getMass() {
        return mass;
    }

    public int getNumMolecules() {
        return numMolecules;
    }

    public int getCharge() {
        return charge;
    }
}
