package dulab.adap.datamodel;

import javax.annotation.Nonnull;

/**
 * This class is designed to represent a component, that is an EIC-peak with a spectrum
 * @author Du-Lab Team <dulab.binf@gmail.com>
 */
public class BetterComponent extends BetterPeak
{
    /** Spectrum of the component */
    public Spectrum spectrum;

    public Double precursor = null;

    /**
     * Creates an instance of the class with the given chromatogram, spectrum, and some extra information
     * @param chromatogram chromatorgam of the component
     * @param spectrum spectrum of the component
     * @param info extra information
     */
    public BetterComponent(int id, @Nonnull Chromatogram chromatogram, @Nonnull Spectrum spectrum, @Nonnull PeakInfo info)
    {
        super(id, chromatogram, info);

        this.spectrum = spectrum;
    }

    public BetterComponent(int id, Chromatogram chromatogram, Spectrum spectrum, PeakInfo info, double precursor) {
        this(id, chromatogram, spectrum, info);
        this.precursor = precursor;
    }
}
