package dulab.adap.datamodel;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * This class is designed to store information about a peak
 *
 * @author Du-Lab Team <dulab.binf@gmail.com>
 */
public class BetterPeak
{
    public final int id;

    /** An instance of PeakInfo class with some extra information about the peak */
    public final PeakInfo info;

    /** Chromatogram of the peak */
    public final Chromatogram chromatogram;

    /** M/z-value of the peak */
    public final double mzValue;

    private Integer parentId = null;

    /**
     * Creates an instance of the class
     * @param chromatogram chromatogram of the peak
     * @param info extra information about the peak
     */
    public BetterPeak(int id, @Nonnull Chromatogram chromatogram, @Nonnull PeakInfo info) {
        this.id = id;
        this.chromatogram = chromatogram;
        this.info = info;
        this.mzValue = info.mzValue;
    }

    public void setParentId(@Nullable Integer parentId) {
        this.parentId = parentId;
    }

    @Nullable
    public Integer getParentId() {
        return parentId;
    }

    /** Returns the peak id */
    public int getId() {
        return id;
    }

    /** Returns the apex retention time of the peak */
    public double getRetTime() {return chromatogram.getApexRetTime();}

    /** Retrns the first retention time of the peak */
    public double getFirstRetTime() {return chromatogram.getFirstRetTime();}

    /** Returns the last retention time of the peak */
    public double getLastRetTime() {return chromatogram.getLastRetTimes();}

    /** Returns m/z-value of the peak */
    public double getMZ() {return mzValue;}

    /** Returns intensity of the peak */
    public double getIntensity() {return chromatogram.getHeight();}

    /** Returns a string with m/z-value and retention time of the peak */
    @Override
    public String toString() {
        return "#" + info.peakID + ": mz=" + getMZ() + " rt=" + getRetTime();
    }
}
