/* 
 * Copyright (C) 2016 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dulab.adap.datamodel;

import dulab.adap.workflow.AlignmentParameters;
import dulab.adap.workflow.Alignment;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author aleksandrsmirnov
 */
public class Project {

    private final Alignment alignment;
    private final List <Sample> samples;
    private List <ReferenceComponent> referenceComponents;
    
    // ------------------------------------------------------------------------
    // ----- Constructors -----------------------------------------------------
    // ------------------------------------------------------------------------ 
    
    public Project() {
        alignment = new Alignment();
        samples = new ArrayList <> ();
        referenceComponents = new ArrayList <> ();
    }
    
    // ------------------------------------------------------------------------
    // ----- Properties -------------------------------------------------------
    // ------------------------------------------------------------------------
    
    public List <ReferenceComponent> getComponents() {
        return referenceComponents;
    }
    
    public double getProcessedPercent() {
        return alignment.getProcessedPercent();
    }
    
    // ------------------------------------------------------------------------
    // ----- Methods ----------------------------------------------------------
    // ------------------------------------------------------------------------
    
    public void addSample(final Sample sample) {
        this.samples.add(new Sample(sample));
    }
    
    public void alignSamples(final AlignmentParameters params) {
        referenceComponents = alignment.run(params, samples);
    }

    public void cancel() {
        alignment.cancel();
    }
}
