/* 
 * Copyright (C) 2016 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dulab.adap.datamodel;

import dulab.adap.workflow.TwoStepDecomposition;
import dulab.adap.workflow.TwoStepDecompositionParameters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;

/**
 *
 * @author aleksandrsmirnov
 */
public class Sample {
    private List <Component> components;
    private final int id;
    private final String tag;
    
    // ------------------------------------------------------------------------
    // ----- Constructors -----------------------------------------------------
    // ------------------------------------------------------------------------
    
    public Sample() {this(0);}
    
    public Sample(final int id) {this(id, "");}
    
    public Sample(final int id, final String tag) {
        this.id = id;
        this.tag = tag;
        components = new ArrayList <> ();
    }
    
    public Sample(final Sample sample) {
        this.id = sample.id;
        this.tag = sample.tag;
        this.components = new ArrayList <> (sample.components);
    }
    
    // ------------------------------------------------------------------------
    // ----- Properties -------------------------------------------------------
    // ------------------------------------------------------------------------
    
    public List <Component> getComponents() {return this.components;}
    public String getTag() {return this.tag;}
    public int getID() {return this.id;}
    public double getProcessedPercent() {
        return new TwoStepDecomposition().getProcessedPercent();
    }
    
    // ------------------------------------------------------------------------
    // ----- Methods ----------------------------------------------------------
    // ------------------------------------------------------------------------
    
    public void addComponent(final Component c) {
        this.components.add(new Component(c));
    }
    
    public void addPeaks(final TwoStepDecompositionParameters params,
            final List <Peak> peaks)
    {
        components = new TwoStepDecomposition().run(params, peaks);
    }
}
