package dulab.adap.datamodel;

import dulab.adap.common.types.Function;

import javax.annotation.Nonnull;

/**
 * This class is designed to store a spectrum
 * @author Du-Lab Team <dulab.binf@gmail.com>
 */
public class Spectrum extends Function
{
    /** l2-norm of the spectrum */
    public final double norm;

    private final PeakInfo[] peakInfos;

    /**
     * Creates an instance of the class. Two arrays are required tp have the same size
     * @param mzValues mz-values of the spectrum
     * @param intensities intensities of the spectrum
     */
    public Spectrum(@Nonnull double[] mzValues, @Nonnull double[] intensities, PeakInfo[] peakInfos)
    {
        super(mzValues, intensities);
        this.peakInfos = peakInfos;

        double norm2 = 0.0;
        for (int i = 0; i < length; ++i)
            norm2 += intensities[i] * intensities[i];
        norm = Math.sqrt(norm2);
    }

    public Spectrum(double[] mzValues, double[] intensities) {
        this(mzValues, intensities, null);
    }

    /** Returns i-th mz-value in the spectrum */
    public double getMZ(int index) {return xs[index];}

    /** Returns i-th intensity in the spectrum */
    public double getIntensity(int index) {return ys[index];}

    public PeakInfo getPeakInfo(int index) {
        return peakInfos != null ? peakInfos[index] : null;
    }
}
