/* 
 * Copyright (C) 2016 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package dulab.adap.gui.database;


import dulab.adap.common.distances.Distance;
import dulab.adap.common.parsers.Parser;
import dulab.adap.datamodel.DataBase;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
;
import java.io.File;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class FileDescription {
    public String name = null;
    public String path = null;
    public Integer type = null;
    
    public FileDescription(String name, String path) {
        this.name = name;
        this.path = path;
    }
    
    @Override
    public String toString() {
        String type = this.type != null ? "KNOWN_TYPE" : "UNKNOWN TYPE";
        String name = this.name != null ? this.name : "";
        
        return "(" + type + ") " + name;
    }
}

/**
 *
 * @author aleksandrsmirnov
 */
public class uiDataBase extends javax.swing.JFrame 
        implements PropertyChangeListener
{
    private static final String TITLE = "ADAP DataBase Management";
    
    private static final int WAITING = 0;
    private static final int WORKING = 1;
    
    private DataBase dataBase;
    private ProgressMonitorTask monitor;
    
    private int status;
    private Integer fileType = null;
    private Integer distanceType = null;
    
    private JComboBox comboBoxEditor = new JComboBox(Parser.ALL_FILE_FORMATS);
 
    private class ProgressMonitorTask extends SwingWorker <Void, Void> 
    {
        private static final int TIME_INTERVAL = 300;
        
        @Override
        public Void doInBackground() {
            setProgress(0);
            try {
                while (!isCancelled()) {
                    Thread.sleep(TIME_INTERVAL);
                    if (dataBase != null) 
                    {
                        int progress = (int) java.lang.Math.round(
                                100 * dataBase.getProgress());
                        
                        progress = progress == 0 ? 2 : progress;
                        
                        setProgress(progress);
                    }
                }
            } catch (InterruptedException ignore) {}
            
            return null;
        }
    }
    
    /**
     * Creates new form DataBaseJFrame
     */
    public uiDataBase() {
        initComponents();
        
        status = uiDataBase.WAITING;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroupDistance = new javax.swing.ButtonGroup();
        jPanelFileManagement = new javax.swing.JPanel();
        jPanelFilesManagementButtons = new javax.swing.JPanel();
        jButtonAddFile = new javax.swing.JButton();
        jButtonRemove = new javax.swing.JButton();
        jPanelDistance = new javax.swing.JPanel();
        jRadioButtonEuclideanDistance = new javax.swing.JRadioButton();
        jRadioButtonDotProductDistance = new javax.swing.JRadioButton();
        jRadioButtonWeightedDotProductDistance = new javax.swing.JRadioButton();
        jScrollPaneFiles = new javax.swing.JScrollPane();
        jTableFiles = new javax.swing.JTable();
        jPanelDataBaseManagement = new javax.swing.JPanel();
        jPanelDataBaseManagementButtons = new javax.swing.JPanel();
        jButtonCreate = new javax.swing.JButton();
        jButtonSave = new javax.swing.JButton();
        jButtonClose = new javax.swing.JButton();
        jPanelInfo = new javax.swing.JPanel();
        jLabelInfo = new javax.swing.JLabel();
        jProgressBar = new javax.swing.JProgressBar();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle(TITLE);

        jPanelFileManagement.setBorder(javax.swing.BorderFactory.createTitledBorder("File Management"));
        jPanelFileManagement.setName(""); // NOI18N
        jPanelFileManagement.setLayout(new java.awt.BorderLayout());

        jButtonAddFile.setText("Add");
        jButtonAddFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddFileActionPerformed(evt);
            }
        });

        jButtonRemove.setText("Remove");
        jButtonRemove.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRemoveActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelFilesManagementButtonsLayout = new javax.swing.GroupLayout(jPanelFilesManagementButtons);
        jPanelFilesManagementButtons.setLayout(jPanelFilesManagementButtonsLayout);
        jPanelFilesManagementButtonsLayout.setHorizontalGroup(
            jPanelFilesManagementButtonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelFilesManagementButtonsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelFilesManagementButtonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelFilesManagementButtonsLayout.createSequentialGroup()
                        .addComponent(jButtonAddFile, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelFilesManagementButtonsLayout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(jButtonRemove, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        jPanelFilesManagementButtonsLayout.setVerticalGroup(
            jPanelFilesManagementButtonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelFilesManagementButtonsLayout.createSequentialGroup()
                .addComponent(jButtonAddFile)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonRemove)
                .addGap(0, 359, Short.MAX_VALUE))
        );

        jPanelFileManagement.add(jPanelFilesManagementButtons, java.awt.BorderLayout.LINE_END);

        buttonGroupDistance.add(jRadioButtonEuclideanDistance);
        jRadioButtonEuclideanDistance.setText("Euclidean Distance");
        jRadioButtonEuclideanDistance.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonEuclideanDistanceActionPerformed(evt);
            }
        });

        buttonGroupDistance.add(jRadioButtonDotProductDistance);
        jRadioButtonDotProductDistance.setText("Dot-Product Distance");
        jRadioButtonDotProductDistance.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonDotProductDistanceActionPerformed(evt);
            }
        });

        buttonGroupDistance.add(jRadioButtonWeightedDotProductDistance);
        jRadioButtonWeightedDotProductDistance.setText("Weighted Dot-Product Distance");
        jRadioButtonWeightedDotProductDistance.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonWeightedDotProductDistanceActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelDistanceLayout = new javax.swing.GroupLayout(jPanelDistance);
        jPanelDistance.setLayout(jPanelDistanceLayout);
        jPanelDistanceLayout.setHorizontalGroup(
            jPanelDistanceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelDistanceLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jRadioButtonEuclideanDistance)
                .addGap(18, 18, 18)
                .addComponent(jRadioButtonDotProductDistance)
                .addGap(18, 18, 18)
                .addComponent(jRadioButtonWeightedDotProductDistance)
                .addContainerGap(226, Short.MAX_VALUE))
        );
        jPanelDistanceLayout.setVerticalGroup(
            jPanelDistanceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelDistanceLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelDistanceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRadioButtonEuclideanDistance)
                    .addComponent(jRadioButtonDotProductDistance)
                    .addComponent(jRadioButtonWeightedDotProductDistance))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanelFileManagement.add(jPanelDistance, java.awt.BorderLayout.PAGE_END);

        jTableFiles.setAutoCreateRowSorter(true);
        jTableFiles.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "File Type", "File Name"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        jTableFiles.getColumn("File Type").setCellEditor(new DefaultCellEditor(comboBoxEditor));
        jScrollPaneFiles.setViewportView(jTableFiles);

        jPanelFileManagement.add(jScrollPaneFiles, java.awt.BorderLayout.CENTER);

        jPanelDataBaseManagement.setBorder(javax.swing.BorderFactory.createTitledBorder("DataBase Management"));
        jPanelDataBaseManagement.setLayout(new java.awt.BorderLayout());

        jButtonCreate.setText("Create");
        jButtonCreate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCreateActionPerformed(evt);
            }
        });

        jButtonSave.setText("Save");
        jButtonSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSaveActionPerformed(evt);
            }
        });

        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelDataBaseManagementButtonsLayout = new javax.swing.GroupLayout(jPanelDataBaseManagementButtons);
        jPanelDataBaseManagementButtons.setLayout(jPanelDataBaseManagementButtonsLayout);
        jPanelDataBaseManagementButtonsLayout.setHorizontalGroup(
            jPanelDataBaseManagementButtonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelDataBaseManagementButtonsLayout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jButtonCreate, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonSave, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jButtonClose, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        jPanelDataBaseManagementButtonsLayout.setVerticalGroup(
            jPanelDataBaseManagementButtonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelDataBaseManagementButtonsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelDataBaseManagementButtonsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonSave)
                    .addComponent(jButtonClose)
                    .addComponent(jButtonCreate))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanelDataBaseManagement.add(jPanelDataBaseManagementButtons, java.awt.BorderLayout.LINE_END);

        jPanelInfo.setLayout(new java.awt.BorderLayout());
        jPanelInfo.add(jLabelInfo, java.awt.BorderLayout.LINE_START);

        jProgressBar.setVisible(false);
        jProgressBar.setString("");
        jPanelInfo.add(jProgressBar, java.awt.BorderLayout.CENTER);

        jPanelDataBaseManagement.add(jPanelInfo, java.awt.BorderLayout.CENTER);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanelDataBaseManagement, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanelFileManagement, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanelFileManagement, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelDataBaseManagement, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonAddFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddFileActionPerformed
        final JFileChooser fc = new JFileChooser();
        
        int returnVal = fc.showOpenDialog(this);
        
        if (returnVal == JFileChooser.APPROVE_OPTION)
        {
            File file = fc.getSelectedFile();
            
            /*
            DefaultListModel <FileDescription> model = 
                    (DefaultListModel) jListFiles.getModel();
            
            model.addElement(
                    new FileDescription(file.getName(), file.getPath()));
            */
            
            DefaultTableModel model = (DefaultTableModel) jTableFiles.getModel();
            
           
            
            model.addRow(new Object[] {"Choose File Format...", file.getPath()});
            
            jTableFiles.setModel(model);
        }
    }//GEN-LAST:event_jButtonAddFileActionPerformed

    private void jButtonRemoveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRemoveActionPerformed
        DefaultTableModel model =
                (DefaultTableModel) jTableFiles.getModel();
        
        model.removeRow(jTableFiles.getSelectedRow());
    }//GEN-LAST:event_jButtonRemoveActionPerformed

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        if (status == uiDataBase.WORKING) {
            int reply = JOptionPane.showConfirmDialog(this, 
                    "One of the tasks is not finished yet. Wait until it is finished?",
                    TITLE,
                    JOptionPane.YES_NO_OPTION);
            
            if (reply == JOptionPane.YES_OPTION) return;
        }
        
        System.exit(0);
    }//GEN-LAST:event_jButtonCloseActionPerformed

    private void jButtonCreateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCreateActionPerformed
        
        final DefaultTableModel model = 
                (DefaultTableModel) jTableFiles.getModel();
        
        final int fileCount = model.getRowCount();
        
        if (fileCount == 0) {
            JOptionPane.showMessageDialog(this, 
                    "Please, add files to the file list", 
                    TITLE, 
                    JOptionPane.INFORMATION_MESSAGE);
            return;
        }
        
        if (this.distanceType == null) {
            JOptionPane.showMessageDialog(this, 
                    "Please, choose a distance-function",
                    TITLE,
                    JOptionPane.INFORMATION_MESSAGE);
        }
        
        if (dataBase != null) {
            int reply = JOptionPane.showConfirmDialog(this, 
                    "DataBase has already been created. Keep existing DataBase?", 
                    TITLE, 
                    JOptionPane.YES_NO_OPTION);
            
            if (reply == JOptionPane.YES_OPTION) return;
        }
        
        monitor = new ProgressMonitorTask();
        monitor.addPropertyChangeListener(this);
        monitor.execute();
        
        dataBase = new DataBase();
        
        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() 
            {
                status = uiDataBase.WORKING;
                
                jButtonCreate.setEnabled(false);
                jButtonSave.setEnabled(false);
                
                jLabelInfo.setText("Reading data files...");
                jProgressBar.setIndeterminate(true);
                jProgressBar.setValue(0);
                jProgressBar.setVisible(true);
                
                for (int i = 0; i < fileCount; ++i)
                    dataBase.readDataFiles(
                            model.getValueAt(i, 0).toString(), 
                            model.getValueAt(i, 1).toString());

                jProgressBar.setIndeterminate(false);
                jLabelInfo.setText("Processing data...");
                
                try {
                    dataBase.processData(distanceType);
                } 
                catch (Exception e) {
                    JOptionPane.showMessageDialog(uiDataBase.this, 
                            "Couldn't process data: " + e.getMessage(), 
                            TITLE, 
                            JOptionPane.ERROR_MESSAGE);
                } finally {
                    jProgressBar.setValue(0);
                    jProgressBar.setVisible(false);
                    updateInfo();
                    
                    jButtonCreate.setEnabled(true);
                    jButtonSave.setEnabled(true);
                    
                    status = uiDataBase.WAITING;
                }
            }
        });
        thread.start();
    }//GEN-LAST:event_jButtonCreateActionPerformed

    private void jButtonSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSaveActionPerformed
        final JFileChooser fc = new JFileChooser();
        
        int returnVal = fc.showSaveDialog(this);
        if (returnVal != JFileChooser.APPROVE_OPTION) 
            return;
        
        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() 
            {
                status = uiDataBase.WORKING;
                
                jButtonCreate.setEnabled(false);
                jButtonSave.setEnabled(false);
                
                jLabelInfo.setText("Saving data...");
                jProgressBar.setIndeterminate(true);
                jProgressBar.setValue(0);
                jProgressBar.setVisible(true);
                
                try {
                    dataBase.saveTree(fc.getSelectedFile().getPath());
                } catch (Exception e) {
                    JOptionPane.showMessageDialog(uiDataBase.this, 
                            "Couldn't save data: " + e.getMessage(), 
                            TITLE, 
                            JOptionPane.ERROR_MESSAGE);
                } finally {
                    jProgressBar.setValue(0);
                    jProgressBar.setVisible(false);
                    updateInfo();
                    
                    jButtonCreate.setEnabled(true);
                    jButtonSave.setEnabled(true);
                }
                
                status = uiDataBase.WAITING;
            }
        });
        thread.start();
    }//GEN-LAST:event_jButtonSaveActionPerformed

    private void jRadioButtonEuclideanDistanceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonEuclideanDistanceActionPerformed
        this.distanceType = Distance.EUCLIDEAN_DISTANCE;
    }//GEN-LAST:event_jRadioButtonEuclideanDistanceActionPerformed

    private void jRadioButtonDotProductDistanceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonDotProductDistanceActionPerformed
        this.distanceType = Distance.DOT_PRODUCT_DISTANCE;
    }//GEN-LAST:event_jRadioButtonDotProductDistanceActionPerformed

    private void jRadioButtonWeightedDotProductDistanceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonWeightedDotProductDistanceActionPerformed
        this.distanceType = Distance.WEIGHTED_DOT_PRODUCT_DISTANCE;
    }//GEN-LAST:event_jRadioButtonWeightedDotProductDistanceActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        /*
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(uiDataBase.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(uiDataBase.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(uiDataBase.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(uiDataBase.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        */
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                new uiDataBase().setVisible(true);
            }
        });
    }

    private void updateInfo() {
        if (dataBase == null)
            jLabelInfo.setText("");
        else
            jLabelInfo.setText(
                    "DataBase: contains " + dataBase.size() + " elements");
    }
    
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) 
        {
            int progress = (int) evt.getNewValue();
            jProgressBar.setValue(progress);
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupDistance;
    private javax.swing.JButton jButtonAddFile;
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonCreate;
    private javax.swing.JButton jButtonRemove;
    private javax.swing.JButton jButtonSave;
    private javax.swing.JLabel jLabelInfo;
    private javax.swing.JPanel jPanelDataBaseManagement;
    private javax.swing.JPanel jPanelDataBaseManagementButtons;
    private javax.swing.JPanel jPanelDistance;
    private javax.swing.JPanel jPanelFileManagement;
    private javax.swing.JPanel jPanelFilesManagementButtons;
    private javax.swing.JPanel jPanelInfo;
    private javax.swing.JProgressBar jProgressBar;
    private javax.swing.JRadioButton jRadioButtonDotProductDistance;
    private javax.swing.JRadioButton jRadioButtonEuclideanDistance;
    private javax.swing.JRadioButton jRadioButtonWeightedDotProductDistance;
    private javax.swing.JScrollPane jScrollPaneFiles;
    private javax.swing.JTable jTableFiles;
    // End of variables declaration//GEN-END:variables
}