/* 
 * Copyright (C) 2016 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dulab.adap.gui.database;

import dulab.adap.datamodel.Component;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

/**
 *
 * @author aleksandrsmirnov
 */
public class uiIdentification extends javax.swing.JFrame {

    private static final String TITLE = "ADAP Identification";
    
    private List <Component> components = null;
    
    /**
     * Creates new form uiIdentification
     */
    public uiIdentification() {
        initComponents();
        
        // Hiding column Component in jTableComponents
        TableColumnModel columnModel = jTableComponents.getColumnModel();
        columnModel.removeColumn(columnModel.getColumn(3));
        jTableComponents.setColumnModel(columnModel);
    }

    public uiIdentification(List <Component> components) {
        this();
        
        this.components = components;
        
        if (components != null) 
        {
            DefaultTableModel model = 
                    (DefaultTableModel) jTableComponents.getModel();
            
            for (Component c : components)
                model.addRow(new Object[] {
                    c.getBestPeak().getInfo().peakID,
                    c.getMZ(), c.getRetTime(), c
                });
            
            jTableComponents.setModel(model);
        }
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jSplitPaneMain = new javax.swing.JSplitPane();
        jSplitPanePeaks = new javax.swing.JSplitPane();
        jScrollPaneCompounds = new javax.swing.JScrollPane();
        jListCompounds = new javax.swing.JList<>();
        jScrollPaneComponents = new javax.swing.JScrollPane();
        jTableComponents = new javax.swing.JTable();
        jTabbedPaneInformation = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(TITLE);

        jSplitPanePeaks.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jScrollPaneCompounds.setMinimumSize(new java.awt.Dimension(200, 23));

        jScrollPaneCompounds.setViewportView(jListCompounds);

        jSplitPanePeaks.setRightComponent(jScrollPaneCompounds);

        jScrollPaneComponents.setMinimumSize(new java.awt.Dimension(300, 27));

        jTableComponents.setAutoCreateRowSorter(true);
        jTableComponents.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Peak ID", "m/z (Da)", "RT (min)", "Component"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Integer.class, java.lang.Double.class, java.lang.Double.class, java.lang.Object.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTableComponents.setGridColor(new java.awt.Color(204, 204, 204));
        jScrollPaneComponents.setViewportView(jTableComponents);

        jSplitPanePeaks.setLeftComponent(jScrollPaneComponents);

        jSplitPaneMain.setLeftComponent(jSplitPanePeaks);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 857, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 608, Short.MAX_VALUE)
        );

        jTabbedPaneInformation.addTab("tab1", jPanel1);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 857, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 608, Short.MAX_VALUE)
        );

        jTabbedPaneInformation.addTab("tab2", jPanel2);

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 857, Short.MAX_VALUE)
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 608, Short.MAX_VALUE)
        );

        jTabbedPaneInformation.addTab("tab3", jPanel3);

        jSplitPaneMain.setRightComponent(jTabbedPaneInformation);

        getContentPane().add(jSplitPaneMain, java.awt.BorderLayout.CENTER);

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new uiIdentification().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList<String> jListCompounds;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPaneComponents;
    private javax.swing.JScrollPane jScrollPaneCompounds;
    private javax.swing.JSplitPane jSplitPaneMain;
    private javax.swing.JSplitPane jSplitPanePeaks;
    private javax.swing.JTabbedPane jTabbedPaneInformation;
    private javax.swing.JTable jTableComponents;
    // End of variables declaration//GEN-END:variables
}
