/* 
 * Copyright (C) 2016 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dulab.adap.workflow;

import dulab.adap.common.algorithms.machineleanring.OptimizationParameters;

/**
 *
 * @author aleksandrsmirnov
 */
public class AlignmentParameters 
{
    public static final String RT_DIFFERENCE = "Retention Time Difference (fast)";
    public static final String CROSS_CORRELATION = "Cross-correlation (accurate)";
    
    public double sampleCountRatio = 0.5;
    public double retTimeRange;
    public double mzRange;
    public double scoreTolerance;
    public double scoreWeight;
    public String eicScore = RT_DIFFERENCE;
    public double maxShift;
    public OptimizationParameters optimizationParameters;
    
    public AlignmentParameters sampleCountRatio(final double r) {
        if (0.0 <= r && r <= 1.0) 
            this.sampleCountRatio = r;
        else
            throw new IllegalArgumentException("Parameter sampleCountRatio "
                    + "is not in the range from 0 to 1");
        
        return this;
    }
    
    public AlignmentParameters retTimeRange(final double rtr) {
        this.retTimeRange = rtr;
        return this;
    }
    
    public AlignmentParameters mzRange(final double mzr) {
        this.mzRange = mzr;
        return this;
    }
    
    public AlignmentParameters scoreTolerance(final double t) {
        if (0.0 <= t && t <= 1.0)
            this.scoreTolerance = t;
        else
            throw new IllegalArgumentException("Parameter scoreTolerance "
                    + "is not in the range from 0 to 1");
        
        return this;
    }
    
    public AlignmentParameters scoreWeight(final double w) {
        if (0.0 <= w && w <= 1.0)
            this.scoreWeight = w;
        else
            throw new IllegalArgumentException("Parameter scoreWeight "
                    + "is not in the range from 0 to 1");
        
        return this;
    }
    
    public AlignmentParameters eicScore(final String s)
    {
        if (s.equals(RT_DIFFERENCE) || s.equals(CROSS_CORRELATION))
            eicScore = s;
        else
            throw new IllegalArgumentException("Parameter eicScore takes only "
                    + "one of two values: " + RT_DIFFERENCE + " or " 
                    + CROSS_CORRELATION);
        
        return this;
    }
    
    public AlignmentParameters maxShift(final double s) {
        this.maxShift = s;
        return this;
    }
    
    public AlignmentParameters 
            optimizationParameters(final OptimizationParameters p)
    {
        this.optimizationParameters = p;
        return this;
    }
}
