/* 
 * Copyright (C) 2016 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dulab.adap.workflow;

import com.google.common.collect.Range;
import dulab.adap.common.algorithms.machineleanring.OptimizationParameters;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author aleksandrsmirnov
 */
public class TwoStepDecompositionParameters 
{
    public static final String MODEL_PEAK_CHOICE_MZ = "M/z value";
    public static final String MODEL_PEAK_CHOICE_SHARPNESS = "Shaprness";
    public static final String MODEL_PEAK_CHOICE_INTENSITY = "Intensity";
    
    public double minClusterDistance = 8.5;
    public int minClusterSize = 2;
    public double minClusterIntensity = 500.0;
    public boolean useIsShared = false;
    public double edgeToHeightRatio = 0.2;
    public double deltaToHeightRatio = 0.3;
    public double shapeSimThreshold = 18.0;
    public double minModelPeakSharpness = 10.0;
    public String modelPeakChoice = MODEL_PEAK_CHOICE_MZ;
    public List <Range <Double>> deprecatedMZValues = new ArrayList <> ();
    public OptimizationParameters optimizationParams;
    
    public TwoStepDecompositionParameters() {
        optimizationParams = new OptimizationParameters()
                .gradientTolerance(1e-12)
                .costTolerance(1e-12)
                .alpha(10.0)
                .maxIterationCount(10000)
                .verbose(false);
    }
}
