/*
 * Copyright (C) 2018 Du-Lab Team <dulab.binf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package dulab.adap.workflow.peakannotation.rules;

import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import dulab.adap.datamodel.Adduct;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public enum AdductList {

    SHORT_LIST_POS("primary_adducts_pos.csv"),
    SHORT_LIST_NEG("primary_adducts_neg.csv"),
    LONG_LIST_POS("extended_adducts_pos.csv"),
    LONG_LIST_NEG("extended_adducts_neg.csv"),
    GEN_LIST_POS("generated_adducts_pos.csv"),
    GEN_LIST_NEG("generated_adducts_neg.csv");

    private final String filename;

    AdductList(String filename) {
        this.filename = filename;
    }

    public List<Adduct> get() {

        InputStream inputStream = this.getClass().getResourceAsStream(filename);

        List<Adduct> adducts = new ArrayList<>();
        try {

            CSVReader reader = new CSVReaderBuilder(new InputStreamReader(inputStream))
                    .withSkipLines(1)
                    .build();

            String[] row;
            while ((row = reader.readNext()) != null) {
                String name = row[0];
                int numMolecules = Integer.parseInt(row[1]);
                int charge = Integer.parseInt(row[2]);
                double mass = Double.parseDouble(row[3]);
                adducts.add(new Adduct(name, mass, numMolecules, charge));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read CSV file.");
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Cannot parse numbers.");
        }

        return adducts;
    }
}
