/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.ast;

import org.duelengine.css.ast.CombinatorType;
import org.duelengine.css.ast.CssNodeType;
import org.duelengine.css.ast.ValueNode;
import org.duelengine.css.ast.WordBreak;
import org.duelengine.css.parsing.SyntaxException;

public class CombinatorNode
extends ValueNode {
    private CombinatorType combinator;

    public CombinatorNode(CombinatorType combinator, int index, int line, int column) {
        super(CombinatorNode.mapCombinator(combinator, index, line, column), index, line, column);
        this.combinator = combinator;
    }

    public CombinatorNode(CombinatorType combinator) {
        super(CombinatorNode.mapCombinator(combinator, -1, -1, -1));
        this.combinator = combinator;
    }

    @Override
    public CssNodeType getNodeType() {
        return CssNodeType.COMBINATOR;
    }

    public void setCombinator(CombinatorType combinator) {
        this.combinator = combinator;
        super.setValue(CombinatorNode.mapCombinator(combinator, -1, -1, -1));
    }

    @Override
    public void setValue(String value) {
        this.combinator = CombinatorNode.getCombinator(value);
        super.setValue(value);
    }

    protected static String mapCombinator(CombinatorType combinator, int index, int line, int column) {
        if (combinator == null) {
            throw new NullPointerException("combinator");
        }
        switch (combinator) {
            case ADJACENT: {
                return "+";
            }
            case CHILD: {
                return ">";
            }
            case DESCENDANT: {
                return " ";
            }
            case SIBLING: {
                return "~";
            }
            case SELF: {
                return "";
            }
        }
        throw new SyntaxException("Invalid combinator type: " + (Object)((Object)combinator), index, line, column);
    }

    public static CombinatorType getCombinator(String combinator) {
        if (combinator == null || combinator.length() != 1) {
            return null;
        }
        switch (combinator.charAt(0)) {
            case '+': {
                return CombinatorType.ADJACENT;
            }
            case '>': {
                return CombinatorType.CHILD;
            }
            case ' ': {
                return CombinatorType.DESCENDANT;
            }
            case '~': {
                return CombinatorType.SIBLING;
            }
        }
        return null;
    }

    @Override
    public WordBreak getWordBreak(boolean prettyPrint) {
        if (this.combinator == CombinatorType.SELF) {
            return WordBreak.NONE;
        }
        return prettyPrint ? WordBreak.BOTH : WordBreak.NONE;
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof CombinatorNode)) {
            return false;
        }
        CombinatorNode that = (CombinatorNode)arg;
        return !(this.combinator == null ? that.combinator != null : !this.combinator.equals((Object)that.combinator));
    }

    @Override
    public int hashCode() {
        int HASH_PRIME = 1000003;
        int hash = 0;
        if (this.combinator != null) {
            hash = hash * 1000003 + this.combinator.hashCode();
        }
        return hash;
    }
}

