/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.ast;

import org.duelengine.css.ast.ContainerNode;
import org.duelengine.css.ast.CssNodeType;
import org.duelengine.css.ast.WordBreak;
import org.duelengine.css.codegen.CssFormatter;

public abstract class CssNode {
    private final int index;
    private final int line;
    private final int column;
    private ContainerNode parent;

    protected CssNode() {
        this.index = -1;
        this.line = -1;
        this.column = -1;
    }

    protected CssNode(int index, int line, int column) {
        this.index = index;
        this.line = line;
        this.column = column;
    }

    public abstract CssNodeType getNodeType();

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public WordBreak getWordBreak(boolean prettyPrint) {
        return WordBreak.NONE;
    }

    public ContainerNode getParent() {
        return this.parent;
    }

    void setParent(ContainerNode parent) {
        this.parent = parent;
    }

    CssNode eval(ContainerNode context) {
        return this;
    }

    public String toString() {
        try {
            StringBuilder buffer = new StringBuilder();
            new CssFormatter().writeNode(buffer, this, null);
            return buffer.toString();
        }
        catch (Exception ex) {
            return super.toString() + '\n' + ex.getMessage();
        }
    }
}

