/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.ast;

import org.duelengine.css.ast.ContainerNode;
import org.duelengine.css.ast.CssNode;
import org.duelengine.css.ast.CssNodeType;
import org.duelengine.css.ast.ValueNode;
import org.duelengine.css.parsing.InvalidNodeException;

public class DeclarationNode
extends ContainerNode {
    private String ident;
    private boolean important;

    public DeclarationNode(String ident, int index, int line, int column) {
        super(index, line, column);
        this.ident = ident;
    }

    public DeclarationNode(String ident, ValueNode ... expression) {
        super(expression);
        this.ident = ident;
    }

    @Override
    public CssNodeType getNodeType() {
        return CssNodeType.DECLARATION;
    }

    public final void setIdent(String value) {
        this.ident = value;
    }

    public final String getIdent() {
        return this.ident;
    }

    public boolean isImportant() {
        return this.important;
    }

    public void setImportant(boolean value) {
        this.important = value;
    }

    public DeclarationNode withImportant() {
        this.important = true;
        return this;
    }

    @Override
    protected CssNode filterChild(CssNode child) {
        if ((child = super.filterChild(child)) == null || child instanceof ValueNode) {
            return child;
        }
        throw new InvalidNodeException("Declaration may only hold values for its expression", child);
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof DeclarationNode)) {
            return false;
        }
        DeclarationNode that = (DeclarationNode)arg;
        if (this.ident == null ? that.ident != null : !this.ident.equals(that.ident)) {
            return false;
        }
        if (this.important != that.important) {
            return false;
        }
        return super.equals(arg);
    }

    @Override
    public int hashCode() {
        int HASH_PRIME = 1000003;
        int hash = super.hashCode() * 1000003 + Boolean.valueOf(this.important).hashCode();
        if (this.ident != null) {
            hash = hash * 1000003 + this.ident.hashCode();
        }
        return hash;
    }
}

