/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.ast;

import org.duelengine.css.ast.ContainerNode;
import org.duelengine.css.ast.CssNode;
import org.duelengine.css.ast.CssNodeType;
import org.duelengine.css.ast.LessVariableDeclarationNode;
import org.duelengine.css.ast.ValueNode;

public class LessVariableReferenceNode
extends ValueNode {
    public LessVariableReferenceNode(String varRef, int index, int line, int column) {
        super(varRef, index, line, column);
    }

    public LessVariableReferenceNode(String varRef) {
        super(varRef);
    }

    @Override
    public CssNodeType getNodeType() {
        return CssNodeType.LESS_VARIABLE_REFERENCE;
    }

    @Override
    public CssNode eval(ContainerNode context) {
        String varRef = this.getValue();
        if (varRef == null || varRef.isEmpty()) {
            throw new NullPointerException("varRef");
        }
        while (context != null && !context.containsVariable(varRef)) {
            context = context.getParent();
        }
        if (context == null) {
            throw new IllegalStateException("Undeclared variable reference: @" + varRef);
        }
        LessVariableDeclarationNode varDecl = context.getVariable(varRef);
        if (varDecl == null) {
            throw new IllegalStateException("Undeclared variable reference: @" + varRef);
        }
        return varDecl.getValue();
    }
}

