/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.ast;

import org.duelengine.css.ast.ColorNode;
import org.duelengine.css.ast.CssNodeType;
import org.duelengine.css.ast.ValueNode;
import org.duelengine.css.parsing.InvalidNodeException;

public class NumericNode
extends ValueNode {
    private double number;
    private String units;
    private boolean keepUnits;

    public NumericNode(String value, int index, int line, int column) {
        super(value, index, line, column);
    }

    public NumericNode(double number, String units, int index, int line, int column) {
        super(null, index, line, column);
        this.number = number;
        this.units = units;
        super.setValue(this.formatNumber(this.number) + this.units);
    }

    public NumericNode(String value) {
        super(value);
    }

    public NumericNode(double number, String units) {
        super(null);
        this.number = number;
        this.units = units;
        super.setValue(this.formatNumber(this.number) + this.units);
    }

    @Override
    public CssNodeType getNodeType() {
        return CssNodeType.NUMERIC;
    }

    public double getNumber() {
        return this.number;
    }

    public void setNumber(double value) {
        this.number = value;
        super.setValue(this.formatNumber(this.number) + this.units);
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String value) {
        this.units = value;
        super.setValue(this.formatNumber(this.number) + this.units);
    }

    public boolean getKeepUnits() {
        return this.keepUnits;
    }

    public void setKeepUnits(boolean value) {
        this.keepUnits = value;
    }

    @Override
    public String getValue(boolean compact) {
        if (compact) {
            if (!this.keepUnits && this.number == 0.0) {
                return "0";
            }
            return this.formatNumber(this.number) + this.units;
        }
        return super.getValue(compact);
    }

    @Override
    public void setValue(String value) {
        char ch;
        int index;
        super.setValue(value);
        if (value == null || value.isEmpty()) {
            this.number = 0.0;
            this.units = null;
            return;
        }
        for (index = value.length() - 1; index >= 0 && ((ch = value.charAt(index)) < '0' || ch > '9') && ch != '.'; --index) {
        }
        this.units = value.substring(index + 1);
        try {
            this.number = Double.parseDouble(this.units.isEmpty() ? value : value.substring(0, index + 1));
        }
        catch (NumberFormatException ex) {
            this.number = 0.0;
            this.units = null;
        }
    }

    @Override
    public ValueNode add(ValueNode operand) {
        if (operand instanceof NumericNode) {
            NumericNode that = (NumericNode)operand;
            String units = this.units;
            if (units == null || units.isEmpty()) {
                units = that.units;
            } else if (that.units != null && !that.units.isEmpty() && !units.equals(that.units)) {
                throw new InvalidNodeException("Incompatible units: " + this + ", " + that, that);
            }
            return new NumericNode(this.number + that.number, units, this.getIndex(), this.getLine(), this.getColumn());
        }
        if (operand instanceof ColorNode) {
            return operand.add(this);
        }
        return super.add(operand);
    }

    @Override
    public ValueNode subtract(ValueNode operand) {
        if (operand instanceof NumericNode) {
            NumericNode that = (NumericNode)operand;
            String units = this.units;
            if (units == null || units.isEmpty()) {
                units = that.units;
            } else if (that.units != null && !that.units.isEmpty() && !units.equals(that.units)) {
                throw new InvalidNodeException("Incompatible units: " + this + ", " + that, that);
            }
            return new NumericNode(this.number - that.number, units, this.getIndex(), this.getLine(), this.getColumn());
        }
        if (operand instanceof ColorNode) {
            if (this.units != null && !this.units.isEmpty()) {
                throw new InvalidNodeException("Cannot use units when mixing numeric and color: " + this, this);
            }
            ColorNode that = (ColorNode)operand;
            int r = (int)(this.number - (double)that.getRedChannel());
            int g = (int)(this.number - (double)that.getGreenChannel());
            int b = (int)(this.number - (double)that.getBlueChannel());
            return new ColorNode(r, g, b, this.getIndex(), this.getLine(), this.getColumn());
        }
        return super.subtract(operand);
    }

    @Override
    public ValueNode multiply(ValueNode operand) {
        if (operand instanceof NumericNode) {
            NumericNode that = (NumericNode)operand;
            String units = this.units;
            if (units == null || units.isEmpty()) {
                units = that.units;
            } else if (that.units != null && !that.units.isEmpty() && !units.equals(that.units)) {
                throw new InvalidNodeException("Incompatible units: " + this + ", " + that, that);
            }
            return new NumericNode(this.number * that.number, units, this.getIndex(), this.getLine(), this.getColumn());
        }
        if (operand instanceof ColorNode) {
            return operand.multiply(this);
        }
        return super.multiply(operand);
    }

    @Override
    public ValueNode divide(ValueNode operand) {
        if (operand instanceof NumericNode) {
            NumericNode that = (NumericNode)operand;
            String units = this.units;
            if (units == null || units.isEmpty()) {
                units = that.units;
            } else if (that.units != null && !that.units.isEmpty() && !units.equals(that.units)) {
                throw new InvalidNodeException("Incompatible units: " + this + ", " + that, that);
            }
            return new NumericNode(this.number / that.number, units, this.getIndex(), this.getLine(), this.getColumn());
        }
        if (operand instanceof ColorNode) {
            if (this.units != null && !this.units.isEmpty()) {
                throw new InvalidNodeException("Cannot use units when mixing numeric and color: " + this, this);
            }
            ColorNode that = (ColorNode)operand;
            int r = (int)(this.number - (double)that.getRedChannel());
            int g = (int)(this.number - (double)that.getGreenChannel());
            int b = (int)(this.number - (double)that.getBlueChannel());
            return new ColorNode(r, g, b, this.getIndex(), this.getLine(), this.getColumn());
        }
        return super.divide(operand);
    }

    private String formatNumber(double value) {
        if (value == (double)((long)value)) {
            return Long.toString((long)value);
        }
        return Double.toString(value);
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof NumericNode) || !this.getClass().equals(arg.getClass())) {
            return false;
        }
        NumericNode that = (NumericNode)arg;
        if (this.keepUnits != that.keepUnits) {
            return false;
        }
        if (this.units == null ? that.units != null : !this.units.equals(that.units)) {
            return false;
        }
        return this.number == that.number;
    }
}

