/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.compiler;

import org.duelengine.css.compiler.CssCompiler;
import org.duelengine.css.compiler.Settings;

public class CLI {
    private static final String SEPARATOR = "========================================";
    private static final String HELP = "java -jar css.jar\n  --help                       : this help text\n  -in <source-file|source-dir> : file path to the source file or folder (required)\n  -out <target-dir>            : file path to the target output directory (default: <source-dir>)\n  -pretty                      : pretty-prints the output\n  -v                           : verbose output\n";

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println(HELP);
            return;
        }
        Settings settings = new Settings();
        System.out.println(SEPARATOR);
        System.out.println("CSS/LESS for the JVM\n");
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-in".equals(arg)) {
                settings.setSource(args[++i]);
                continue;
            }
            if ("-out".equals(arg)) {
                settings.setTarget(args[++i]);
                continue;
            }
            if ("-pretty".equals(arg)) {
                settings.setPrettyPrint(true);
                continue;
            }
            if ("-v".equals(arg)) {
                settings.setVerbose(true);
                continue;
            }
            if ("--help".equalsIgnoreCase(arg)) {
                System.out.println(HELP);
                System.out.println(SEPARATOR);
                return;
            }
            System.out.println(HELP);
            System.out.println(SEPARATOR);
            return;
        }
        try {
            new CssCompiler().execute(settings);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        System.out.println(SEPARATOR);
    }
}

