/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.parsing;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class CssGrammar {
    private static final String KEYWORDS_RESOURCE = "org.duelengine.css.parsing.CssKeywords";
    private static final String COLOR_RESOURCE = "org.duelengine.css.parsing.CssColors";
    private static ResourceBundle colors;
    private static Map<String, Boolean> pseudo;
    private static Map<String, Boolean> atRules;
    private static Map<String, Boolean> vendorPrefixes;
    private static boolean inited;
    static final char OP_AT_RULE = '@';
    static final char OP_BLOCK_BEGIN = '{';
    static final char OP_BLOCK_END = '}';
    static final char OP_PAIR_DELIM = ':';
    static final char OP_DECL_DELIM = ';';
    static final char OP_MINUS = '-';
    static final char OP_PLUS = '+';
    static final char OP_PERCENT = '%';
    static final char OP_ESCAPE = '\\';
    static final char OP_STRING_DELIM = '\"';
    static final char OP_STRING_DELIM_ALT = '\'';
    static final char OP_STAR = '*';
    static final char OP_HASH = '#';
    static final char OP_DOT = '.';
    static final char OP_ADJACENT = '+';
    static final char OP_CHILD = '>';
    static final char OP_DESCENDANT = ' ';
    static final char OP_SIBLING = '~';
    static final char OP_NAMESPACE_DELIM = '|';
    static final char OP_ATTR_BEGIN = '[';
    static final char OP_ATTR_END = ']';
    static final char OP_MATCH = '=';
    static final char OP_INCLUDES_MATCH = '~';
    static final char OP_DASH_MATCH = '|';
    static final char OP_PREFIX_MATCH = '^';
    static final char OP_SUFFIX_MATCH = '$';
    static final char OP_SUBSTR_MATCH = '*';
    static final char OP_PAREN_BEGIN = '(';
    static final char OP_PAREN_END = ')';
    static final char OP_ITEM_DELIM = ',';
    static final char OP_COMMENT = '/';
    static final String OP_COMMENT_BEGIN = "/*";
    static final String OP_COMMENT_END = "*/";
    static final String OP_COMMENT_ALT_BEGIN = "//";
    static final String OP_COMMENT_ALT_END = "\n";
    static final char OP_IMPORTANT_BEGIN = '!';
    static final String OP_IMPORTANT = "important";

    private CssGrammar() {
    }

    static boolean isPseudoKeyword(String keyword) {
        if (keyword == null || keyword.isEmpty()) {
            return false;
        }
        if (!inited) {
            CssGrammar.initLookups();
        }
        return pseudo.containsKey(keyword);
    }

    public static boolean isAtRuleKeyword(String keyword) {
        if (keyword == null || keyword.isEmpty()) {
            return false;
        }
        keyword = CssGrammar.removeVendorPrefix(keyword);
        return atRules.containsKey(keyword);
    }

    public static String removeVendorPrefix(String keyword) {
        int index;
        String prefix;
        if (keyword == null || keyword.isEmpty()) {
            return keyword;
        }
        if (!inited) {
            CssGrammar.initLookups();
        }
        if (keyword.charAt(0) == '-' && vendorPrefixes.containsKey(prefix = keyword.substring(0, index = keyword.indexOf(45, 1) + 1))) {
            keyword = keyword.substring(index);
        }
        return keyword;
    }

    public static String decodeColor(String keyword) {
        if (keyword == null || keyword.isEmpty()) {
            return null;
        }
        if (colors == null) {
            colors = ResourceBundle.getBundle(COLOR_RESOURCE);
        }
        if (colors.containsKey(keyword)) {
            return colors.getString(keyword);
        }
        return null;
    }

    private static void initLookups() {
        ResourceBundle config = ResourceBundle.getBundle(KEYWORDS_RESOURCE);
        String[] items = config != null && config.containsKey("pseudoClasses") ? config.getString("pseudoClasses").split(",") : new String[]{};
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(items.length);
        for (String value : items) {
            map.put(value, true);
        }
        for (String value : items = config != null && config.containsKey("pseudoElements") ? config.getString("pseudoElements").split(",") : new String[]{}) {
            map.put(value, true);
        }
        pseudo = map;
        items = config != null && config.containsKey("atRules") ? config.getString("atRules").split(",") : new String[]{};
        map = new HashMap(items.length);
        for (String value : items) {
            map.put(value, true);
        }
        atRules = map;
        items = config != null && config.containsKey("vendorPrefixes") ? config.getString("vendorPrefixes").split(",") : new String[]{};
        map = new HashMap(items.length);
        for (String value : items) {
            map.put(value, true);
        }
        vendorPrefixes = map;
    }
}

