/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.duelengine.css.ast.CssNode;
import org.duelengine.css.ast.CssNodeType;
import org.duelengine.css.ast.LessVariableDeclarationNode;

public class ContainerNode
extends CssNode {
    private final List<CssNode> children = new ArrayList<CssNode>();
    private Map<String, LessVariableDeclarationNode> variables;

    public ContainerNode(int index, int line, int column) {
        super(index, line, column);
    }

    protected ContainerNode(CssNode ... children) {
        if (children != null) {
            for (CssNode child : children) {
                this.appendChild(child);
            }
        }
    }

    @Override
    public CssNodeType getNodeType() {
        return CssNodeType.CONTAINER;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int childCount() {
        return this.children.size();
    }

    public List<CssNode> getChildren() {
        return this.children;
    }

    public CssNode getFirstChild() {
        return this.children.isEmpty() ? null : this.children.get(0);
    }

    public CssNode getLastChild() {
        return this.children.isEmpty() ? null : this.children.get(this.children.size() - 1);
    }

    protected CssNode filterChild(CssNode child) {
        return child.eval(this);
    }

    public void appendChild(CssNode child) {
        if ((child = this.filterChild(child)) == null) {
            return;
        }
        this.children.add(child);
        child.setParent(this);
    }

    public boolean removeChild(CssNode oldChild) {
        if (oldChild == null) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            CssNode child = this.children.get(i);
            if (child != oldChild) continue;
            this.children.remove(i);
            child.setParent(null);
            return true;
        }
        return false;
    }

    public boolean replaceChild(CssNode newChild, CssNode oldChild) {
        if (oldChild == null) {
            this.appendChild(newChild);
            return true;
        }
        if ((newChild = this.filterChild(newChild)) == null) {
            return this.removeChild(oldChild);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            CssNode child = this.children.get(i);
            if (child != oldChild) continue;
            this.children.set(i, newChild);
            newChild.setParent(this);
            child.setParent(null);
            return true;
        }
        return false;
    }

    public boolean hasVariables() {
        return this.variables != null && this.variables.size() > 0;
    }

    public Collection<LessVariableDeclarationNode> getVariables() {
        return this.variables != null ? this.variables.values() : null;
    }

    public boolean containsVariable(String name) {
        return this.variables != null && this.variables.containsKey(name);
    }

    public void putVariable(LessVariableDeclarationNode value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, LessVariableDeclarationNode>();
        }
        this.variables.put(value.getIdent(), value);
    }

    public LessVariableDeclarationNode getVariable(String name) {
        if (this.variables == null || !this.variables.containsKey(name)) {
            return null;
        }
        return this.variables.get(name);
    }

    public boolean equals(Object arg) {
        if (!(arg instanceof ContainerNode) || !this.getClass().equals(arg.getClass())) {
            return false;
        }
        ContainerNode that = (ContainerNode)arg;
        if (this.children.size() != that.children.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            CssNode a = this.children.get(i);
            CssNode b = that.children.get(i);
            if (!(a == null ? b != null : !a.equals(b))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int HASH_PRIME = 1000003;
        int hash = 0;
        for (CssNode child : this.children) {
            if (child == null) continue;
            hash = hash * 1000003 + child.hashCode();
        }
        return hash;
    }
}

