/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.ast;

import org.duelengine.css.ast.ContainerNode;
import org.duelengine.css.ast.CssNodeType;
import org.duelengine.css.ast.WordBreak;
import org.duelengine.css.codegen.CssFormatter;

public abstract class CssNode {
    private final int index;
    private final int line;
    private final int column;
    private ContainerNode parent;

    protected CssNode() {
        this.column = -1;
        this.line = -1;
        this.index = -1;
    }

    protected CssNode(int nodeIndex, int nodeLine, int nodeColumn) {
        this.index = nodeIndex;
        this.line = nodeLine;
        this.column = nodeColumn;
    }

    public abstract CssNodeType getNodeType();

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public WordBreak getWordBreak(boolean prettyPrint) {
        return WordBreak.NONE;
    }

    public ContainerNode getParent() {
        return this.parent;
    }

    void setParent(ContainerNode value) {
        this.parent = value;
    }

    CssNode eval(ContainerNode context) {
        return this;
    }

    public String toString() {
        try {
            StringBuilder buffer = new StringBuilder();
            new CssFormatter().writeNode(buffer, this, null);
            return buffer.toString();
        }
        catch (Exception ex) {
            return super.toString() + '\n' + ex.getMessage();
        }
    }
}

