/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.duelengine.css.ast.BlockNode;
import org.duelengine.css.ast.CommentNode;
import org.duelengine.css.ast.CssNode;
import org.duelengine.css.ast.CssNodeType;
import org.duelengine.css.ast.DeclarationNode;
import org.duelengine.css.ast.SelectorNode;
import org.duelengine.css.ast.ValueNode;
import org.duelengine.css.parsing.InvalidNodeException;

public class RuleSetNode
extends BlockNode {
    private final List<SelectorNode> selectors = new ArrayList<SelectorNode>();

    public RuleSetNode(int index, int line, int column) {
        super(index, line, column);
    }

    public RuleSetNode(SelectorNode selector, CssNode ... children) {
        super(children);
        if (selector != null) {
            this.addSelector(selector);
        }
    }

    public RuleSetNode(SelectorNode[] selectors, CssNode ... children) {
        super(children);
        if (selectors != null) {
            for (SelectorNode selector : selectors) {
                this.addSelector(selector);
            }
        }
    }

    @Override
    public CssNodeType getNodeType() {
        return CssNodeType.RULE_SET;
    }

    public Collection<SelectorNode> getSelectors() {
        return this.selectors;
    }

    @Override
    protected CssNode filterChild(CssNode child) {
        if ((child = super.filterChild(child)) == null || child instanceof DeclarationNode || child instanceof CommentNode) {
            return child;
        }
        if (child instanceof RuleSetNode) {
            this.getParent().appendChild(child);
            return null;
        }
        throw new InvalidNodeException("Rule-sets may only directly hold declarations and comments", child);
    }

    public void expandSelectors(Collection<SelectorNode> prefixes) {
        ArrayList<SelectorNode> expanded = new ArrayList<SelectorNode>(prefixes.size() * this.selectors.size());
        for (SelectorNode suffix : this.selectors) {
            ValueNode first = (ValueNode)suffix.getFirstChild();
            boolean mergedSelectors = first.getValue() != null && first.getValue().startsWith("&");
            for (SelectorNode prefix : prefixes) {
                SelectorNode selector = new SelectorNode(new ValueNode[0]);
                expanded.add(selector);
                List<CssNode> parts = selector.getChildren();
                parts.addAll(prefix.getChildren());
                if (!mergedSelectors) {
                    parts.addAll(suffix.getChildren());
                    continue;
                }
                String last = ((ValueNode)parts.get(parts.size() - 1)).getValue();
                parts.set(parts.size() - 1, new ValueNode(last + first.getValue().substring(1), first.getIndex(), first.getLine(), first.getColumn()));
                int length = suffix.childCount();
                for (int i = 1; i < length; ++i) {
                    parts.add(suffix.getChildren().get(i));
                }
            }
        }
        this.selectors.clear();
        for (SelectorNode selector : expanded) {
            this.addSelector(selector);
        }
    }

    public void addSelector(SelectorNode selector) {
        if (selector == null) {
            return;
        }
        this.selectors.add(selector);
        selector.setParent(this);
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof RuleSetNode)) {
            return false;
        }
        RuleSetNode that = (RuleSetNode)arg;
        if (this.selectors.size() != that.selectors.size()) {
            return false;
        }
        int length = this.selectors.size();
        for (int i = 0; i < length; ++i) {
            CssNode a = this.selectors.get(i);
            CssNode b = that.selectors.get(i);
            if (!(a == null ? b != null : !a.equals(b))) continue;
            return false;
        }
        return super.equals(arg);
    }
}

