/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.codegen;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Stack;
import org.duelengine.css.ast.ContainerNode;
import org.duelengine.css.ast.CssNode;
import org.duelengine.css.ast.MultiValueNode;
import org.duelengine.css.ast.OperatorNode;
import org.duelengine.css.ast.ValueNode;
import org.duelengine.css.parsing.InvalidNodeException;

public final class ArithmeticEvaluator {
    public static ValueNode eval(CssNode ... expr) {
        return ArithmeticEvaluator.eval(Arrays.asList(expr));
    }

    public static ValueNode eval(Iterable<CssNode> expr) {
        try {
            Stack<OperatorNode> operators = new Stack<OperatorNode>();
            Stack<ValueNode> operands = new Stack<ValueNode>();
            boolean lastWasVar = false;
            for (CssNode next : expr) {
                if (next instanceof OperatorNode) {
                    int nextPrecedence = ArithmeticEvaluator.precedence((OperatorNode)next);
                    if (nextPrecedence < 0) {
                        ArithmeticEvaluator.flushOperators(operators, operands);
                        operands.add((ValueNode)next);
                    } else {
                        if (lastWasVar && "(".equals(((OperatorNode)next).getValue())) {
                            ArithmeticEvaluator.flushOperators(operators, operands);
                        }
                        ArithmeticEvaluator.processOp(operators, operands, (OperatorNode)next);
                    }
                    lastWasVar = false;
                    continue;
                }
                if (next instanceof ValueNode) {
                    if (lastWasVar) {
                        ArithmeticEvaluator.flushOperators(operators, operands);
                    }
                    operands.push((ValueNode)next);
                    lastWasVar = true;
                    continue;
                }
                throw new InvalidNodeException("Unexpected expression node: " + next.getClass().getName(), next);
            }
            ArithmeticEvaluator.flushOperators(operators, operands);
            int length = operands.size();
            switch (length) {
                case 0: {
                    return null;
                }
                case 1: {
                    return operands.pop();
                }
            }
            ValueNode first = (ValueNode)operands.get(0);
            MultiValueNode multi = new MultiValueNode(first.getIndex(), first.getLine(), first.getColumn());
            ContainerNode container = multi.getContainer();
            for (int i = 0; i < length; ++i) {
                container.appendChild((CssNode)operands.get(i));
            }
            return multi;
        }
        catch (InvalidNodeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Iterator<CssNode> iterator = expr.iterator();
            CssNode node = iterator.hasNext() ? iterator.next() : null;
            throw new InvalidNodeException(ex.getMessage(), node, ex);
        }
    }

    private static void flushOperators(Stack<OperatorNode> operators, Stack<ValueNode> operands) {
        while (!operators.isEmpty()) {
            ValueNode result = ArithmeticEvaluator.evalOp(operators.pop(), operands);
            if (result == null) continue;
            operands.push(result);
        }
    }

    private static void processOp(Stack<OperatorNode> operators, Stack<ValueNode> operands, OperatorNode next) {
        while (true) {
            if (operators.isEmpty() || "(".equals(next.getValue()) || ArithmeticEvaluator.precedence(next) > ArithmeticEvaluator.precedence(operators.peek())) {
                operators.push(next);
                return;
            }
            OperatorNode op = operators.pop();
            if ("(".equals(op.getValue()) && ")".equals(next.getValue())) {
                return;
            }
            ValueNode result = ArithmeticEvaluator.evalOp(op, operands);
            if (result == null) continue;
            operands.push(result);
        }
    }

    private static ValueNode evalOp(OperatorNode op, Stack<ValueNode> operands) {
        String operator = op.getValue();
        if (operator != null && operator.length() == 1) {
            char opCh = operator.charAt(0);
            switch (opCh) {
                case '(': {
                    return null;
                }
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    ValueNode right = operands.pop();
                    ValueNode left = operands.pop();
                    switch (opCh) {
                        case '+': {
                            return left.add(right);
                        }
                        case '-': {
                            return left.subtract(right);
                        }
                        case '*': {
                            return left.multiply(right);
                        }
                        case '/': {
                            return left.divide(right);
                        }
                    }
                }
            }
        }
        return op;
    }

    private static int precedence(OperatorNode node) {
        String operator = node.getValue();
        if (operator != null && operator.length() == 1) {
            switch (operator.charAt(0)) {
                case '(': 
                case ')': {
                    return 0;
                }
                case '+': 
                case '-': {
                    return 1;
                }
                case '*': 
                case '/': {
                    return 2;
                }
            }
        }
        return -1;
    }
}

