/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.parsing;

final class CharUtility {
    CharUtility() {
    }

    public static boolean isNullOrWhiteSpace(String value) {
        if (value == null) {
            return true;
        }
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            if (CharUtility.isWhiteSpace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNewline(int ch) {
        switch (ch) {
            case 10: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOperator(String value) {
        if (value != null) {
            switch (value.length()) {
                case 1: {
                    switch (value.charAt(0)) {
                        case '!': 
                        case '(': 
                        case ')': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '/': 
                        case ':': 
                        case '=': 
                        case '>': 
                        case '[': 
                        case ']': 
                        case '|': 
                        case '~': {
                            return true;
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"~=".equals(value) && !"|=".equals(value) && !"^=".equals(value) && !"$=".equals(value)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isWhiteSpace(int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLetter(int ch) {
        return ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90;
    }

    public static boolean isDigit(int ch) {
        return ch >= 48 && ch <= 57;
    }

    public static boolean isNumeric(int ch) {
        return ch >= 48 && ch <= 57 || ch == 46;
    }

    public static boolean isHexDigit(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }

    public static boolean isEscape(int ch) {
        return ch >= 32 && ch <= 126 || ch >= 128 && ch <= 55295 || ch >= 57344 && ch <= 65533;
    }

    public static boolean isNonAscii(int ch) {
        return ch >= 128 && ch <= 55295 || ch >= 57344 && ch <= 65533;
    }

    public static boolean isUrlChar(int ch) {
        return ch == 92 || ch == 9 || ch == 33 || ch >= 35 && ch <= 126 || CharUtility.isNonAscii(ch);
    }

    public static boolean isStringChar(int ch) {
        return ch == 32 || CharUtility.isUrlChar(ch);
    }

    public static boolean isNameStartChar(int ch) {
        return ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch == 95 || ch == 92 || CharUtility.isNonAscii(ch);
    }

    public static boolean isNameChar(int ch) {
        return CharUtility.isNameStartChar(ch) || ch >= 48 && ch <= 57 || ch == 45;
    }
}

