/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.parsing;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.duelengine.css.parsing.CharUtility;
import org.duelengine.css.parsing.CssGrammar;
import org.duelengine.css.parsing.CssParser;
import org.duelengine.css.parsing.CssToken;
import org.duelengine.css.parsing.CssTokenType;
import org.duelengine.css.parsing.SyntaxException;

public class CssLexer
implements Iterator<CssToken> {
    private static final int EOF = -1;
    private static final int CAPACITY = 16;
    private final CssParser.Syntax syntax;
    private final LineNumberReader reader;
    private final StringBuilder buffer = new StringBuilder(512);
    private CssToken token = CssToken.start;
    private boolean hasToken;
    private int ch;
    private int ch_index = -1;
    private int ch_line = -1;
    private int ch_column = -1;
    private int token_index = -1;
    private int token_column = -1;
    private int token_line = -1;
    private int mark_ch;
    private int mark_index = -1;
    private int mark_column = -1;
    private int mark_line = -1;
    private Throwable lastError;

    public CssLexer(String text) {
        this(new StringReader(text), null);
    }

    public CssLexer(String text, CssParser.Syntax lexSyntax) {
        this(new StringReader(text), lexSyntax);
    }

    public CssLexer(Reader source) {
        this(source, null);
    }

    public CssLexer(Reader source, CssParser.Syntax lexSyntax) {
        this.syntax = lexSyntax == null ? CssParser.Syntax.CSS : lexSyntax;
        this.reader = source instanceof LineNumberReader ? (LineNumberReader)source : new LineNumberReader(source);
        try {
            this.nextChar();
        }
        catch (IOException ex) {
            this.lastError = ex;
            this.token = CssToken.error(ex.getMessage(), this.token_index, this.token_line, this.token_column);
        }
    }

    public int getLine() {
        return this.ch_line;
    }

    public int getColumn() {
        return this.ch_column;
    }

    public int getIndex() {
        return this.ch_index;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public void clearLastError() {
        this.lastError = null;
        if (this.ensureToken().getToken().equals((Object)CssTokenType.ERROR)) {
            this.token = CssToken.start;
        }
    }

    public CssParser.Syntax syntax() {
        return this.syntax;
    }

    @Override
    public boolean hasNext() {
        switch (this.ensureToken().getToken()) {
            case END: 
            case ERROR: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CssToken next() {
        try {
            CssToken cssToken = this.ensureToken();
            return cssToken;
        }
        finally {
            this.hasToken = false;
        }
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CssToken ensureToken() {
        if (this.hasToken) {
            return this.token;
        }
        switch (this.token.getToken()) {
            case END: 
            case ERROR: {
                return this.token;
            }
        }
        boolean isNumber = false;
        try {
            while (CharUtility.isWhiteSpace(this.ch)) {
                this.nextChar();
            }
            this.token_index = this.ch_index;
            this.token_line = this.ch_line;
            this.token_column = this.ch_column;
            switch (this.ch) {
                case 64: {
                    CssToken cssToken = this.scanAtKeyword();
                    return cssToken;
                }
                case 123: {
                    this.nextChar();
                    CssToken cssToken = this.token = CssToken.blockBegin(this.token_index, this.token_line, this.token_column);
                    return cssToken;
                }
                case 125: {
                    this.nextChar();
                    CssToken cssToken = this.token = CssToken.blockEnd(this.token_index, this.token_line, this.token_column);
                    return cssToken;
                }
                case 59: {
                    this.nextChar();
                    CssToken cssToken = this.token = CssToken.ruleDelim(this.token_index, this.token_line, this.token_column);
                    return cssToken;
                }
                case 40: 
                case 44: 
                case 61: 
                case 62: 
                case 91: {
                    String value = String.valueOf((char)this.ch);
                    this.nextChar();
                    CssToken cssToken = this.token = CssToken.operator(value, this.token_index, this.token_line, this.token_column);
                    return cssToken;
                }
                case 34: 
                case 39: {
                    CssToken cssToken = this.scanString();
                    return cssToken;
                }
                case 46: {
                    this.setMark(16);
                    this.nextChar();
                    isNumber = CharUtility.isDigit(this.ch);
                    this.resetMark();
                    break;
                }
                case 45: {
                    this.setMark(16);
                    this.nextChar();
                    isNumber = CharUtility.isNumeric(this.ch);
                    this.resetMark();
                    break;
                }
                case 43: {
                    this.nextChar();
                    CssToken cssToken = this.token = CssToken.operator(String.valueOf('+'), this.token_index, this.token_line, this.token_column);
                    return cssToken;
                }
                case 42: {
                    this.setMark(16);
                    this.nextChar();
                    if (this.ch == 61) {
                        this.nextChar();
                        String star = String.valueOf('*') + '=';
                        CssToken cssToken = this.token = CssToken.operator(star, this.token_index, this.token_line, this.token_column);
                        return cssToken;
                    }
                    this.resetMark();
                    break;
                }
                case 36: 
                case 94: 
                case 126: {
                    String match = String.valueOf((char)this.ch);
                    this.nextChar();
                    if (this.ch == 61) {
                        this.nextChar();
                        match = match + '=';
                    }
                    CssToken cssToken = this.token = CssToken.operator(match, this.token_index, this.token_line, this.token_column);
                    return cssToken;
                }
                case 124: {
                    this.setMark(16);
                    this.nextChar();
                    if (this.ch == 61) {
                        this.nextChar();
                        String star = String.valueOf('|') + '=';
                        CssToken cssToken = this.token = CssToken.operator(star, this.token_index, this.token_line, this.token_column);
                        return cssToken;
                    }
                    this.resetMark();
                    break;
                }
                case 33: {
                    CssToken cssToken = this.scanImportant();
                    return cssToken;
                }
                case 47: {
                    if (this.tryScanComment()) {
                        CssToken cssToken = this.token;
                        return cssToken;
                    }
                    this.nextChar();
                    CssToken cssToken = this.token = CssToken.operator(String.valueOf('/'), this.token_index, this.token_line, this.token_column);
                    return cssToken;
                }
                case -1: {
                    CssToken cssToken = this.token = CssToken.end;
                    return cssToken;
                }
            }
            if (isNumber || CharUtility.isDigit(this.ch)) {
                CssToken value = this.scanNumeric();
                return value;
            }
            CssToken value = this.scanValue();
            return value;
        }
        catch (IOException ex) {
            this.lastError = ex;
            CssToken cssToken = this.token = CssToken.error(ex.getMessage(), this.token_index, this.token_line, this.token_column);
            return cssToken;
        }
        finally {
            this.hasToken = true;
        }
    }

    private CssToken scanValue() throws IOException {
        this.buffer.setLength(0);
        switch (this.ch) {
            case 42: {
                this.buffer.append((char)this.ch);
                this.nextChar();
            }
        }
        block11: while (true) {
            if (CharUtility.isWhiteSpace(this.ch)) {
                this.token = CssLexer.typedValue(this.buffer.toString(), this.token_index, this.token_line, this.token_column);
                return this.token;
            }
            switch (this.ch) {
                case 35: 
                case 46: {
                    this.buffer.append((char)this.ch);
                    this.scanName();
                    continue block11;
                }
                case -1: 
                case 33: 
                case 34: 
                case 36: 
                case 39: 
                case 42: 
                case 43: 
                case 44: 
                case 47: 
                case 59: 
                case 61: 
                case 62: 
                case 94: 
                case 123: 
                case 125: 
                case 126: {
                    this.token = CssLexer.typedValue(this.buffer.toString(), this.token_index, this.token_line, this.token_column);
                    return this.token;
                }
                case 41: 
                case 93: {
                    if (this.buffer.length() > 0) {
                        this.token = CssLexer.typedValue(this.buffer.toString(), this.token_index, this.token_line, this.token_column);
                        return this.token;
                    }
                    this.buffer.append((char)this.ch);
                    this.nextChar();
                    continue block11;
                }
                case 124: {
                    this.setMark(16);
                    this.nextChar();
                    if (this.ch == 61) {
                        this.resetMark();
                        this.token = CssLexer.typedValue(this.buffer.toString(), this.token_index, this.token_line, this.token_column);
                        return this.token;
                    }
                    this.buffer.append('|');
                    continue block11;
                }
                case 40: 
                case 91: {
                    this.buffer.append((char)this.ch);
                    this.nextChar();
                    this.token = CssLexer.typedValue(this.buffer.toString(), this.token_index, this.token_line, this.token_column);
                    return this.token;
                }
                case 58: {
                    this.setMark(16);
                    int start = this.buffer.length();
                    int shift = 1;
                    this.buffer.append(':');
                    if (this.nextChar() == 58) {
                        this.buffer.append(':');
                        this.nextChar();
                        ++shift;
                    }
                    if (CharUtility.isNameStartChar(this.ch)) {
                        this.buffer.append((char)this.ch);
                        for (int i = 1; i <= 16 && CharUtility.isNameChar(this.nextChar()); ++i) {
                            this.buffer.append((char)this.ch);
                        }
                    }
                    if (CssGrammar.isPseudoKeyword(this.buffer.substring(start + shift))) continue block11;
                    this.resetMark();
                    this.buffer.setLength(start);
                    if (this.buffer.length() == 0) {
                        this.nextChar();
                        this.token = CssToken.operator(String.valueOf(':'), this.token_index, this.token_line, this.token_column);
                        return this.token;
                    }
                    this.token = CssLexer.typedValue(this.buffer.toString(), this.token_index, this.token_line, this.token_column);
                    return this.token;
                }
            }
            this.buffer.append((char)this.ch);
            this.nextChar();
        }
    }

    private CssToken scanNumeric() throws IOException {
        this.buffer.setLength(0);
        this.buffer.append((char)this.ch);
        while (CharUtility.isNumeric(this.nextChar())) {
            this.buffer.append((char)this.ch);
        }
        if (this.ch == 37) {
            this.buffer.append('%');
            this.nextChar();
        } else if (CharUtility.isNameStartChar(this.ch)) {
            this.scanIdent(true);
        }
        this.token = CssToken.numeric(this.buffer.toString(), this.token_index, this.token_line, this.token_column);
        return this.token;
    }

    private CssToken scanString() throws IOException {
        this.buffer.setLength(0);
        int delim = this.ch;
        this.buffer.append((char)delim);
        while (this.nextChar() != delim) {
            this.buffer.append((char)this.ch);
            if (this.ch == 92) {
                if (!CharUtility.isEscape(this.nextChar()) && !CharUtility.isNewline(this.ch)) {
                    throw new SyntaxException("Malformed escape sequence", this.token_index, this.token_line, this.token_column);
                }
                this.buffer.append((char)this.ch);
                continue;
            }
            if (CharUtility.isStringChar(this.ch) || this.ch == 34 || this.ch == 39) continue;
            throw new SyntaxException("Unterminated string value", this.token_index, this.token_line, this.token_column);
        }
        this.nextChar();
        this.buffer.append((char)delim);
        this.token = CssToken.stringValue(this.buffer.toString(), this.token_index, this.token_line, this.token_column);
        return this.token;
    }

    private CssToken scanAtKeyword() throws IOException {
        this.nextChar();
        this.token = CssToken.atRule(this.scanIdent(false), this.token_index, this.token_line, this.token_column);
        return this.token;
    }

    private CssToken scanImportant() throws IOException {
        while (CharUtility.isWhiteSpace(this.nextChar())) {
        }
        this.setMark(16);
        int length = "important".length();
        for (int i = 0; i < length; ++i) {
            if (this.ch != "important".charAt(i)) {
                this.resetMark();
                this.token = CssLexer.typedValue("!", this.token_index, this.token_line, this.token_column);
                return this.token;
            }
            this.nextChar();
        }
        this.token = CssToken.important(this.token_index, this.token_line, this.token_column);
        return this.token;
    }

    private String scanIdent(boolean append) throws IOException {
        if (!append) {
            this.buffer.setLength(0);
        }
        if (this.ch == 45) {
            this.buffer.append((char)this.ch);
            this.nextChar();
        }
        if (!CharUtility.isNameStartChar(this.ch)) {
            return this.buffer.toString();
        }
        this.buffer.append((char)this.ch);
        if (this.ch == 92) {
            if (!CharUtility.isEscape(this.nextChar())) {
                throw new SyntaxException("Malformed escape sequence", this.token_index, this.token_line, this.token_column);
            }
            this.buffer.append((char)this.ch);
        }
        return this.scanName();
    }

    private String scanName() throws IOException {
        while (CharUtility.isNameChar(this.nextChar())) {
            this.buffer.append((char)this.ch);
            if (this.ch != 92) continue;
            if (!CharUtility.isEscape(this.nextChar())) {
                throw new SyntaxException("Malformed escape sequence", this.token_index, this.token_line, this.token_column);
            }
            this.buffer.append((char)this.ch);
        }
        return this.buffer.toString();
    }

    private boolean tryScanComment() throws IOException {
        this.setMark(16);
        String value = this.tryScanBlockValue("/*", "*/");
        if (value == null) {
            this.resetMark();
            if (this.syntax == CssParser.Syntax.LESS) {
                this.setMark(16);
                value = this.tryScanBlockValue("//", "\n");
                if (value == null) {
                    this.resetMark();
                    return false;
                }
            } else {
                return false;
            }
        }
        this.token = CssToken.comment(value, this.token_index, this.token_line, this.token_column);
        return true;
    }

    private String tryScanBlockValue(String begin, String end) throws IOException {
        int i;
        int length = begin.length();
        for (i = 0; i < length; ++i) {
            if (this.ch != begin.charAt(i)) {
                return null;
            }
            this.nextChar();
        }
        this.buffer.setLength(0);
        i = 0;
        length = end.length();
        while (this.ch != -1) {
            if (this.ch == end.charAt(i)) {
                if (++i >= length) {
                    this.nextChar();
                    this.buffer.setLength(this.buffer.length() - --length);
                    return this.buffer.toString();
                }
            } else {
                i = 0;
            }
            this.buffer.append((char)this.ch);
            this.nextChar();
        }
        if ("\n".equals(end)) {
            return this.buffer.toString();
        }
        throw new SyntaxException("Unterminated block", this.token_index, this.token_line, this.token_column);
    }

    private static CssToken typedValue(String value, int index, int line, int column) {
        int last;
        int length;
        int n = length = value != null ? value.length() - 1 : -1;
        if ((length == 3 || length == 6) && value.charAt(0) == '#') {
            while (length > 0 && CharUtility.isHexDigit(value.charAt(length))) {
                --length;
            }
            if (length == 0) {
                return CssToken.color(value, index, line, column);
            }
        }
        if (CharUtility.isOperator(value)) {
            return CssToken.operator(value, index, line, column);
        }
        if (CssGrammar.decodeColor(value) != null) {
            return CssToken.color(value, index, line, column);
        }
        int n2 = last = value != null ? value.length() - 1 : -1;
        if (last >= 0) {
            switch (value.charAt(last)) {
                case '(': {
                    return CssToken.func(value.substring(0, last), index, line, column);
                }
                case '[': {
                    return CssToken.accessor(value.substring(0, last), index, line, column);
                }
            }
        }
        return CssToken.value(value, index, line, column);
    }

    private int nextChar() throws IOException {
        int prevLine = this.ch_line;
        this.ch = this.reader.read();
        this.ch_line = this.reader.getLineNumber();
        this.ch_column = prevLine != this.ch_line ? 0 : ++this.ch_column;
        ++this.ch_index;
        return this.ch;
    }

    private void setMark(int bufferSize) throws IOException {
        this.mark_line = this.ch_line;
        this.mark_column = this.ch_column;
        this.mark_index = this.ch_index;
        this.mark_ch = this.ch;
        this.reader.mark(bufferSize);
    }

    private void resetMark() throws IOException {
        this.ch_line = this.mark_line;
        this.ch_column = this.mark_column;
        this.ch_index = this.mark_index;
        this.ch = this.mark_ch;
        this.reader.reset();
    }

    public ArrayList<CssToken> toList() {
        ArrayList<CssToken> list = new ArrayList<CssToken>();
        while (this.hasNext()) {
            list.add(this.next());
        }
        return list;
    }

    public static String decodeString(String value) {
        char ch;
        if (value == null || value.isEmpty()) {
            return value;
        }
        int length = value.length();
        StringBuilder buffer = new StringBuilder(length);
        char delim = value.charAt(0);
        if (delim != '\"' && delim != '\'') {
            return value;
        }
        for (int i = 1; i < length && (ch = value.charAt(i)) != delim; ++i) {
            if (ch == '\\') {
                if (++i >= length) {
                    throw new SyntaxException("Unterminated string value", i, 1, i + 1);
                }
                ch = value.charAt(i);
                if (!CharUtility.isEscape(ch) && !CharUtility.isNewline(ch)) {
                    throw new SyntaxException("Malformed escape sequence", i, 1, i + 1);
                }
                buffer.append(ch);
                continue;
            }
            if (!CharUtility.isStringChar(ch) && ch != '\"' && ch != '\'') {
                throw new SyntaxException("Unterminated string value", i, 1, i + 1);
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String encodeString(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        int length = value.length();
        StringBuilder buffer = new StringBuilder(2 * length);
        buffer.append('\"');
        for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            if (!CharUtility.isStringChar(ch)) {
                buffer.append('\\');
            }
            buffer.append(ch);
        }
        buffer.append('\"');
        return buffer.toString();
    }
}

