/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.css.parsing;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.duelengine.css.ast.AccessorNode;
import org.duelengine.css.ast.AtRuleNode;
import org.duelengine.css.ast.BlockNode;
import org.duelengine.css.ast.ColorNode;
import org.duelengine.css.ast.CombinatorNode;
import org.duelengine.css.ast.CombinatorType;
import org.duelengine.css.ast.CommentNode;
import org.duelengine.css.ast.ContainerNode;
import org.duelengine.css.ast.CssNode;
import org.duelengine.css.ast.DeclarationNode;
import org.duelengine.css.ast.FunctionNode;
import org.duelengine.css.ast.LessVariableDeclarationNode;
import org.duelengine.css.ast.LessVariableReferenceNode;
import org.duelengine.css.ast.NumericNode;
import org.duelengine.css.ast.OperatorNode;
import org.duelengine.css.ast.RuleSetNode;
import org.duelengine.css.ast.SelectorNode;
import org.duelengine.css.ast.StringNode;
import org.duelengine.css.ast.StyleSheetNode;
import org.duelengine.css.ast.ValueNode;
import org.duelengine.css.codegen.ArithmeticEvaluator;
import org.duelengine.css.parsing.CssGrammar;
import org.duelengine.css.parsing.CssLexer;
import org.duelengine.css.parsing.CssToken;
import org.duelengine.css.parsing.CssTokenType;
import org.duelengine.css.parsing.InvalidNodeException;
import org.duelengine.css.parsing.InvalidTokenException;
import org.duelengine.css.parsing.SyntaxException;

public class CssParser {
    private static final String HSL = "hsl";
    private static final String HSLA = "hsla";
    private final Syntax syntax;
    private CssToken next;
    private Iterator<CssToken> tokens;

    public CssParser() {
        this(null);
    }

    public CssParser(Syntax parseSyntax) {
        this.syntax = parseSyntax == null ? Syntax.CSS : parseSyntax;
    }

    public Syntax syntax() {
        return this.syntax;
    }

    public StyleSheetNode parse(CssToken ... tokens) throws IOException {
        return this.parse(tokens != null ? Arrays.asList(tokens).iterator() : null);
    }

    public StyleSheetNode parse(Iterable<CssToken> tokens) throws IOException {
        return this.parse(tokens != null ? tokens.iterator() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleSheetNode parse(Iterator<CssToken> cssTokens) throws IOException {
        if (cssTokens == null) {
            throw new NullPointerException("cssTokens");
        }
        this.tokens = cssTokens;
        try {
            StyleSheetNode document = new StyleSheetNode(0, 0, 0);
            while (this.hasNext()) {
                this.parseStatement(document, false);
            }
            StyleSheetNode styleSheetNode = document;
            return styleSheetNode;
        }
        finally {
            this.tokens = null;
            this.next = null;
        }
    }

    private void parseStatement(ContainerNode parent, boolean isRuleSet) throws IOException {
        switch (this.next.getToken()) {
            case AT_RULE: {
                if (isRuleSet) {
                    throw new InvalidTokenException("Invalid token inside rule-set: " + this.next, this.next);
                }
                this.parseAtRule(parent);
                break;
            }
            case RULE_DELIM: {
                this.next = null;
                break;
            }
            case FUNCTION: 
            case ACCESSOR: 
            case STRING: 
            case NUMERIC: 
            case COLOR: 
            case VALUE: 
            case OPERATOR: {
                this.parseRuleSet(parent, isRuleSet);
                break;
            }
            case COMMENT: {
                parent.appendChild(new CommentNode(this.next.getValue(), this.next.getIndex(), this.next.getLine(), this.next.getColumn()));
                this.next = null;
                break;
            }
            case ERROR: {
                throw this.throwErrorToken(this.next);
            }
            default: {
                throw new InvalidTokenException("Invalid token: " + this.next, this.next);
            }
        }
    }

    private void parseAtRule(ContainerNode parent) throws IOException {
        String keyword = this.next.getValue();
        if (!CssGrammar.isAtRuleKeyword(keyword)) {
            CssToken ident = this.next;
            this.next = null;
            this.parseDeclaration(parent, ident);
            return;
        }
        AtRuleNode atRule = new AtRuleNode(keyword, this.next.getIndex(), this.next.getLine(), this.next.getColumn());
        parent.appendChild(atRule);
        this.next = null;
        while (this.hasNext()) {
            switch (this.next.getToken()) {
                case BLOCK_BEGIN: {
                    BlockNode block = new BlockNode(this.next.getIndex(), this.next.getLine(), this.next.getColumn());
                    atRule.setBlock(block);
                    String canonicalKeyword = CssGrammar.removeVendorPrefix(atRule.getKeyword());
                    boolean asRuleSet = !"media".equals(canonicalKeyword) && !"keyframes".equals(canonicalKeyword);
                    this.parseBlock(block, asRuleSet);
                    return;
                }
                case RULE_DELIM: {
                    this.next = null;
                    return;
                }
            }
            this.parseValue(atRule, this.next, false, NODE_CONTEXT.AT_RULE);
        }
    }

    private void parseRuleSet(ContainerNode parent, boolean nested) throws IOException {
        RuleSetNode nestedParent;
        CssToken ident = this.next;
        this.next = null;
        if (nested && this.hasNext() && CssTokenType.OPERATOR.equals((Object)this.next.getToken()) && ":".equals(this.next.getValue())) {
            this.parseDeclaration(parent, ident);
            return;
        }
        RuleSetNode ruleSet = new RuleSetNode(ident.getIndex(), ident.getLine(), ident.getColumn());
        parent.appendChild(ruleSet);
        RuleSetNode ruleSetNode = nestedParent = parent instanceof RuleSetNode ? (RuleSetNode)parent : null;
        if (this.parseSelector(ruleSet, ident)) {
            if (!nested) {
                throw new InvalidTokenException("Invalid sequence in rule-set: " + ident, ident);
            }
            this.evalMixins(nestedParent, ruleSet);
            return;
        }
        block7: while (this.hasNext()) {
            switch (this.next.getToken()) {
                case BLOCK_BEGIN: {
                    if (nestedParent != null) {
                        ruleSet.expandSelectors(nestedParent.getSelectors());
                    }
                    this.parseBlock(ruleSet, true);
                    return;
                }
                case FUNCTION: 
                case ACCESSOR: 
                case STRING: 
                case NUMERIC: 
                case COLOR: 
                case VALUE: 
                case OPERATOR: {
                    if (!this.parseSelector(ruleSet, this.next)) continue block7;
                    if (!nested) {
                        throw new InvalidTokenException("Invalid sequence in rule-set: " + ident, ident);
                    }
                    this.evalMixins(nestedParent, ruleSet);
                    return;
                }
                case COMMENT: {
                    ruleSet.appendChild(new CommentNode(this.next.getValue(), this.next.getIndex(), this.next.getLine(), this.next.getColumn()));
                    this.next = null;
                    continue block7;
                }
                case ERROR: {
                    throw this.throwErrorToken(this.next);
                }
                case BLOCK_END: {
                    if (!nested) {
                        throw new InvalidTokenException("Invalid token in rule-set: " + this.next, this.next);
                    }
                    return;
                }
            }
            throw new InvalidTokenException("Invalid token in rule-set: " + this.next, this.next);
        }
    }

    private boolean parseSelector(RuleSetNode ruleSet, CssToken start) throws IOException {
        String value;
        SelectorNode selector = new SelectorNode(start.getIndex(), start.getLine(), start.getColumn());
        ruleSet.addSelector(selector);
        int nesting = 0;
        if (start != this.next) {
            switch (start.getToken()) {
                case OPERATOR: {
                    value = start.getValue();
                    if (value != null) {
                        switch (value.charAt(0)) {
                            case '(': {
                                ++nesting;
                                break;
                            }
                            case ')': {
                                --nesting;
                            }
                        }
                    }
                    selector.appendChild(new OperatorNode(value, start.getIndex(), start.getLine(), start.getColumn()));
                    break;
                }
                default: {
                    this.parseValue(selector, start, true, NODE_CONTEXT.SELECTOR);
                }
            }
        }
        block17: while (this.hasNext()) {
            switch (this.next.getToken()) {
                case BLOCK_BEGIN: {
                    return false;
                }
                case BLOCK_END: {
                    return true;
                }
                case RULE_DELIM: {
                    this.next = null;
                    return true;
                }
                case OPERATOR: {
                    value = this.next.getValue();
                    if (value != null) {
                        if (nesting <= 0) {
                            if (",".equals(value)) {
                                this.next = null;
                                return false;
                            }
                            CombinatorType combinator = CombinatorNode.getCombinator(value);
                            if (combinator != null) {
                                selector.appendChild(new CombinatorNode(combinator, this.next.getIndex(), this.next.getLine(), this.next.getColumn()));
                                this.next = null;
                                continue block17;
                            }
                        }
                        switch (value.charAt(0)) {
                            case '(': {
                                ++nesting;
                                break;
                            }
                            case ')': {
                                --nesting;
                            }
                        }
                    }
                    selector.appendChild(new OperatorNode(value, this.next.getIndex(), this.next.getLine(), this.next.getColumn()));
                    this.next = null;
                    continue block17;
                }
            }
            this.parseValue(selector, this.next, true, NODE_CONTEXT.SELECTOR);
        }
        return false;
    }

    private void parseDeclaration(ContainerNode parent, CssToken ident) {
        if (!(this.hasNext() && CssTokenType.OPERATOR.equals((Object)this.next.getToken()) && ":".equals(this.next.getValue()))) {
            throw new InvalidTokenException("Invalid declaration: " + ident, ident);
        }
        this.next = null;
        boolean requiredEval = this.syntax == Syntax.LESS && ident.getToken() == CssTokenType.AT_RULE;
        boolean optionalEval = false;
        DeclarationNode declaration = requiredEval ? new LessVariableDeclarationNode(ident.getValue(), ident.getIndex(), ident.getLine(), ident.getColumn()) : new DeclarationNode(ident.getValue(), ident.getIndex(), ident.getLine(), ident.getColumn());
        parent.appendChild(declaration);
        int nesting = 0;
        block12: while (this.hasNext()) {
            switch (this.next.getToken()) {
                case BLOCK_END: {
                    if (requiredEval || optionalEval) {
                        this.evalExpressions(declaration, requiredEval);
                    }
                    return;
                }
                case AT_RULE: {
                    if (this.syntax != Syntax.LESS) {
                        throw new InvalidTokenException("Invalid declaration: " + ident, ident);
                    }
                    declaration.appendChild(new LessVariableReferenceNode(this.next.getValue(), this.next.getIndex(), this.next.getLine(), this.next.getColumn()));
                    requiredEval = true;
                    this.next = null;
                    continue block12;
                }
                case RULE_DELIM: {
                    if (nesting <= 0) {
                        this.next = null;
                        if (requiredEval || optionalEval) {
                            this.evalExpressions(declaration, requiredEval);
                        }
                        return;
                    }
                    declaration.appendChild(new OperatorNode(";", this.next.getIndex(), this.next.getLine(), this.next.getColumn()));
                    this.next = null;
                    continue block12;
                }
                case OPERATOR: {
                    String value = this.next.getValue();
                    if (value != null) {
                        switch (value.charAt(0)) {
                            case '(': {
                                ++nesting;
                                break;
                            }
                            case ')': {
                                if (--nesting >= 0) break;
                                if (requiredEval || optionalEval) {
                                    this.evalExpressions(declaration, requiredEval);
                                }
                                return;
                            }
                            case '*': 
                            case '+': 
                            case '-': 
                            case '/': {
                                optionalEval = true;
                            }
                        }
                    }
                    declaration.appendChild(new OperatorNode(value, this.next.getIndex(), this.next.getLine(), this.next.getColumn()));
                    this.next = null;
                    continue block12;
                }
                case IMPORTANT: {
                    declaration.setImportant(true);
                    this.next = null;
                    continue block12;
                }
            }
            this.parseValue(declaration, this.next, false, NODE_CONTEXT.DECLARATION);
        }
        if (requiredEval || optionalEval) {
            this.evalExpressions(declaration, requiredEval);
        }
    }

    private FunctionNode parseFunction(ContainerNode parent, CssToken start, boolean isSelector) {
        FunctionNode func = new FunctionNode(start.getValue(), start.getIndex(), start.getLine(), start.getColumn());
        parent.appendChild(func);
        if (this.next == start) {
            this.next = null;
        }
        int nesting = 0;
        ContainerNode args = func.getContainer();
        block13: while (this.hasNext()) {
            String value;
            switch (this.next.getToken()) {
                case OPERATOR: {
                    value = this.next.getValue();
                    if (value != null) {
                        switch (value.charAt(0)) {
                            case '(': {
                                ++nesting;
                                break;
                            }
                            case ')': {
                                if (nesting <= 0) {
                                    if (this.syntax == Syntax.LESS && args.hasVariables() && parent instanceof SelectorNode) {
                                        ContainerNode ruleSet = parent.getParent();
                                        if (ruleSet != null) {
                                            for (LessVariableDeclarationNode variable : args.getVariables()) {
                                                ruleSet.putVariable(variable);
                                            }
                                        }
                                        if (!args.hasChildren()) {
                                            parent.replaceChild(new ValueNode(func.getValue(), func.getIndex(), func.getLine(), func.getColumn()), func);
                                        }
                                    }
                                    this.next = null;
                                    return func;
                                }
                                --nesting;
                                break;
                            }
                            case ',': {
                                if (this.syntax != Syntax.LESS) break;
                            }
                        }
                    }
                    args.appendChild(new OperatorNode(value, this.next.getIndex(), this.next.getLine(), this.next.getColumn()));
                    this.next = null;
                    continue block13;
                }
                case AT_RULE: {
                    CssToken ident = this.next;
                    this.next = null;
                    this.parseDeclaration(args, ident);
                    continue block13;
                }
            }
            value = this.next.getValue();
            if (value != null) {
                switch (value.charAt(0)) {
                    case '(': {
                        ++nesting;
                        break;
                    }
                    case ')': {
                        if (nesting <= 0) {
                            if (args.hasVariables() && parent instanceof SelectorNode) {
                                ContainerNode ruleSet = parent.getParent();
                                if (ruleSet != null) {
                                    for (LessVariableDeclarationNode variable : args.getVariables()) {
                                        ruleSet.putVariable(variable);
                                    }
                                }
                                if (!args.hasChildren()) {
                                    parent.replaceChild(new ValueNode(func.getValue(), func.getIndex(), func.getLine(), func.getColumn()), func);
                                }
                            }
                            this.next = new CssToken(this.next.getToken(), value.substring(1), this.next.getIndex() + 1, this.next.getLine(), this.next.getColumn() + 1);
                            parent.appendChild(new CombinatorNode(CombinatorType.SELF, this.next.getIndex(), this.next.getLine(), this.next.getColumn()));
                            return func;
                        }
                        --nesting;
                    }
                }
            }
            this.parseValue(args, this.next, isSelector, NODE_CONTEXT.FUNCTION);
        }
        return func;
    }

    private void parseAccessor(ContainerNode parent, CssToken start, boolean isSelector) {
        AccessorNode accessor = new AccessorNode(start.getValue(), start.getIndex(), start.getLine(), start.getColumn());
        parent.appendChild(accessor);
        if (this.next == start) {
            this.next = null;
        }
        int nesting = 0;
        ContainerNode args = accessor.getContainer();
        block13: while (this.hasNext()) {
            String value;
            switch (this.next.getToken()) {
                case OPERATOR: {
                    value = this.next.getValue();
                    if (value != null) {
                        switch (value.charAt(0)) {
                            case '(': {
                                ++nesting;
                                break;
                            }
                            case ')': {
                                --nesting;
                                break;
                            }
                            case ']': {
                                if (nesting > 0) break;
                                this.next = null;
                                return;
                            }
                        }
                    }
                    args.appendChild(new OperatorNode(value, this.next.getIndex(), this.next.getLine(), this.next.getColumn()));
                    this.next = null;
                    continue block13;
                }
            }
            value = this.next.getValue();
            if (value != null) {
                switch (value.charAt(0)) {
                    case '(': {
                        ++nesting;
                        break;
                    }
                    case ')': {
                        --nesting;
                        break;
                    }
                    case ']': {
                        if (nesting > 0) break;
                        this.next = new CssToken(this.next.getToken(), value.substring(1), this.next.getIndex() + 1, this.next.getLine(), this.next.getColumn() + 1);
                        parent.appendChild(new CombinatorNode(CombinatorType.SELF, this.next.getIndex(), this.next.getLine(), this.next.getColumn()));
                        return;
                    }
                }
            }
            this.parseValue(args, this.next, isSelector, NODE_CONTEXT.ACCESSOR);
        }
    }

    private void parseValue(ContainerNode parent, CssToken token, boolean isSelector, NODE_CONTEXT context) {
        switch (token.getToken()) {
            case FUNCTION: {
                List<CssNode> args;
                FunctionNode func = this.parseFunction(parent, token, isSelector);
                String fn = func.getValue(true);
                if (!HSL.equals(fn) && !HSLA.equals(fn) || (args = func.getContainer().getChildren()).size() <= 2) break;
                CssNode arg = args.get(2);
                if (arg instanceof NumericNode) {
                    ((NumericNode)arg).setKeepUnits(true);
                }
                if (args.size() <= 4 || !((arg = args.get(4)) instanceof NumericNode)) break;
                ((NumericNode)arg).setKeepUnits(true);
                break;
            }
            case ACCESSOR: {
                this.parseAccessor(parent, token, isSelector);
                break;
            }
            case OPERATOR: {
                parent.appendChild(new OperatorNode(token.getValue(), token.getIndex(), token.getLine(), token.getColumn()));
                break;
            }
            case NUMERIC: {
                if (isSelector) {
                    parent.appendChild(new ValueNode(token.getValue(), token.getIndex(), token.getLine(), token.getColumn()));
                    break;
                }
                parent.appendChild(new NumericNode(token.getValue(), token.getIndex(), token.getLine(), token.getColumn()));
                break;
            }
            case COLOR: {
                if (isSelector) {
                    parent.appendChild(new ValueNode(token.getValue(), token.getIndex(), token.getLine(), token.getColumn()));
                    break;
                }
                parent.appendChild(new ColorNode(token.getValue(), token.getIndex(), token.getLine(), token.getColumn()));
                break;
            }
            case STRING: {
                parent.appendChild(new StringNode(token.getValue(), token.getIndex(), token.getLine(), token.getColumn()));
                break;
            }
            case VALUE: {
                parent.appendChild(new ValueNode(token.getValue(), token.getIndex(), token.getLine(), token.getColumn()));
                break;
            }
            case COMMENT: {
                parent.appendChild(new CommentNode(token.getValue(), token.getIndex(), token.getLine(), token.getColumn()));
                break;
            }
            case ERROR: {
                throw this.throwErrorToken(token);
            }
            case RULE_DELIM: {
                if (context == NODE_CONTEXT.FUNCTION) {
                    parent.appendChild(new OperatorNode(Character.toString(';'), token.getIndex(), token.getLine(), token.getColumn()));
                    break;
                }
            }
            default: {
                throw new InvalidTokenException("Invalid token in " + (Object)((Object)context) + ": " + token, token);
            }
        }
        if (this.next == token) {
            this.next = null;
        }
    }

    private void evalExpressions(DeclarationNode declaration, boolean throwOnError) {
        block2: {
            try {
                ValueNode result = ArithmeticEvaluator.eval(declaration.getChildren());
                declaration.getChildren().clear();
                declaration.appendChild(result);
            }
            catch (InvalidNodeException ex) {
                if (!throwOnError) break block2;
                throw ex;
            }
        }
    }

    private void evalMixins(RuleSetNode targetSet, RuleSetNode nestedSet) {
        if (targetSet == null) {
            throw new SyntaxException("Invalid sequence in rule-set", nestedSet.getIndex(), nestedSet.getLine(), nestedSet.getColumn());
        }
        nestedSet.getParent().removeChild(nestedSet);
        for (SelectorNode selector : nestedSet.getSelectors()) {
            for (CssNode node : targetSet.getParent().getChildren()) {
                RuleSetNode mixin = node instanceof RuleSetNode ? (RuleSetNode)node : null;
                if (mixin == null || !mixin.getSelectors().contains(selector)) continue;
                for (CssNode child : mixin.getChildren()) {
                    targetSet.appendChild(child);
                }
            }
        }
    }

    private void parseBlock(BlockNode block, boolean isRuleSet) throws IOException {
        this.next = null;
        while (this.hasNext() && !CssTokenType.BLOCK_END.equals((Object)this.next.getToken())) {
            this.parseStatement(block, isRuleSet);
        }
        this.next = null;
    }

    private InvalidTokenException throwErrorToken(CssToken token) {
        if (this.tokens instanceof CssLexer) {
            return new InvalidTokenException("Syntax error: " + token, token, ((CssLexer)this.tokens).getLastError());
        }
        return new InvalidTokenException("Syntax error: " + token, token);
    }

    private boolean hasNext() {
        while (this.next == null && this.tokens.hasNext()) {
            this.next = this.tokens.next();
        }
        return this.next != null;
    }

    private static enum NODE_CONTEXT {
        ACCESSOR,
        AT_RULE,
        DECLARATION,
        FUNCTION,
        SELECTOR;

    }

    public static enum Syntax {
        CSS,
        LESS;

    }
}

