/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeStatement;
import org.duelengine.duel.codedom.CodeStatementCollection;
import org.duelengine.duel.codedom.CodeVisitor;

public class CodeConditionStatement
extends CodeStatement {
    private CodeExpression condition;
    private final CodeStatementCollection trueStatements = new CodeStatementCollection(this);
    private final CodeStatementCollection falseStatements = new CodeStatementCollection(this);

    public CodeConditionStatement() {
        this(null, new CodeStatement[0]);
    }

    public CodeConditionStatement(CodeExpression condition, CodeStatement ... trueStatements) {
        this(condition, trueStatements, (CodeStatement[])null);
    }

    public CodeConditionStatement(CodeExpression condition, CodeStatement[] trueStatements, CodeStatement[] falseStatements) {
        this.condition = condition;
        if (trueStatements != null) {
            this.trueStatements.addAll(trueStatements);
        }
        if (falseStatements != null) {
            this.falseStatements.addAll(falseStatements);
        }
    }

    public CodeExpression getCondition() {
        return this.condition;
    }

    public void setCondition(CodeExpression value) {
        this.condition = value;
    }

    public CodeStatementCollection getTrueStatements() {
        return this.trueStatements;
    }

    public CodeStatementCollection getFalseStatements() {
        return this.falseStatements;
    }

    @Override
    public void visit(CodeVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.condition != null) {
                this.condition.visit(visitor);
            }
            for (CodeStatement statement : this.trueStatements) {
                if (statement == null) continue;
                statement.visit(visitor);
            }
            for (CodeStatement statement : this.falseStatements) {
                if (statement == null) continue;
                statement.visit(visitor);
            }
        }
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof CodeConditionStatement)) {
            return false;
        }
        CodeConditionStatement that = (CodeConditionStatement)arg;
        if (this.condition == null ? that.condition != null : !this.condition.equals(that.condition)) {
            return false;
        }
        if (!this.trueStatements.equals(that.trueStatements)) {
            return false;
        }
        return this.falseStatements.equals(that.falseStatements);
    }

    @Override
    public int hashCode() {
        int HASH_PRIME = 1000003;
        int hash = this.trueStatements.hashCode() * 1000003 + this.falseStatements.hashCode();
        if (this.condition != null) {
            hash = hash * 1000003 + this.condition.hashCode();
        }
        return hash;
    }
}

