/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeField;
import org.duelengine.duel.codedom.CodeVisitor;

public class CodeFieldReferenceExpression
extends CodeExpression {
    private CodeExpression target;
    private String fieldName;
    private Class<?> fieldType = Object.class;

    public CodeFieldReferenceExpression() {
    }

    public CodeFieldReferenceExpression(CodeExpression target, Class<?> fieldType, String fieldName) {
        this.target = target;
        this.fieldType = fieldType;
        this.fieldName = fieldName;
    }

    public CodeFieldReferenceExpression(CodeExpression target, CodeField field) {
        this.target = target;
        if (field != null) {
            this.setFieldType(field.getType());
            this.fieldName = field.getName();
        }
    }

    public void setTarget(CodeExpression target) {
        this.target = target;
    }

    public CodeExpression getTarget() {
        return this.target;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value;
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(Class<?> value) {
        this.fieldType = value == null ? Object.class : value;
    }

    @Override
    public Class<?> getResultType() {
        return this.fieldType;
    }

    @Override
    public void visit(CodeVisitor visitor) {
        if (visitor.visit(this) && this.target != null) {
            this.target.visit(visitor);
        }
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof CodeFieldReferenceExpression)) {
            return false;
        }
        CodeFieldReferenceExpression that = (CodeFieldReferenceExpression)arg;
        if (this.target == null ? that.target != null : !this.target.equals(that.target)) {
            return false;
        }
        if (this.fieldName == null ? that.fieldName != null : !this.fieldName.equals(that.fieldName)) {
            return false;
        }
        if (this.fieldType == null ? that.fieldType != null : !this.fieldType.equals(that.fieldType)) {
            return false;
        }
        return super.equals(arg);
    }

    @Override
    public int hashCode() {
        int HASH_PRIME = 1000003;
        int hash = super.hashCode();
        if (this.target != null) {
            hash = hash * 1000003 + this.target.hashCode();
        }
        if (this.fieldName != null) {
            hash = hash * 1000003 + this.fieldName.hashCode();
        }
        if (this.fieldType != null) {
            hash = hash * 1000003 + this.fieldType.hashCode();
        }
        return hash;
    }
}

