/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeExpressionStatement;
import org.duelengine.duel.codedom.CodeObject;
import org.duelengine.duel.codedom.CodeStatement;
import org.duelengine.duel.codedom.CodeStatementBlock;
import org.duelengine.duel.codedom.IdentifierScope;

public class CodeStatementCollection
extends ArrayList<CodeStatement>
implements IdentifierScope {
    private final CodeObject owner;
    private Map<String, String> identMap;
    private int nextID;

    public CodeStatementCollection(CodeObject owner) {
        this.owner = owner;
    }

    public CodeObject getOwner() {
        return this.owner;
    }

    public boolean addAll(CodeStatementBlock block) {
        if (block == null) {
            return false;
        }
        for (CodeStatement statement : block.getStatements()) {
            super.add(statement);
        }
        return true;
    }

    public boolean addAll(CodeStatement[] statements) {
        if (statements == null) {
            return false;
        }
        for (CodeStatement statement : statements) {
            super.add(statement);
        }
        return true;
    }

    @Override
    public boolean add(CodeExpression expression) {
        return this.add(new CodeExpressionStatement(expression));
    }

    public CodeStatement getFirstStatement() {
        if (this.isEmpty()) {
            return null;
        }
        return (CodeStatement)this.get(0);
    }

    public CodeStatement getLastStatement() {
        if (this.isEmpty()) {
            return null;
        }
        return (CodeStatement)this.get(this.size() - 1);
    }

    @Override
    public boolean isLocalIdent(String ident) {
        return this.identMap != null && this.identMap.containsKey(ident);
    }

    @Override
    public String uniqueIdent(String ident) {
        if (this.identMap == null) {
            this.identMap = new HashMap<String, String>();
        } else if (this.identMap.containsKey(ident)) {
            return this.identMap.get(ident);
        }
        String unique = this.nextIdent(ident);
        this.identMap.put(ident, unique);
        return unique;
    }

    @Override
    public String nextIdent(String prefix) {
        return prefix + ++this.nextID;
    }

    @Override
    public Iterator<CodeStatement> iterator() {
        return super.iterator();
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof CodeStatementCollection)) {
            return false;
        }
        CodeStatementCollection that = (CodeStatementCollection)arg;
        int length = this.size();
        if (length != that.size()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            CodeStatement thisStatement = (CodeStatement)this.get(i);
            CodeStatement thatStatement = (CodeStatement)that.get(i);
            if (!(thisStatement == null ? thatStatement != null : !thisStatement.equals(thatStatement))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

