/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.parsing;

import org.duelengine.duel.parsing.BlockValue;
import org.duelengine.duel.parsing.DuelTokenType;

public class DuelToken {
    private final DuelTokenType type;
    private final String value;
    private final BlockValue block;
    private final int index;
    private final int line;
    private final int column;
    static final DuelToken start = new DuelToken(DuelTokenType.LITERAL, -1, -1, -1);
    static final DuelToken end = new DuelToken(DuelTokenType.END, -1, -1, -1);

    private DuelToken(DuelTokenType type, int index, int line, int column) {
        this.type = type;
        this.value = null;
        this.block = null;
        this.index = index;
        this.line = line;
        this.column = column;
    }

    private DuelToken(DuelTokenType type, String value, int index, int line, int column) {
        this.type = type;
        this.value = value;
        this.block = null;
        this.index = index;
        this.line = line;
        this.column = column;
    }

    private DuelToken(DuelTokenType type, BlockValue value, int index, int line, int column) {
        this.type = type;
        this.value = null;
        this.block = value;
        this.index = index;
        this.line = line;
        this.column = column;
    }

    public DuelTokenType getToken() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public BlockValue getBlock() {
        return this.block;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.type.toString());
        if (this.value != null) {
            buffer.append(": ").append(this.value);
        } else if (this.block != null) {
            buffer.append(": ").append(this.block);
        }
        return buffer.toString();
    }

    public boolean equals(Object arg) {
        if (!(arg instanceof DuelToken)) {
            return false;
        }
        DuelToken that = (DuelToken)arg;
        return this.type.equals((Object)that.type) && (this.value == null ? that.value == null : this.value.equals(that.value)) && (this.block == null ? that.block == null : this.block.equals(that.block));
    }

    public int hashCode() {
        int HASH_PRIME = 1000003;
        int hash = this.type.hashCode();
        if (this.value != null) {
            hash = hash * 1000003 + this.value.hashCode();
        }
        if (this.block != null) {
            hash = hash * 1000003 + this.block.hashCode();
        }
        return hash;
    }

    public static DuelToken error(String message) {
        return new DuelToken(DuelTokenType.ERROR, message, -1, -1, -1);
    }

    public static DuelToken error(String message, int index, int line, int column) {
        return new DuelToken(DuelTokenType.ERROR, message, index, line, column);
    }

    public static DuelToken elemBegin(String name) {
        return new DuelToken(DuelTokenType.ELEM_BEGIN, name, -1, -1, -1);
    }

    public static DuelToken elemBegin(String name, int index, int line, int column) {
        return new DuelToken(DuelTokenType.ELEM_BEGIN, name, index, line, column);
    }

    public static DuelToken elemEnd(String name) {
        return new DuelToken(DuelTokenType.ELEM_END, name, -1, -1, -1);
    }

    public static DuelToken elemEnd(String name, int index, int line, int column) {
        return new DuelToken(DuelTokenType.ELEM_END, name, index, line, column);
    }

    public static DuelToken attrName(String name) {
        return new DuelToken(DuelTokenType.ATTR_NAME, name, -1, -1, -1);
    }

    public static DuelToken attrName(String name, int index, int line, int column) {
        return new DuelToken(DuelTokenType.ATTR_NAME, name, index, line, column);
    }

    public static DuelToken attrValue(String value) {
        return new DuelToken(DuelTokenType.ATTR_VALUE, value, -1, -1, -1);
    }

    public static DuelToken attrValue(String value, int index, int line, int column) {
        return new DuelToken(DuelTokenType.ATTR_VALUE, value, index, line, column);
    }

    public static DuelToken attrValue(BlockValue value) {
        return new DuelToken(DuelTokenType.ATTR_VALUE, value, -1, -1, -1);
    }

    public static DuelToken attrValue(BlockValue value, int index, int line, int column) {
        return new DuelToken(DuelTokenType.ATTR_VALUE, value, index, line, column);
    }

    public static DuelToken block(BlockValue value) {
        return new DuelToken(DuelTokenType.BLOCK, value, -1, -1, -1);
    }

    public static DuelToken block(BlockValue value, int index, int line, int column) {
        return new DuelToken(DuelTokenType.BLOCK, value, index, line, column);
    }

    public static DuelToken literal(String value) {
        return new DuelToken(DuelTokenType.LITERAL, value, -1, -1, -1);
    }

    public static DuelToken literal(String value, int index, int line, int column) {
        return new DuelToken(DuelTokenType.LITERAL, value, index, line, column);
    }
}

