/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.ast;

import org.duelengine.duel.ast.BlockNode;

public abstract class CodeBlockNode
extends BlockNode {
    protected CodeBlockNode(String begin, String end, String value, int index, int line, int column) {
        super(begin, end, value, index, line, column);
    }

    protected CodeBlockNode(String begin, String end, String value) {
        super(begin, end, value);
    }

    public ArgList getParamList() {
        String value = this.getValue();
        if (value == null) {
            return ArgList.NONE;
        }
        if (value.indexOf("key") >= 0) {
            return ArgList.KEY;
        }
        if (value.indexOf("count") >= 0) {
            return ArgList.COUNT;
        }
        if (value.indexOf("index") >= 0) {
            return ArgList.INDEX;
        }
        if (value.indexOf("data") >= 0) {
            return ArgList.DATA;
        }
        return ArgList.NONE;
    }

    protected String formatParamList() {
        switch (this.getParamList()) {
            case DATA: {
                return "data";
            }
            case INDEX: {
                return "data, index";
            }
            case COUNT: {
                return "data, index, count";
            }
            case KEY: {
                return "data, index, count, key";
            }
        }
        return "";
    }

    public int getArgSize() {
        switch (this.getParamList()) {
            case DATA: {
                return 1;
            }
            case INDEX: {
                return 2;
            }
            case COUNT: {
                return 3;
            }
            case KEY: {
                return 4;
            }
        }
        return 0;
    }

    public abstract String getClientCode();

    public static enum ArgList {
        NONE,
        DATA,
        INDEX,
        COUNT,
        KEY;

    }
}

