/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import java.util.ArrayList;
import java.util.List;
import org.duelengine.duel.codedom.CodeStatement;
import org.duelengine.duel.codedom.CodeVariableDeclarationStatement;
import org.duelengine.duel.codedom.CodeVisitor;

public class CodeVariableCompoundDeclarationStatement
extends CodeStatement {
    private final List<CodeVariableDeclarationStatement> vars = new ArrayList<CodeVariableDeclarationStatement>();

    public CodeVariableCompoundDeclarationStatement() {
    }

    public CodeVariableCompoundDeclarationStatement(CodeVariableDeclarationStatement ... vars) {
        if (vars != null) {
            for (CodeVariableDeclarationStatement var : vars) {
                this.addVar(var);
            }
        }
    }

    public void addVar(CodeVariableDeclarationStatement value) {
        if (value == null) {
            return;
        }
        this.vars.add(value);
    }

    public List<CodeVariableDeclarationStatement> getVars() {
        return this.vars;
    }

    public CodeVariableDeclarationStatement getVar(int index) {
        return this.vars.get(index);
    }

    @Override
    public void visit(CodeVisitor visitor) {
        if (visitor.visit(this)) {
            for (CodeVariableDeclarationStatement statement : this.vars) {
                if (statement == null) continue;
                statement.visit(visitor);
            }
        }
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof CodeVariableCompoundDeclarationStatement)) {
            return false;
        }
        CodeVariableCompoundDeclarationStatement that = (CodeVariableCompoundDeclarationStatement)arg;
        int length = this.vars.size();
        if (length != that.vars.size()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            CodeVariableDeclarationStatement thisVar = this.vars.get(i);
            CodeVariableDeclarationStatement thatVar = this.vars.get(i);
            if (!(thisVar == null ? thatVar != null : !thisVar.equals(thatVar))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.vars).hashCode();
    }
}

