/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.parsing;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.duelengine.duel.parsing.BlockValue;
import org.duelengine.duel.parsing.CharUtility;
import org.duelengine.duel.parsing.DuelToken;
import org.duelengine.duel.parsing.DuelTokenType;
import org.duelengine.duel.parsing.SyntaxException;

public class DuelLexer
implements Iterator<DuelToken> {
    private static final int EOF = -1;
    private static final String CONFIG_RESOURCE = "org.duelengine.duel.parsing.HTMLCharRefs";
    private static ResourceBundle htmlConfig;
    private final LineNumberReader reader;
    private final StringBuilder buffer = new StringBuilder(512);
    private DuelToken token = DuelToken.start;
    private boolean hasToken;
    private String lastTag;
    private boolean suspendMode;
    private int ch;
    private int index = -1;
    private int column = -1;
    private int line = -1;
    private int token_index = -1;
    private int token_column = -1;
    private int token_line = -1;
    private int mark_ch;
    private int mark_index = -1;
    private int mark_column = -1;
    private int mark_line = -1;
    private Throwable lastError;

    public DuelLexer(String text) {
        this(new StringReader(text));
    }

    public DuelLexer(Reader reader) {
        this.reader = new LineNumberReader(reader);
        try {
            this.nextChar();
        }
        catch (IOException ex) {
            this.lastError = ex;
            this.token = DuelToken.error(ex.getMessage(), this.token_index, this.token_line, this.token_column);
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getIndex() {
        return this.index;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public void clearLastError() {
        this.lastError = null;
        if (this.ensureToken().getToken().equals((Object)DuelTokenType.ERROR)) {
            this.token = DuelToken.start;
        }
    }

    @Override
    public boolean hasNext() {
        switch (this.ensureToken().getToken()) {
            case END: 
            case ERROR: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DuelToken next() {
        try {
            DuelToken duelToken = this.ensureToken();
            return duelToken;
        }
        finally {
            this.hasToken = false;
        }
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DuelToken ensureToken() {
        if (this.hasToken) {
            return this.token;
        }
        this.token_index = this.index;
        this.token_line = this.line;
        this.token_column = this.column;
        try {
            block32: while (true) {
                switch (this.token.getToken()) {
                    case LITERAL: 
                    case BLOCK: {
                        switch (this.ch) {
                            case 60: {
                                if (!this.tryScanBlock(false) && !this.tryScanTag()) break;
                                DuelToken duelToken = this.token;
                                return duelToken;
                            }
                            case -1: {
                                DuelToken duelToken = this.token = DuelToken.end;
                                return duelToken;
                            }
                        }
                        DuelToken duelToken = this.scanLiteral();
                        return duelToken;
                    }
                    case ELEM_BEGIN: 
                    case ATTR_VALUE: {
                        while (CharUtility.isWhiteSpace(this.ch)) {
                            this.nextChar();
                        }
                        switch (this.ch) {
                            case 47: {
                                if (this.nextChar() != 62) break;
                                DuelToken duelToken = this.token = DuelToken.elemEnd(this.lastTag, this.token_index, this.token_line, this.token_column);
                                return duelToken;
                            }
                            case 62: {
                                this.nextChar();
                                this.token = DuelToken.start;
                                continue block32;
                            }
                            case -1: {
                                DuelToken duelToken = this.token = DuelToken.end;
                                return duelToken;
                            }
                        }
                        if (this.tryScanAttrName()) {
                            DuelToken duelToken = this.token;
                            return duelToken;
                        }
                        boolean skip = true;
                        block34: while (true) {
                            if (!skip) continue block32;
                            switch (this.ch) {
                                case -1: 
                                case 47: 
                                case 62: {
                                    skip = false;
                                    continue block34;
                                }
                            }
                            this.nextChar();
                        }
                    }
                    case ATTR_NAME: {
                        if (this.tryScanAttrValue()) {
                            DuelToken duelToken = this.token;
                            return duelToken;
                        }
                        this.token = DuelToken.elemBegin(this.lastTag, this.token_index, this.token_line, this.token_column);
                        continue block32;
                    }
                    case ELEM_END: {
                        while (this.ch != 62 && this.ch != -1) {
                            this.nextChar();
                        }
                        if (this.ch != -1) {
                            this.nextChar();
                        }
                        this.token = DuelToken.start;
                        continue block32;
                    }
                    case END: 
                    case ERROR: {
                        DuelToken duelToken = this.token;
                        return duelToken;
                    }
                }
                continue;
                break;
            }
        }
        catch (IOException ex) {
            this.lastError = ex;
            DuelToken duelToken = this.token = DuelToken.error(ex.getMessage(), this.token_index, this.token_line, this.token_column);
            return duelToken;
        }
        finally {
            this.hasToken = true;
        }
    }

    private DuelToken scanLiteral() throws IOException {
        this.buffer.setLength(0);
        block5: while (true) {
            switch (this.ch) {
                case 60: {
                    if (this.buffer.length() != 0) {
                        this.token = DuelToken.literal(this.buffer.toString(), this.token_index, this.token_line, this.token_column);
                        return this.token;
                    }
                    this.buffer.append((char)this.ch);
                    this.nextChar();
                    continue block5;
                }
                case 38: {
                    this.decodeEntity();
                    continue block5;
                }
                case -1: {
                    this.token = DuelToken.literal(this.buffer.toString(), this.token_index, this.token_line, this.token_column);
                    return this.token;
                }
            }
            this.buffer.append((char)this.ch);
            this.nextChar();
        }
    }

    private void decodeEntity() throws IOException {
        int CAPACITY = 32;
        this.setMark(34);
        StringBuilder entity = new StringBuilder(32);
        boolean isValid = false;
        if (this.nextChar() == 35) {
            int codePoint;
            boolean isHex;
            this.nextChar();
            boolean bl = isHex = this.ch == 120 || this.ch == 88;
            if (isHex) {
                while (CharUtility.isHexDigit(this.nextChar()) && entity.length() < 8) {
                    entity.append((char)this.ch);
                }
            } else {
                while (CharUtility.isDigit(this.ch) && entity.length() < 10) {
                    entity.append((char)this.ch);
                    this.nextChar();
                }
            }
            try {
                codePoint = Integer.parseInt(entity.toString(), isHex ? 16 : 10);
            }
            catch (NumberFormatException ex) {
                codePoint = -1;
            }
            if (codePoint > 0) {
                this.buffer.append(Character.toChars(codePoint));
                isValid = true;
            }
        } else {
            while (CharUtility.isLetter(this.ch) && entity.length() < 32) {
                entity.append((char)this.ch);
                this.nextChar();
            }
            String value = DuelLexer.decodeEntityName(entity.toString());
            if (value != null) {
                this.buffer.append(value);
                isValid = true;
            }
        }
        if (!isValid) {
            this.resetMark();
            this.buffer.append((char)this.ch);
            this.nextChar();
        } else if (this.ch == 59) {
            this.nextChar();
        }
    }

    private static String decodeEntityName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        if (htmlConfig == null) {
            htmlConfig = ResourceBundle.getBundle(CONFIG_RESOURCE);
        }
        if (htmlConfig.containsKey(name)) {
            return htmlConfig.getString(name);
        }
        return null;
    }

    private boolean tryScanTag() throws IOException {
        boolean isEndTag;
        int CAPACITY = 64;
        this.setMark(65);
        this.buffer.setLength(0);
        boolean bl = isEndTag = this.nextChar() == 47;
        if (isEndTag) {
            this.nextChar();
        }
        if (CharUtility.isNameStartChar(this.ch)) {
            this.buffer.append((char)this.ch);
            while (CharUtility.isNameChar(this.nextChar()) && this.buffer.length() < 64) {
                this.buffer.append((char)this.ch);
            }
        }
        if (this.buffer.length() == 0) {
            this.resetMark();
            return false;
        }
        String tagName = this.buffer.toString();
        if (this.suspendMode) {
            if (isEndTag && this.lastTag.equals(tagName)) {
                this.suspendMode = false;
            } else {
                this.resetMark();
                return false;
            }
        }
        this.lastTag = tagName;
        this.token = isEndTag ? DuelToken.elemEnd(this.lastTag, this.token_index, this.token_line, this.token_column) : DuelToken.elemBegin(this.lastTag, this.token_index, this.token_line, this.token_column);
        this.suspendMode = !isEndTag && ("script".equals(this.lastTag) || "style".equals(this.lastTag));
        return true;
    }

    private boolean tryScanAttrName() throws IOException {
        int CAPACITY = 64;
        this.setMark(65);
        this.buffer.setLength(0);
        if (CharUtility.isAttrNameChar(this.ch)) {
            this.buffer.append((char)this.ch);
            while (CharUtility.isAttrNameChar(this.nextChar()) && this.buffer.length() < 64) {
                this.buffer.append((char)this.ch);
            }
        }
        if (this.buffer.length() == 0) {
            this.resetMark();
            return false;
        }
        this.token = DuelToken.attrName(this.buffer.toString(), this.token_index, this.token_line, this.token_column);
        return true;
    }

    private boolean tryScanAttrValue() throws IOException {
        int altDelim;
        int delim;
        while (CharUtility.isWhiteSpace(this.ch)) {
            this.nextChar();
        }
        if (this.ch != 61) {
            return false;
        }
        while (CharUtility.isWhiteSpace(this.nextChar())) {
        }
        switch (this.ch) {
            case 34: 
            case 39: {
                delim = this.ch;
                altDelim = -1;
                this.nextChar();
                break;
            }
            default: {
                delim = 32;
                altDelim = 62;
            }
        }
        if (this.ch != 60 || !this.tryScanBlock(true)) {
            this.scanAttrLiteral(delim, altDelim);
        }
        if (this.ch == delim) {
            this.nextChar();
        }
        return true;
    }

    private DuelToken scanAttrLiteral(int delim, int altDelim) throws IOException {
        this.buffer.setLength(0);
        block4: while (true) {
            switch (this.ch) {
                case -1: {
                    this.token = DuelToken.attrValue(this.buffer.toString(), this.token_index, this.token_line, this.token_column);
                    return this.token;
                }
                case 38: {
                    this.decodeEntity();
                    continue block4;
                }
            }
            if (this.ch == delim || this.ch == altDelim) {
                this.token = DuelToken.attrValue(this.buffer.toString(), this.token_index, this.token_line, this.token_column);
                return this.token;
            }
            this.buffer.append((char)this.ch);
            this.nextChar();
        }
    }

    private boolean tryScanBlock(boolean asAttr) throws IOException {
        int CAPACITY = 16;
        this.setMark(16);
        String value = null;
        String begin = null;
        String end = null;
        block0 : switch (this.nextChar()) {
            case 37: {
                switch (this.nextChar()) {
                    case 45: {
                        begin = "<%--";
                        end = "--%>";
                        value = this.tryScanBlockValue("--", end);
                        break block0;
                    }
                    case 33: 
                    case 35: 
                    case 36: 
                    case 58: 
                    case 61: 
                    case 64: {
                        begin = "<%" + (char)this.ch;
                        end = "%>";
                        value = this.tryScanBlockValue("" + (char)this.ch, end);
                        break block0;
                    }
                }
                begin = "<%";
                end = "%>";
                value = this.tryScanBlockValue("", end);
                break;
            }
            case 33: {
                switch (this.nextChar()) {
                    case 45: {
                        begin = "<!--[";
                        end = "]>";
                        value = this.tryScanBlockValue("--[", end);
                        if (value != null) break block0;
                        this.resetMark();
                        begin = "<!--";
                        end = "-->";
                        value = this.tryScanBlockValue(begin, end);
                        break block0;
                    }
                    case 91: {
                        value = this.tryScanBlockValue("[CDATA[", "]]>");
                        if (value != null) {
                            if (this.ch == 62) {
                                this.nextChar();
                            }
                            this.token = asAttr ? DuelToken.attrValue(value, this.token_index, this.token_line, this.token_column) : DuelToken.literal(value, this.token_index, this.token_line, this.token_column);
                            return true;
                        }
                        this.resetMark();
                        begin = "<![";
                        end = ">";
                        value = this.tryScanBlockValue(begin, end);
                        break block0;
                    }
                }
                begin = "<!";
                end = ">";
                value = this.tryScanBlockValue("", end);
                if (value == null || value.length() < 7 || !value.substring(0, 7).equalsIgnoreCase("doctype")) break;
                value = value.substring(7).trim();
                begin = "<!DOCTYPE";
                break;
            }
            case 63: {
                switch (this.nextChar()) {
                    case 61: {
                        begin = "<?=";
                        end = "?>";
                        value = this.tryScanBlockValue("--", end);
                        break block0;
                    }
                }
                begin = "<?";
                end = "?>";
                value = this.tryScanBlockValue("", end);
                break;
            }
            case 35: {
                switch (this.nextChar()) {
                    case 45: {
                        begin = "<#--";
                        end = "--#>";
                        value = this.tryScanBlockValue("--", end);
                        break block0;
                    }
                    case 43: 
                    case 61: 
                    case 64: {
                        begin = "<#" + (char)this.ch;
                        end = "#>";
                        value = this.tryScanBlockValue("" + (char)this.ch, end);
                        break block0;
                    }
                }
                begin = "<#";
                end = "#>";
                value = this.tryScanBlockValue("", end);
            }
        }
        if (value == null) {
            this.resetMark();
            return false;
        }
        if (this.suspendMode && !asAttr && begin.equals("<!--")) {
            this.token = DuelToken.literal(value, this.token_index, this.token_line, this.token_column);
            return true;
        }
        BlockValue block = new BlockValue(begin, end, value);
        this.token = asAttr ? DuelToken.attrValue(block, this.token_index, this.token_line, this.token_column) : DuelToken.block(block, this.token_index, this.token_line, this.token_column);
        return true;
    }

    private String tryScanBlockValue(String begin, String end) throws IOException {
        int i;
        int length = begin.length();
        for (i = 0; i < length; ++i) {
            if (this.ch != begin.charAt(i)) {
                return null;
            }
            this.nextChar();
        }
        this.buffer.setLength(0);
        i = 0;
        length = end.length();
        while (this.ch != -1) {
            if (this.ch == end.charAt(i)) {
                if (++i >= length) {
                    this.nextChar();
                    this.buffer.setLength(this.buffer.length() - --length);
                    return this.buffer.toString();
                }
            } else {
                i = 0;
            }
            this.buffer.append((char)this.ch);
            this.nextChar();
        }
        throw new SyntaxException("Unterminated block", this.token_index, this.token_line, this.token_column);
    }

    private int nextChar() throws IOException {
        int prevLine = this.line;
        this.ch = this.reader.read();
        this.line = this.reader.getLineNumber();
        this.column = prevLine != this.line ? 0 : ++this.column;
        ++this.index;
        return this.ch;
    }

    private void setMark(int bufferSize) throws IOException {
        this.mark_line = this.line;
        this.mark_column = this.column;
        this.mark_index = this.index;
        this.mark_ch = this.ch;
        this.reader.mark(bufferSize);
    }

    private void resetMark() throws IOException {
        this.line = this.mark_line;
        this.column = this.mark_column;
        this.index = this.mark_index;
        this.ch = this.mark_ch;
        this.reader.reset();
    }

    public ArrayList<DuelToken> toList() {
        ArrayList<DuelToken> list = new ArrayList<DuelToken>();
        while (this.hasNext()) {
            list.add(this.next());
        }
        return list;
    }
}

