/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codegen;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.duelengine.duel.DataEncoder;
import org.duelengine.duel.DuelContext;
import org.duelengine.duel.DuelView;
import org.duelengine.duel.HTMLFormatter;
import org.duelengine.duel.ast.CALLCommandNode;
import org.duelengine.duel.ast.CodeBlockNode;
import org.duelengine.duel.ast.CodeCommentNode;
import org.duelengine.duel.ast.CommandNode;
import org.duelengine.duel.ast.CommentNode;
import org.duelengine.duel.ast.DocTypeNode;
import org.duelengine.duel.ast.DuelNode;
import org.duelengine.duel.ast.ElementNode;
import org.duelengine.duel.ast.ExpressionNode;
import org.duelengine.duel.ast.FORCommandNode;
import org.duelengine.duel.ast.IFCommandNode;
import org.duelengine.duel.ast.LiteralNode;
import org.duelengine.duel.ast.MarkupExpressionNode;
import org.duelengine.duel.ast.PARTCommandNode;
import org.duelengine.duel.ast.UnknownNode;
import org.duelengine.duel.ast.VIEWCommandNode;
import org.duelengine.duel.ast.XORCommandNode;
import org.duelengine.duel.codedom.AccessModifierType;
import org.duelengine.duel.codedom.CodeBinaryOperatorExpression;
import org.duelengine.duel.codedom.CodeBinaryOperatorType;
import org.duelengine.duel.codedom.CodeCastExpression;
import org.duelengine.duel.codedom.CodeCommentStatement;
import org.duelengine.duel.codedom.CodeConditionStatement;
import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeExpressionStatement;
import org.duelengine.duel.codedom.CodeField;
import org.duelengine.duel.codedom.CodeFieldReferenceExpression;
import org.duelengine.duel.codedom.CodeIterationStatement;
import org.duelengine.duel.codedom.CodeMember;
import org.duelengine.duel.codedom.CodeMethod;
import org.duelengine.duel.codedom.CodeMethodInvokeExpression;
import org.duelengine.duel.codedom.CodeMethodReturnStatement;
import org.duelengine.duel.codedom.CodeObjectCreateExpression;
import org.duelengine.duel.codedom.CodeParameterDeclarationExpression;
import org.duelengine.duel.codedom.CodePrimitiveExpression;
import org.duelengine.duel.codedom.CodeStatement;
import org.duelengine.duel.codedom.CodeStatementCollection;
import org.duelengine.duel.codedom.CodeThisReferenceExpression;
import org.duelengine.duel.codedom.CodeTypeDeclaration;
import org.duelengine.duel.codedom.CodeUnaryOperatorExpression;
import org.duelengine.duel.codedom.CodeUnaryOperatorType;
import org.duelengine.duel.codedom.CodeVariableCompoundDeclarationStatement;
import org.duelengine.duel.codedom.CodeVariableDeclarationStatement;
import org.duelengine.duel.codedom.CodeVariableReferenceExpression;
import org.duelengine.duel.codegen.CodeDOMUtility;
import org.duelengine.duel.codegen.CodeGenSettings;
import org.duelengine.duel.codegen.ScriptTranslationException;
import org.duelengine.duel.codegen.ScriptTranslator;
import org.duelengine.duel.parsing.InvalidNodeException;

public class CodeDOMBuilder {
    private final CodeGenSettings settings;
    private final HTMLFormatter formatter;
    private final DataEncoder encoder;
    private final StringBuilder buffer;
    private final Stack<CodeStatementCollection> scopeStack = new Stack();
    private CodeTypeDeclaration viewType;
    private TagMode tagMode;
    private boolean needsExtrasEmitted;
    private boolean hasScripts;

    public CodeDOMBuilder() {
        this(null);
    }

    public CodeDOMBuilder(CodeGenSettings settings) {
        this.settings = settings != null ? settings : new CodeGenSettings();
        this.buffer = new StringBuilder();
        this.formatter = new HTMLFormatter();
        this.encoder = new DataEncoder(this.settings.getNewline(), this.settings.getIndent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeTypeDeclaration buildView(VIEWCommandNode viewNode) throws IOException {
        try {
            String fullName = this.settings.getFullServerName(viewNode.getName());
            int lastDot = fullName.lastIndexOf(46);
            String name = fullName.substring(lastDot + 1);
            String ns = lastDot > 0 ? fullName.substring(0, lastDot) : null;
            this.scopeStack.clear();
            this.tagMode = TagMode.None;
            this.hasScripts = false;
            this.needsExtrasEmitted = true;
            this.viewType = CodeDOMUtility.createViewType(ns, name, new CodeMember[0]);
            CodeMethod method = this.buildRenderMethod(viewNode.getChildren()).withOverride();
            method.setName("render");
            method.setAccess(AccessModifierType.PROTECTED);
            CodeTypeDeclaration codeTypeDeclaration = this.viewType;
            return codeTypeDeclaration;
        }
        finally {
            this.viewType = null;
        }
    }

    private CodeMethod buildRenderMethod(List<DuelNode> content) throws IOException {
        CodeMethod method = new CodeMethod(AccessModifierType.PRIVATE, Void.class, this.viewType.nextIdent("render_"), new CodeParameterDeclarationExpression[]{new CodeParameterDeclarationExpression(DuelContext.class, "context"), new CodeParameterDeclarationExpression(Object.class, "data"), new CodeParameterDeclarationExpression(Integer.TYPE, "index"), new CodeParameterDeclarationExpression(Integer.TYPE, "count"), new CodeParameterDeclarationExpression(String.class, "key")}, new CodeStatement[0]).withThrows(IOException.class);
        this.viewType.add(method);
        this.flushBuffer();
        this.scopeStack.push(method.getStatements());
        for (DuelNode node : content) {
            this.buildNode(node);
        }
        this.flushBuffer();
        this.scopeStack.pop();
        return method;
    }

    private void buildNode(DuelNode node) throws IOException {
        if (node instanceof LiteralNode) {
            if (node instanceof UnknownNode) {
                this.ensureExtrasEmitted(true);
            }
            String literal = ((LiteralNode)node).getValue();
            if (this.tagMode == TagMode.SuspendMode || node instanceof UnknownNode) {
                this.buffer.append(literal);
            } else {
                if (literal != null && literal.length() > 0 && this.tagMode != TagMode.PreMode && this.settings.getNormalizeWhitespace() && (literal = literal.replaceAll("^[\\r\\n]+", "").replaceAll("[\\r\\n]+$", "").replaceAll("\\s+", " ")).isEmpty()) {
                    literal = " ";
                }
                this.formatter.writeLiteral((Appendable)this.buffer, literal, this.settings.getEncodeNonASCII());
            }
        } else if (node instanceof CommandNode) {
            CommandNode command = (CommandNode)node;
            switch (command.getCommand()) {
                case XOR: {
                    this.buildConditional((XORCommandNode)node);
                    break;
                }
                case IF: {
                    this.buildConditional((IFCommandNode)node, this.scopeStack.peek());
                    break;
                }
                case FOR: {
                    this.buildIteration((FORCommandNode)node);
                    break;
                }
                case CALL: {
                    this.buildCall((CALLCommandNode)node);
                    break;
                }
                case PART: {
                    this.buildPartPlaceholder((PARTCommandNode)node);
                    break;
                }
                default: {
                    throw new InvalidNodeException("Invalid command node type: " + (Object)((Object)command.getCommand()), command);
                }
            }
        } else if (node instanceof ElementNode) {
            ElementNode element = (ElementNode)node;
            this.buildElement(element);
        } else if (node instanceof CodeBlockNode) {
            this.buildCodeBlock((CodeBlockNode)node);
        } else if (node instanceof CommentNode) {
            CommentNode comment = (CommentNode)node;
            this.formatter.writeComment((Appendable)this.buffer, comment.getValue());
        } else if (node instanceof DocTypeNode) {
            DocTypeNode doctype = (DocTypeNode)node;
            this.formatter.writeDocType((Appendable)this.buffer, doctype.getValue());
        } else if (node instanceof CodeCommentNode) {
            this.buildComment((CodeCommentNode)node);
        }
    }

    private void buildCall(CALLCommandNode node) throws IOException {
        if (node.isDefer()) {
            this.buildDeferredCall(node);
            return;
        }
        CodeField field = new CodeField(AccessModifierType.PRIVATE, DuelView.class, this.viewType.nextIdent("view_"));
        this.viewType.add(field);
        String viewName = null;
        DuelNode attr = node.getAttribute("view");
        if (attr instanceof LiteralNode) {
            viewName = ((LiteralNode)attr).getValue();
        } else if (attr instanceof ExpressionNode) {
            viewName = ((ExpressionNode)attr).getValue();
        }
        if (viewName == null) {
            throw new InvalidNodeException("Unexpected Call command view attribute: " + attr, attr);
        }
        viewName = this.settings.getFullServerName(viewName);
        CodeExpression[] ctorArgs = new CodeExpression[node.getChildren().size()];
        int i = 0;
        for (DuelNode child : node.getChildren()) {
            ctorArgs[i++] = this.buildPart((PARTCommandNode)child);
        }
        CodeMethod initMethod = this.ensureInitMethod();
        initMethod.getStatements().add(new CodeExpressionStatement(new CodeBinaryOperatorExpression(CodeBinaryOperatorType.ASSIGN, new CodeFieldReferenceExpression(new CodeThisReferenceExpression(), field), new CodeObjectCreateExpression(viewName.trim(), ctorArgs))));
        DuelNode callData = node.getAttribute("data");
        CodeExpression dataExpr = callData instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callData, false) : new CodeVariableReferenceExpression(Object.class, "data");
        DuelNode callIndex = node.getAttribute("index");
        CodeExpression indexExpr = callIndex instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callIndex, false) : new CodeVariableReferenceExpression(Integer.TYPE, "index");
        DuelNode callCount = node.getAttribute("count");
        CodeExpression countExpr = callCount instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callCount, false) : new CodeVariableReferenceExpression(Integer.TYPE, "count");
        DuelNode callKey = node.getAttribute("key");
        CodeExpression keyExpr = callKey instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callKey, false) : new CodeVariableReferenceExpression(String.class, "key");
        this.flushBuffer();
        CodeStatementCollection scope = this.scopeStack.peek();
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "renderView", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeFieldReferenceExpression(new CodeThisReferenceExpression(), field), dataExpr, indexExpr, countExpr, keyExpr));
    }

    private void buildDeferredCall(CALLCommandNode node) throws IOException {
        boolean prettyPrint = this.encoder.isPrettyPrint();
        CodeStatementCollection scope = this.scopeStack.peek();
        this.hasScripts = true;
        this.formatter.writeOpenElementBeginTag((Appendable)this.buffer, "script").writeAttribute((Appendable)this.buffer, "type", "text/javascript").writeOpenAttribute((Appendable)this.buffer, "id");
        CodeVariableDeclarationStatement idVar = this.emitClientID();
        this.formatter.writeCloseAttribute((Appendable)this.buffer).writeCloseElementBeginTag((Appendable)this.buffer);
        this.ensureExtrasEmitted(false);
        String viewName = null;
        DuelNode callView = node.getAttribute("view");
        if (callView instanceof LiteralNode) {
            viewName = ((LiteralNode)callView).getValue();
        } else if (callView instanceof ExpressionNode) {
            viewName = ((ExpressionNode)callView).getValue();
        }
        if (viewName != null) {
            viewName = this.settings.getFullClientName(viewName);
            this.buffer.append(viewName);
        } else {
            this.buffer.append("duel(");
            if (!(callView instanceof CodeBlockNode)) {
                throw new InvalidNodeException("Unexpected Call command view attribute: " + callView, callView);
            }
            CodeExpression viewExpr = this.translateExpression((CodeBlockNode)callView, false);
            this.flushBuffer();
            scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), viewExpr, CodePrimitiveExpression.ONE));
            this.buffer.append(")");
        }
        this.buffer.append("(");
        this.flushBuffer();
        DuelNode callData = node.getAttribute("data");
        CodeExpression dataExpr = callData instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callData, false) : new CodeVariableReferenceExpression(Object.class, "data");
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), dataExpr, CodePrimitiveExpression.ONE));
        this.buffer.append(',');
        if (prettyPrint) {
            this.buffer.append(' ');
        }
        this.flushBuffer();
        DuelNode callIndex = node.getAttribute("index");
        CodeExpression indexExpr = callIndex instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callIndex, false) : new CodeVariableReferenceExpression(Integer.TYPE, "index");
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), indexExpr, CodePrimitiveExpression.ONE));
        this.buffer.append(',');
        if (prettyPrint) {
            this.buffer.append(' ');
        }
        this.flushBuffer();
        DuelNode callCount = node.getAttribute("count");
        CodeExpression countExpr = callCount instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callCount, false) : new CodeVariableReferenceExpression(Integer.TYPE, "count");
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), countExpr, CodePrimitiveExpression.ONE));
        this.buffer.append(',');
        if (prettyPrint) {
            this.buffer.append(' ');
        }
        this.flushBuffer();
        DuelNode callKey = node.getAttribute("key");
        CodeExpression keyExpr = callKey instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callKey, false) : new CodeVariableReferenceExpression(String.class, "key");
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), keyExpr, CodePrimitiveExpression.ONE));
        this.buffer.append(").toDOM(");
        this.flushBuffer();
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(idVar), CodePrimitiveExpression.ONE));
        this.buffer.append(");");
        this.formatter.writeElementEndTag((Appendable)this.buffer, "script");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodeObjectCreateExpression buildPart(PARTCommandNode node) throws IOException {
        CodeTypeDeclaration part = CodeDOMUtility.createPartType(this.viewType.nextIdent("part_"), new CodeMember[0]);
        this.viewType.add(part);
        String partName = node.getName();
        if (partName == null) {
            throw new InvalidNodeException("PART command is missing name", node);
        }
        CodeMethod getNameMethod = new CodeMethod(AccessModifierType.PUBLIC, String.class, "getPartName", null, new CodeMethodReturnStatement(new CodePrimitiveExpression(partName))).withOverride();
        part.add(getNameMethod);
        CodeTypeDeclaration parentView = this.viewType;
        try {
            this.viewType = part;
            CodeMethod renderMethod = this.buildRenderMethod(node.getChildren()).withOverride();
            renderMethod.setName("render");
            renderMethod.setAccess(AccessModifierType.PROTECTED);
        }
        finally {
            this.viewType = parentView;
        }
        return new CodeObjectCreateExpression(part.getTypeName(), new CodeExpression[0]);
    }

    private void buildPartPlaceholder(PARTCommandNode part) throws IOException {
        CodeObjectCreateExpression createPart = this.buildPart(part);
        CodeMethod initMethod = this.ensureInitMethod();
        initMethod.getStatements().add(new CodeExpressionStatement(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "addPart", createPart)));
        CodeStatementCollection scope = this.scopeStack.peek();
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "renderPart", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodePrimitiveExpression(part.getName()), new CodeVariableReferenceExpression(Object.class, "data"), new CodeVariableReferenceExpression(Integer.TYPE, "index"), new CodeVariableReferenceExpression(Integer.TYPE, "count"), new CodeVariableReferenceExpression(String.class, "key")));
    }

    private void buildIteration(FORCommandNode node) throws IOException {
        if (!node.hasChildren()) {
            return;
        }
        CodeStatementCollection scope = this.scopeStack.peek();
        CodeMethod innerBind = this.buildRenderMethod(node.getChildren());
        DuelNode loopCount = node.getAttribute("count");
        if (loopCount instanceof CodeBlockNode) {
            CodeExpression countExpr = this.translateExpression((CodeBlockNode)loopCount, false);
            DuelNode loopData = node.getAttribute("data");
            CodeExpression dataExpr = loopData instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)loopData, false) : new CodeVariableReferenceExpression(Object.class, "data");
            this.buildIterationCount(scope, countExpr, dataExpr, innerBind);
        } else {
            DuelNode loopObj = node.getAttribute("in");
            if (loopObj instanceof CodeBlockNode) {
                CodeExpression objExpr = this.translateExpression((CodeBlockNode)loopObj, false);
                this.buildIterationObject(scope, objExpr, innerBind);
            } else {
                DuelNode loopArray = node.getAttribute("each");
                if (!(loopArray instanceof CodeBlockNode)) {
                    throw new InvalidNodeException("FOR loop missing arguments", loopArray);
                }
                CodeExpression arrayExpr = this.translateExpression((CodeBlockNode)loopArray, false);
                this.buildIterationArray(scope, arrayExpr, innerBind);
            }
        }
    }

    private void buildIterationCount(CodeStatementCollection scope, CodeExpression count, CodeExpression data, CodeMethod innerBind) {
        CodeVariableDeclarationStatement dataDecl = new CodeVariableDeclarationStatement(Object.class, scope.nextIdent("data_"), data);
        scope.add(dataDecl);
        CodeVariableDeclarationStatement indexDecl = new CodeVariableDeclarationStatement(Integer.TYPE, scope.nextIdent("index_"), CodePrimitiveExpression.ZERO);
        CodeVariableDeclarationStatement countDecl = new CodeVariableDeclarationStatement(Integer.TYPE, scope.nextIdent("count_"), count);
        CodeVariableCompoundDeclarationStatement initStatement = new CodeVariableCompoundDeclarationStatement(indexDecl, countDecl);
        scope.add(new CodeIterationStatement(initStatement, new CodeBinaryOperatorExpression(CodeBinaryOperatorType.LESS_THAN, new CodeVariableReferenceExpression(indexDecl), new CodeVariableReferenceExpression(countDecl)), new CodeExpressionStatement(new CodeUnaryOperatorExpression(CodeUnaryOperatorType.POST_INCREMENT, new CodeVariableReferenceExpression(indexDecl))), new CodeExpressionStatement(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), innerBind.getName(), new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(dataDecl), new CodeVariableReferenceExpression(indexDecl), new CodeVariableReferenceExpression(countDecl), CodePrimitiveExpression.NULL))));
    }

    private void buildIterationObject(CodeStatementCollection scope, CodeExpression objExpr, CodeMethod innerBind) {
        CodeMethodInvokeExpression data = new CodeMethodInvokeExpression(Set.class, CodeDOMUtility.ensureMap(objExpr), "entrySet", new CodeExpression[0]);
        CodeVariableDeclarationStatement collectionDecl = new CodeVariableDeclarationStatement(Collection.class, scope.nextIdent("items_"), data);
        scope.add(collectionDecl);
        CodeVariableDeclarationStatement indexDecl = new CodeVariableDeclarationStatement(Integer.TYPE, scope.nextIdent("index_"), CodePrimitiveExpression.ZERO);
        CodeVariableDeclarationStatement countDecl = new CodeVariableDeclarationStatement(Integer.TYPE, scope.nextIdent("count_"), new CodeMethodInvokeExpression(Integer.TYPE, new CodeVariableReferenceExpression(collectionDecl), "size", new CodeExpression[0]));
        scope.add(new CodeVariableCompoundDeclarationStatement(indexDecl, countDecl));
        CodeVariableDeclarationStatement iteratorDecl = new CodeVariableDeclarationStatement(Iterator.class, scope.nextIdent("iterator_"), new CodeMethodInvokeExpression(Iterator.class, new CodeVariableReferenceExpression(collectionDecl), "iterator", new CodeExpression[0]));
        CodeVariableDeclarationStatement entryDecl = new CodeVariableDeclarationStatement(Map.Entry.class, scope.nextIdent("entry_"), new CodeCastExpression(Map.Entry.class, new CodeMethodInvokeExpression(Object.class, new CodeVariableReferenceExpression(iteratorDecl), "next", new CodeExpression[0])));
        scope.add(new CodeIterationStatement(iteratorDecl, new CodeMethodInvokeExpression(Boolean.TYPE, new CodeVariableReferenceExpression(iteratorDecl), "hasNext", new CodeExpression[0]), new CodeExpressionStatement(new CodeUnaryOperatorExpression(CodeUnaryOperatorType.POST_INCREMENT, new CodeVariableReferenceExpression(indexDecl))), entryDecl, new CodeExpressionStatement(new CodeMethodInvokeExpression(innerBind.getReturnType(), new CodeThisReferenceExpression(), innerBind.getName(), new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeMethodInvokeExpression(Object.class, new CodeVariableReferenceExpression(entryDecl), "getValue", new CodeExpression[0]), new CodeVariableReferenceExpression(indexDecl), new CodeVariableReferenceExpression(countDecl), CodeDOMUtility.ensureString(new CodeMethodInvokeExpression(Object.class, new CodeVariableReferenceExpression(entryDecl), "getKey", new CodeExpression[0]))))));
    }

    private void buildIterationArray(CodeStatementCollection scope, CodeExpression arrayExpr, CodeMethod innerBind) {
        CodeExpression items = CodeDOMUtility.ensureCollection(arrayExpr);
        CodeVariableDeclarationStatement collectionDecl = new CodeVariableDeclarationStatement(Collection.class, scope.nextIdent("items_"), items);
        scope.add(collectionDecl);
        CodeVariableDeclarationStatement indexDecl = new CodeVariableDeclarationStatement(Integer.TYPE, scope.nextIdent("index_"), CodePrimitiveExpression.ZERO);
        CodeVariableDeclarationStatement countDecl = new CodeVariableDeclarationStatement(Integer.TYPE, scope.nextIdent("count_"), new CodeMethodInvokeExpression(Integer.TYPE, new CodeVariableReferenceExpression(collectionDecl), "size", new CodeExpression[0]));
        scope.add(new CodeVariableCompoundDeclarationStatement(indexDecl, countDecl));
        CodeVariableDeclarationStatement iteratorDecl = new CodeVariableDeclarationStatement(Iterator.class, scope.nextIdent("iterator_"), new CodeMethodInvokeExpression(Iterator.class, new CodeVariableReferenceExpression(collectionDecl), "iterator", new CodeExpression[0]));
        scope.add(new CodeIterationStatement(iteratorDecl, new CodeMethodInvokeExpression(Boolean.TYPE, new CodeVariableReferenceExpression(iteratorDecl), "hasNext", new CodeExpression[0]), new CodeExpressionStatement(new CodeUnaryOperatorExpression(CodeUnaryOperatorType.POST_INCREMENT, new CodeVariableReferenceExpression(indexDecl))), new CodeExpressionStatement(new CodeMethodInvokeExpression(innerBind.getReturnType(), new CodeThisReferenceExpression(), innerBind.getName(), new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeMethodInvokeExpression(Map.Entry.class, new CodeVariableReferenceExpression(iteratorDecl), "next", new CodeExpression[0]), new CodeVariableReferenceExpression(indexDecl), new CodeVariableReferenceExpression(countDecl), CodePrimitiveExpression.NULL))));
    }

    private void buildConditional(XORCommandNode node) throws IOException {
        CodeStatementCollection scope = this.scopeStack.peek();
        for (DuelNode conditional : node.getChildren()) {
            if (!(conditional instanceof IFCommandNode)) continue;
            scope = this.buildConditional((IFCommandNode)conditional, scope);
        }
    }

    private CodeStatementCollection buildConditional(IFCommandNode node, CodeStatementCollection scope) throws IOException {
        this.flushBuffer();
        CodeBlockNode testNode = node.getTest();
        if (testNode == null) {
            if (node.hasChildren()) {
                this.scopeStack.push(scope);
                for (DuelNode child : node.getChildren()) {
                    this.buildNode(child);
                }
                this.flushBuffer();
                this.scopeStack.pop();
            }
            return scope;
        }
        CodeConditionStatement condition = new CodeConditionStatement();
        scope.add(condition);
        condition.setCondition(this.translateExpression(testNode, false));
        if (node.hasChildren()) {
            this.scopeStack.push(condition.getTrueStatements());
            for (DuelNode child : node.getChildren()) {
                this.buildNode(child);
            }
            this.flushBuffer();
            this.scopeStack.pop();
        }
        return condition.getFalseStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodeExpression translateExpression(CodeBlockNode node, boolean canWrite) {
        try {
            List<CodeMember> members = new ScriptTranslator(this.viewType).translate(node.getClientCode());
            boolean firstIsMethod = members.size() > 0 && members.get(0) instanceof CodeMethod;
            CodeMethod method = firstIsMethod ? (CodeMethod)members.get(0) : null;
            CodeExpression expression = null;
            if (firstIsMethod) {
                expression = CodeDOMUtility.inlineMethod(method);
            }
            if (expression != null) {
                int length = members.size();
                for (int i = 1; i < length; ++i) {
                    this.viewType.add(members.get(i));
                }
            } else if (firstIsMethod) {
                this.viewType.addAll(members);
                expression = new CodeMethodInvokeExpression(method.getReturnType(), new CodeThisReferenceExpression(), method.getName(), new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Object.class, "data"), new CodeVariableReferenceExpression(Integer.TYPE, "index"), new CodeVariableReferenceExpression(Integer.TYPE, "count"), new CodeVariableReferenceExpression(String.class, "key"));
            }
            if (method.getUserData("EXTRA_ASSIGN") != null) {
                this.needsExtrasEmitted = true;
            }
            if (canWrite && method != null && method.getUserData("EXTRA_REFS") instanceof Object[]) {
                this.needsExtrasEmitted = true;
                Object[] refs = (Object[])members.get(0).getUserData("EXTRA_REFS");
                CodeExpression[] args = new CodeExpression[refs.length + 1];
                args[0] = new CodeVariableReferenceExpression(DuelContext.class, "context");
                int length = refs.length;
                for (int i = 0; i < length; ++i) {
                    args[i + 1] = new CodePrimitiveExpression(refs[i]);
                }
                CodeConditionStatement runtimeCheck = new CodeConditionStatement((CodeExpression)new CodeMethodInvokeExpression(Boolean.TYPE, new CodeThisReferenceExpression(), "hasExtras", args), new CodeStatement[0]);
                if (firstIsMethod && expression instanceof CodeMethodInvokeExpression) {
                    runtimeCheck.getTrueStatements().addAll(method.getStatements());
                    this.viewType.getMembers().remove(method);
                } else {
                    runtimeCheck.getTrueStatements().add(new CodeMethodReturnStatement(expression));
                }
                CodeMethod runtimeCheckMethod = new CodeMethod(AccessModifierType.PRIVATE, Object.class, this.viewType.nextIdent("hybrid_"), new CodeParameterDeclarationExpression[]{new CodeParameterDeclarationExpression(DuelContext.class, "context"), new CodeParameterDeclarationExpression(Object.class, "data"), new CodeParameterDeclarationExpression(Integer.TYPE, "index"), new CodeParameterDeclarationExpression(Integer.TYPE, "count"), new CodeParameterDeclarationExpression(String.class, "key")}, runtimeCheck).withThrows(IOException.class);
                this.viewType.add(runtimeCheckMethod);
                this.flushBuffer();
                this.scopeStack.push(runtimeCheck.getFalseStatements());
                try {
                    this.buildDeferredWrite(node.getClientCode(), node.getArgSize());
                    this.flushBuffer();
                }
                finally {
                    this.scopeStack.pop();
                }
                runtimeCheck.getFalseStatements().add(new CodeMethodReturnStatement(CodePrimitiveExpression.NULL));
                expression = new CodeMethodInvokeExpression(runtimeCheckMethod.getReturnType(), new CodeThisReferenceExpression(), runtimeCheckMethod.getName(), new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Object.class, "data"), new CodeVariableReferenceExpression(Integer.TYPE, "index"), new CodeVariableReferenceExpression(Integer.TYPE, "count"), new CodeVariableReferenceExpression(String.class, "key"));
            }
            return expression;
        }
        catch (ScriptTranslationException ex) {
            throw ex.adjustErrorStatistics(node);
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            if (message == null) {
                message = ex.toString();
            }
            throw new InvalidNodeException(message, node, ex);
        }
    }

    private void buildDeferredWrite(String clientCode, int argSize) throws IOException {
        boolean prettyPrint = this.encoder.isPrettyPrint();
        CodeStatementCollection scope = this.scopeStack.peek();
        this.hasScripts = true;
        this.formatter.writeOpenElementBeginTag((Appendable)this.buffer, "script").writeAttribute((Appendable)this.buffer, "type", "text/javascript").writeCloseElementBeginTag((Appendable)this.buffer);
        this.ensureExtrasEmitted(false);
        this.buffer.append("duel(");
        this.buffer.append(clientCode);
        this.buffer.append(")(");
        if (argSize > 0) {
            this.flushBuffer();
            scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Object.class, "data"), CodePrimitiveExpression.ONE));
            if (argSize > 1) {
                this.buffer.append(',');
                if (prettyPrint) {
                    this.buffer.append(' ');
                }
                this.flushBuffer();
                scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Integer.TYPE, "index"), CodePrimitiveExpression.ONE));
                if (argSize > 2) {
                    this.buffer.append(',');
                    if (prettyPrint) {
                        this.buffer.append(' ');
                    }
                    this.flushBuffer();
                    scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Integer.TYPE, "count"), CodePrimitiveExpression.ONE));
                    if (argSize > 3) {
                        this.buffer.append(',');
                        if (prettyPrint) {
                            this.buffer.append(' ');
                        }
                        this.flushBuffer();
                        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(String.class, "key"), CodePrimitiveExpression.ONE));
                    }
                }
            }
        }
        this.buffer.append(").write();");
        this.formatter.writeElementEndTag((Appendable)this.buffer, "script");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildElement(ElementNode element) throws IOException {
        String tagName = element.getTagName();
        if ("script".equalsIgnoreCase(tagName)) {
            this.hasScripts = true;
            this.ensureExtrasEmitted(true);
        }
        this.formatter.writeOpenElementBeginTag((Appendable)this.buffer, tagName);
        int argSize = 0;
        LinkedHashMap<String, DataEncoder.Snippet> deferredAttrs = new LinkedHashMap<String, DataEncoder.Snippet>();
        for (String attrName : element.getAttributeNames()) {
            CodeStatement writeStatement;
            DuelNode attrVal = element.getAttribute(attrName);
            if (attrVal == null) {
                this.formatter.writeAttribute((Appendable)this.buffer, attrName, null);
                continue;
            }
            if (element.isLinkAttribute(attrName)) {
                block30: {
                    this.formatter.writeOpenAttribute((Appendable)this.buffer, attrName);
                    this.flushBuffer();
                    if (attrVal instanceof LiteralNode) {
                        writeStatement = this.buildLinkIntercept(((LiteralNode)attrVal).getValue());
                    } else {
                        if (attrVal instanceof CodeBlockNode) {
                            try {
                                writeStatement = this.buildLinkIntercept((CodeBlockNode)attrVal);
                                break block30;
                            }
                            catch (Exception ex) {
                                deferredAttrs.put(attrName, DataEncoder.asSnippet((String)((CodeBlockNode)attrVal).getClientCode()));
                                argSize = Math.max(argSize, ((CodeBlockNode)attrVal).getArgSize());
                                continue;
                            }
                        }
                        throw new InvalidNodeException("Invalid attribute node type: " + attrVal.getClass(), attrVal);
                    }
                }
                this.scopeStack.peek().add(writeStatement);
                this.formatter.writeCloseAttribute((Appendable)this.buffer);
                continue;
            }
            if (attrVal instanceof LiteralNode) {
                this.formatter.writeAttribute((Appendable)this.buffer, attrName, ((LiteralNode)attrVal).getValue());
                continue;
            }
            if (attrVal instanceof CodeBlockNode) {
                try {
                    writeStatement = this.processCodeBlock((CodeBlockNode)attrVal);
                    if (writeStatement != null) {
                        this.formatter.writeOpenAttribute((Appendable)this.buffer, attrName);
                        this.flushBuffer();
                        this.scopeStack.peek().add(writeStatement);
                        this.formatter.writeCloseAttribute((Appendable)this.buffer);
                        continue;
                    }
                    this.formatter.writeAttribute((Appendable)this.buffer, attrName, null);
                }
                catch (Exception ex) {
                    deferredAttrs.put(attrName, DataEncoder.asSnippet((String)((CodeBlockNode)attrVal).getClientCode()));
                    argSize = Math.max(argSize, ((CodeBlockNode)attrVal).getArgSize());
                }
                continue;
            }
            throw new InvalidNodeException("Invalid attribute node type: " + attrVal.getClass(), attrVal);
        }
        CodeVariableDeclarationStatement idVar = null;
        String idValue = null;
        if (deferredAttrs.size() > 0) {
            DuelNode id = element.getAttribute("id");
            if (id == null) {
                this.formatter.writeOpenAttribute((Appendable)this.buffer, "id");
                idVar = this.emitClientID();
                this.formatter.writeCloseAttribute((Appendable)this.buffer);
            } else if (id instanceof LiteralNode) {
                idValue = ((LiteralNode)id).getValue();
            } else {
                throw new InvalidNodeException("Invalid ID attribute node type: " + id.getClass(), id);
            }
        }
        if (element.canHaveChildren()) {
            this.formatter.writeCloseElementBeginTag((Appendable)this.buffer);
            TagMode prevMode = this.tagMode;
            if ("script".equalsIgnoreCase(tagName) || "style".equalsIgnoreCase(tagName)) {
                this.tagMode = TagMode.SuspendMode;
            } else if ("pre".equalsIgnoreCase(tagName)) {
                this.tagMode = TagMode.PreMode;
            }
            try {
                for (DuelNode child : element.getChildren()) {
                    String lit;
                    if (!(!this.settings.getNormalizeWhitespace() || this.tagMode != TagMode.None || !(child instanceof LiteralNode) || child != element.getFirstChild() && child != element.getLastChild() || (lit = ((LiteralNode)child).getValue()) != null && !lit.matches("^[\\r\\n]*$"))) continue;
                    this.buildNode(child);
                }
            }
            finally {
                this.tagMode = prevMode;
            }
            if (this.hasScripts && "body".equalsIgnoreCase(tagName)) {
                this.ensureExtrasEmitted(true);
                this.buffer.append(this.settings.getNewline());
            }
            this.formatter.writeElementEndTag((Appendable)this.buffer, tagName);
        } else {
            this.formatter.writeCloseElementVoidTag((Appendable)this.buffer);
        }
        if (deferredAttrs.size() > 0) {
            this.buildDeferredAttributeExecution(deferredAttrs, idVar, idValue, argSize);
        }
    }

    private void buildDeferredAttributeExecution(Map<String, DataEncoder.Snippet> deferredAttrs, CodeVariableDeclarationStatement idVar, String idValue, int argSize) throws IOException {
        boolean prettyPrint = this.encoder.isPrettyPrint();
        CodeStatementCollection scope = this.scopeStack.peek();
        this.hasScripts = true;
        this.formatter.writeOpenElementBeginTag((Appendable)this.buffer, "script").writeAttribute((Appendable)this.buffer, "type", "text/javascript").writeCloseElementBeginTag((Appendable)this.buffer);
        this.ensureExtrasEmitted(false);
        this.buffer.append("duel(");
        this.encoder.write((Appendable)this.buffer, deferredAttrs, 1);
        this.buffer.append(")(");
        if (argSize > 0) {
            this.flushBuffer();
            scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Object.class, "data"), CodePrimitiveExpression.ONE));
            if (argSize > 1) {
                this.buffer.append(',');
                if (prettyPrint) {
                    this.buffer.append(' ');
                }
                this.flushBuffer();
                scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Integer.TYPE, "index"), CodePrimitiveExpression.ONE));
                if (argSize > 2) {
                    this.buffer.append(',');
                    if (prettyPrint) {
                        this.buffer.append(' ');
                    }
                    this.flushBuffer();
                    scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Integer.TYPE, "count"), CodePrimitiveExpression.ONE));
                    if (argSize > 3) {
                        this.buffer.append(',');
                        if (prettyPrint) {
                            this.buffer.append(' ');
                        }
                        this.flushBuffer();
                        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(String.class, "key"), CodePrimitiveExpression.ONE));
                    }
                }
            }
        }
        this.buffer.append(").toDOM(");
        if (idVar != null) {
            this.flushBuffer();
            scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(idVar), CodePrimitiveExpression.ONE));
        } else {
            this.encoder.write((Appendable)this.buffer, (Object)idValue, 1);
        }
        this.buffer.append(',');
        if (prettyPrint) {
            this.buffer.append(" true");
        } else {
            this.buffer.append('1');
        }
        this.buffer.append(");");
        this.formatter.writeElementEndTag((Appendable)this.buffer, "script");
    }

    private void buildCodeBlock(CodeBlockNode node) throws IOException {
        try {
            CodeStatement writeStatement = this.processCodeBlock(node);
            if (writeStatement == null) {
                return;
            }
            this.flushBuffer();
            this.scopeStack.peek().add(writeStatement);
            return;
        }
        catch (Exception ex) {
            this.buildDeferredCodeBlock(node.getClientCode(), node.getArgSize());
            return;
        }
    }

    private void buildDeferredCodeBlock(String clientCode, int argSize) throws IOException {
        boolean prettyPrint = this.encoder.isPrettyPrint();
        CodeStatementCollection scope = this.scopeStack.peek();
        this.hasScripts = true;
        this.formatter.writeOpenElementBeginTag((Appendable)this.buffer, "script").writeAttribute((Appendable)this.buffer, "type", "text/javascript").writeOpenAttribute((Appendable)this.buffer, "id");
        CodeVariableDeclarationStatement idVar = this.emitClientID();
        this.formatter.writeCloseAttribute((Appendable)this.buffer).writeCloseElementBeginTag((Appendable)this.buffer);
        this.ensureExtrasEmitted(false);
        this.buffer.append("duel(");
        this.buffer.append(clientCode);
        this.buffer.append(")(");
        if (argSize > 0) {
            this.flushBuffer();
            scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Object.class, "data"), CodePrimitiveExpression.ONE));
            if (argSize > 1) {
                this.buffer.append(',');
                if (prettyPrint) {
                    this.buffer.append(' ');
                }
                this.flushBuffer();
                scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Integer.TYPE, "index"), CodePrimitiveExpression.ONE));
                if (argSize > 2) {
                    this.buffer.append(',');
                    if (prettyPrint) {
                        this.buffer.append(' ');
                    }
                    this.flushBuffer();
                    scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Integer.TYPE, "count"), CodePrimitiveExpression.ONE));
                    if (argSize > 3) {
                        this.buffer.append(',');
                        if (prettyPrint) {
                            this.buffer.append(' ');
                        }
                        this.flushBuffer();
                        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(String.class, "key"), CodePrimitiveExpression.ONE));
                    }
                }
            }
        }
        this.buffer.append(").toDOM(");
        this.flushBuffer();
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(idVar), CodePrimitiveExpression.ONE));
        this.buffer.append(");");
        this.formatter.writeElementEndTag((Appendable)this.buffer, "script");
    }

    private CodeVariableDeclarationStatement emitClientID() {
        this.flushBuffer();
        CodeStatementCollection scope = this.scopeStack.peek();
        CodeVariableDeclarationStatement localVar = CodeDOMUtility.nextID(scope);
        scope.add(localVar);
        CodeStatement emitVar = CodeDOMUtility.emitVarValue(localVar);
        scope.add(emitVar);
        return localVar;
    }

    private CodeStatement buildLinkIntercept(Object literal) {
        CodeMethodInvokeExpression codeExpr = new CodeMethodInvokeExpression(String.class, new CodeThisReferenceExpression(), "transformURL", new CodeVariableReferenceExpression(DuelContext.class, "context"), CodeDOMUtility.ensureString(new CodePrimitiveExpression(literal)));
        return CodeDOMUtility.emitExpressionSafe(codeExpr);
    }

    private CodeStatement buildLinkIntercept(CodeBlockNode block) {
        CodeExpression codeExpr;
        boolean htmlEncode = true;
        if (block instanceof MarkupExpressionNode) {
            htmlEncode = false;
            block = new ExpressionNode(block.getValue(), block.getIndex(), block.getLine(), block.getColumn());
        }
        if ((codeExpr = this.translateExpression(block, true)) == null) {
            return null;
        }
        codeExpr = new CodeMethodInvokeExpression(String.class, new CodeThisReferenceExpression(), "transformURL", new CodeVariableReferenceExpression(DuelContext.class, "context"), CodeDOMUtility.ensureString(codeExpr));
        return htmlEncode ? CodeDOMUtility.emitExpressionSafe(codeExpr) : CodeDOMUtility.emitExpression(codeExpr);
    }

    private CodeStatement processCodeBlock(CodeBlockNode block) {
        CodeExpression codeExpr;
        boolean htmlEncode = true;
        if (block instanceof MarkupExpressionNode) {
            htmlEncode = false;
            block = new ExpressionNode(block.getValue(), block.getIndex(), block.getLine(), block.getColumn());
        }
        if ((codeExpr = this.translateExpression(block, true)) == null) {
            return null;
        }
        return htmlEncode ? CodeDOMUtility.emitExpressionSafe(codeExpr) : CodeDOMUtility.emitExpression(codeExpr);
    }

    private void ensureExtrasEmitted(boolean needsTags) {
        if (!this.needsExtrasEmitted) {
            return;
        }
        this.flushBuffer();
        this.scopeStack.peek().add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "writeExtras", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodePrimitiveExpression(needsTags)));
        for (CodeStatementCollection scope : this.scopeStack) {
            if (scope.getOwner() instanceof CodeMethod) continue;
            return;
        }
        this.needsExtrasEmitted = false;
    }

    private CodeMethod ensureInitMethod() {
        for (CodeMember member : this.viewType.getMembers()) {
            if (!(member instanceof CodeMethod) || !"init".equals(((CodeMethod)member).getName())) continue;
            return (CodeMethod)member;
        }
        CodeMethod initMethod = new CodeMethod(AccessModifierType.PROTECTED, Void.class, "init", null, new CodeStatement[0]).withOverride();
        this.viewType.add(initMethod);
        return initMethod;
    }

    private void buildComment(CodeCommentNode comment) {
        this.flushBuffer();
        CodeStatementCollection scope = this.scopeStack.peek();
        scope.add(new CodeCommentStatement(comment.getValue()));
    }

    private void flushBuffer() {
        if (this.buffer.length() < 1) {
            return;
        }
        CodeStatement emitLit = CodeDOMUtility.emitLiteralValue(this.buffer.toString());
        this.scopeStack.peek().add(emitLit);
        this.buffer.setLength(0);
    }

    private static enum TagMode {
        None,
        PreMode,
        SuspendMode;

    }
}

