/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.ast;

import org.duelengine.duel.ast.AttributePair;
import org.duelengine.duel.ast.CommandName;
import org.duelengine.duel.ast.DuelNode;
import org.duelengine.duel.ast.ElementNode;
import org.duelengine.duel.ast.ExpressionNode;
import org.duelengine.duel.ast.LiteralNode;

public abstract class CommandNode
extends ElementNode {
    private final boolean codeAttrs;
    private final CommandName command;

    protected CommandNode(CommandName cmd, String name, boolean codeAttrs, int index, int line, int column) {
        super(name, index, line, column);
        this.command = cmd;
        this.codeAttrs = codeAttrs;
    }

    protected CommandNode(CommandName cmd, String name, boolean codeAttrs, AttributePair[] attr, DuelNode ... children) {
        super(name, null, children);
        this.command = cmd;
        this.codeAttrs = codeAttrs;
        if (attr != null) {
            for (AttributePair a : attr) {
                this.setAttribute(a.getName(), a.getValue());
            }
        }
    }

    public CommandName getCommand() {
        return this.command;
    }

    @Override
    public void addAttribute(AttributePair attr) throws NullPointerException {
        if (attr == null) {
            throw new NullPointerException("attr");
        }
        this.setAttribute(attr.getName(), attr.getValue());
    }

    @Override
    public void setAttribute(String name, DuelNode value) {
        if (this.codeAttrs && value instanceof LiteralNode) {
            value = new ExpressionNode(((LiteralNode)value).getValue(), value.getIndex(), value.getLine(), value.getColumn());
        }
        super.setAttribute(name != null ? name.toLowerCase() : null, value);
    }
}

