/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import java.util.ArrayList;
import java.util.List;
import org.duelengine.duel.codedom.AccessModifierType;
import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeMethod;
import org.duelengine.duel.codedom.CodeParameterDeclarationExpression;
import org.duelengine.duel.codedom.CodeStatement;
import org.duelengine.duel.codedom.CodeVisitor;

public class CodeConstructor
extends CodeMethod {
    private final List<CodeExpression> baseCtorArgs = new ArrayList<CodeExpression>();
    private final List<CodeExpression> chainedCtorArgs = new ArrayList<CodeExpression>();

    public CodeConstructor() {
        this.setName(".ctor");
    }

    public CodeConstructor(AccessModifierType access, CodeParameterDeclarationExpression[] parameters, CodeExpression[] baseCtorArgs, CodeExpression[] chainedCtorArgs, CodeStatement[] statements) {
        super(access, Void.class, ".ctor", parameters, statements);
        if (baseCtorArgs != null) {
            for (CodeExpression arg : baseCtorArgs) {
                this.baseCtorArgs.add(arg);
            }
        }
        if (chainedCtorArgs != null) {
            for (CodeExpression arg : chainedCtorArgs) {
                this.chainedCtorArgs.add(arg);
            }
        }
    }

    public List<CodeExpression> getBaseCtorArgs() {
        return this.baseCtorArgs;
    }

    public List<CodeExpression> getChainedCtorArgs() {
        return this.chainedCtorArgs;
    }

    @Override
    public void visit(CodeVisitor visitor) {
        if (visitor.visit(this)) {
            for (CodeParameterDeclarationExpression parameter : this.getParameters()) {
                if (parameter == null) continue;
                parameter.visit(visitor);
            }
            for (CodeExpression arg : this.baseCtorArgs) {
                if (arg == null) continue;
                arg.visit(visitor);
            }
            for (CodeExpression arg : this.chainedCtorArgs) {
                if (arg == null) continue;
                arg.visit(visitor);
            }
            for (CodeStatement statement : this.getStatements()) {
                if (statement == null) continue;
                statement.visit(visitor);
            }
        }
    }

    @Override
    public boolean equals(Object arg) {
        CodeExpression thatArg;
        CodeExpression thisArg;
        int i;
        if (!(arg instanceof CodeConstructor)) {
            return false;
        }
        CodeConstructor that = (CodeConstructor)arg;
        int length = this.baseCtorArgs.size();
        if (length != that.baseCtorArgs.size()) {
            return false;
        }
        for (i = 0; i < length; ++i) {
            thisArg = this.baseCtorArgs.get(i);
            thatArg = that.baseCtorArgs.get(i);
            if (!(thisArg == null ? thatArg != null : !thisArg.equals(thatArg))) continue;
            return false;
        }
        length = this.chainedCtorArgs.size();
        if (length != that.chainedCtorArgs.size()) {
            return false;
        }
        for (i = 0; i < length; ++i) {
            thisArg = this.chainedCtorArgs.get(i);
            thatArg = that.chainedCtorArgs.get(i);
            if (!(thisArg == null ? thatArg != null : !thisArg.equals(thatArg))) continue;
            return false;
        }
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        int HASH_PRIME = 1000003;
        return (super.hashCode() * 1000003 + ((Object)this.baseCtorArgs).hashCode()) * 1000003 + ((Object)this.chainedCtorArgs).hashCode();
    }
}

