/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.compiler;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.duelengine.duel.ast.VIEWCommandNode;
import org.duelengine.duel.codegen.ClientCodeGen;
import org.duelengine.duel.codegen.CodeGenSettings;
import org.duelengine.duel.codegen.CodeGenerator;
import org.duelengine.duel.codegen.JavaCodeGen;
import org.duelengine.duel.parsing.DuelLexer;
import org.duelengine.duel.parsing.DuelParser;
import org.duelengine.duel.parsing.SyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuelCompiler {
    private final Logger log = LoggerFactory.getLogger(DuelCompiler.class);
    private boolean verbose;
    private File inputDir;
    private File outputClientDir;
    private File outputServerDir;
    private String clientPrefix;
    private String serverPrefix;

    public String getInputDir() {
        return this.inputDir.getAbsolutePath();
    }

    public void setInputDir(String value) {
        this.inputDir = value != null ? new File(value.replace('\\', '/')) : null;
    }

    public String getOutputClientDir() {
        return this.outputClientDir.getAbsolutePath();
    }

    public void setOutputClientDir(String value) {
        this.outputClientDir = value != null ? new File(value.replace('\\', '/')) : null;
    }

    public String getOutputServerDir() {
        return this.outputServerDir.getAbsolutePath();
    }

    public void setOutputServerDir(String value) {
        this.outputServerDir = value != null ? new File(value.replace('\\', '/')) : null;
    }

    public String getClientPrefix() {
        return this.clientPrefix;
    }

    public void setClientPrefix(String value) {
        this.clientPrefix = value;
    }

    public String getServerPrefix() {
        return this.serverPrefix;
    }

    public void setServerPrefix(String value) {
        this.serverPrefix = value;
    }

    private boolean ensureSettings() {
        if (this.inputDir == null || !this.inputDir.exists()) {
            throw new IllegalArgumentException("ERROR: input directory is empty: " + this.inputDir);
        }
        if (this.outputClientDir == null) {
            File file = this.outputClientDir = this.inputDir.isDirectory() ? this.inputDir : this.inputDir.getParentFile();
        }
        if (this.outputServerDir == null) {
            this.outputServerDir = this.inputDir.isDirectory() ? this.inputDir : this.inputDir.getParentFile();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        if (!this.ensureSettings()) {
            return;
        }
        List<File> inputFiles = DuelCompiler.findFiles(this.inputDir);
        if (inputFiles.size() < 1) {
            throw new IllegalArgumentException("ERROR: no input files found: " + this.inputDir);
        }
        for (File inputFile : inputFiles) {
            List<VIEWCommandNode> views;
            try {
                FileReader reader = new FileReader(inputFile);
                views = new DuelParser().parse(new DuelLexer(reader));
                if (views == null || views.size() < 1) {
                    throw new SyntaxException("Syntax error: no view found in " + inputFile, 0, 0, 0);
                }
            }
            catch (SyntaxException ex) {
                this.reportSyntaxError(inputFile, ex);
                continue;
            }
            CodeGenSettings settings = new CodeGenSettings();
            settings.setIndent("\t");
            settings.setNewline(System.getProperty("line.separator"));
            settings.setClientNamePrefix(this.clientPrefix);
            settings.setServerNamePrefix(this.serverPrefix);
            settings.setConvertLineEndings(false);
            settings.setNormalizeWhitespace(true);
            String outputName = inputFile.getName();
            for (VIEWCommandNode view : views) {
                if (view.isServerOnly()) continue;
                outputName = settings.getClientPath(view.getName());
                break;
            }
            CodeGenerator codegen = new ClientCodeGen(settings);
            try {
                File outputFile = new File(this.outputClientDir, outputName + codegen.getFileExtension());
                outputFile.getParentFile().mkdirs();
                FileWriter writer = new FileWriter(outputFile, false);
                try {
                    codegen.write((Appendable)writer, views);
                }
                finally {
                    writer.flush();
                    writer.close();
                }
            }
            catch (SyntaxException ex) {
                this.reportSyntaxError(inputFile, ex);
            }
            settings.setConvertLineEndings(true);
            settings.setNormalizeWhitespace(false);
            codegen = new JavaCodeGen(settings);
            for (VIEWCommandNode view : views) {
                if (view.isClientOnly()) continue;
                try {
                    File outputFile = new File(this.outputServerDir, settings.getServerPath(view.getName(), codegen));
                    outputFile.getParentFile().mkdirs();
                    FileWriter writer = new FileWriter(outputFile, false);
                    try {
                        codegen.write((Appendable)writer, view);
                    }
                    finally {
                        writer.flush();
                        writer.close();
                    }
                }
                catch (SyntaxException ex) {
                    this.reportSyntaxError(inputFile, ex);
                }
            }
        }
    }

    private void reportSyntaxError(File inputFile, SyntaxException ex) {
        block7: {
            try {
                String message = ex.getMessage();
                if (message == null) {
                    message = ex.getCause() != null ? ex.getCause().getMessage() : "Error";
                }
                this.log.error(String.format("%s:%d: %s", inputFile.getAbsolutePath(), ex.getLine(), message));
                int col = ex.getColumn();
                int line = ex.getLine();
                LineNumberReader reader = new LineNumberReader(new FileReader(inputFile));
                String text = "";
                for (int i = -1; i < line; ++i) {
                    text = reader.readLine();
                }
                this.log.error(text);
                if (col > 0) {
                    this.log.error(String.format("%" + col + "s", "^"));
                } else {
                    this.log.error("^");
                }
                if (this.verbose) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex2) {
                ex.printStackTrace();
                if (!this.verbose) break block7;
                ex2.printStackTrace();
            }
        }
    }

    private static List<File> findFiles(File inputDir) {
        ArrayList<File> files = new ArrayList<File>();
        LinkedList<File> dirs = new LinkedList<File>();
        dirs.add(inputDir);
        while (!dirs.isEmpty()) {
            File file = (File)dirs.poll();
            if (file.isDirectory()) {
                dirs.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            if (!file.getName().toLowerCase().endsWith(".duel")) continue;
            files.add(file);
        }
        return files;
    }
}

