/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeUnaryOperatorType;
import org.duelengine.duel.codedom.CodeVisitor;

public class CodeUnaryOperatorExpression
extends CodeExpression {
    private CodeUnaryOperatorType operator;
    private CodeExpression expression;

    public CodeUnaryOperatorExpression() {
    }

    public CodeUnaryOperatorExpression(CodeUnaryOperatorType op, CodeExpression expr) {
        this.operator = op;
        this.expression = expr;
    }

    public CodeUnaryOperatorType getOperator() {
        return this.operator;
    }

    public void setOperator(CodeUnaryOperatorType value) {
        this.operator = value;
    }

    public CodeExpression getExpression() {
        return this.expression;
    }

    public void setLeft(CodeExpression value) {
        this.expression = value;
    }

    @Override
    public Class<?> getResultType() {
        switch (this.operator) {
            case POSITIVE: 
            case NEGATION: 
            case PRE_INCREMENT: 
            case PRE_DECREMENT: 
            case POST_INCREMENT: 
            case POST_DECREMENT: 
            case BITWISE_NEGATION: {
                return Number.class;
            }
            case LOGICAL_NEGATION: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public void visit(CodeVisitor visitor) {
        if (visitor.visit(this) && this.expression != null) {
            this.expression.visit(visitor);
        }
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof CodeUnaryOperatorExpression)) {
            return false;
        }
        CodeUnaryOperatorExpression that = (CodeUnaryOperatorExpression)arg;
        if (this.operator != that.operator) {
            return false;
        }
        if (this.expression == null ? that.expression != null : !this.expression.equals(that.expression)) {
            return false;
        }
        return super.equals(arg);
    }

    @Override
    public int hashCode() {
        int HASH_PRIME = 1000003;
        int hash = super.hashCode() * 1000003 + this.operator.hashCode();
        if (this.expression != null) {
            hash = hash * 1000003 + this.expression.hashCode();
        }
        return hash;
    }
}

