/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeVisitor;

public class CodeCastExpression
extends CodeExpression {
    private Class<?> type = Object.class;
    private CodeExpression expression;

    public CodeCastExpression() {
        this.withParens();
    }

    public CodeCastExpression(Class<?> type, CodeExpression expression) {
        if (type != null) {
            this.type = type;
        }
        this.expression = expression;
        this.withParens();
    }

    public CodeExpression getExpression() {
        return this.expression;
    }

    public void setExpression(CodeExpression value) {
        this.expression = value;
    }

    @Override
    public Class<?> getResultType() {
        return this.type;
    }

    public void setResultType(Class<?> value) {
        this.type = value == null ? Object.class : value;
    }

    @Override
    public void visit(CodeVisitor visitor) {
        if (visitor.visit(this) && this.expression != null) {
            this.expression.visit(visitor);
        }
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof CodeCastExpression)) {
            return false;
        }
        CodeCastExpression that = (CodeCastExpression)arg;
        if (this.expression == null ? that.expression != null : !this.expression.equals(that.expression)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    @Override
    public int hashCode() {
        int HASH_PRIME = 1000003;
        int hash = this.type.hashCode();
        if (this.expression != null) {
            hash = hash * 1000003 + this.expression.hashCode();
        }
        return hash;
    }
}

