/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.duelengine.duel.codedom.AccessModifierType;
import org.duelengine.duel.codedom.CodeMember;
import org.duelengine.duel.codedom.CodeParameterDeclarationExpression;
import org.duelengine.duel.codedom.CodeStatement;
import org.duelengine.duel.codedom.CodeStatementCollection;
import org.duelengine.duel.codedom.CodeVisitor;

public class CodeMethod
extends CodeMember {
    private Class<?> returnType;
    private final List<CodeParameterDeclarationExpression> parameters = new ArrayList<CodeParameterDeclarationExpression>();
    private final CodeStatementCollection statements;
    private final List<Class<?>> exceptions = new ArrayList();
    private boolean override;

    public CodeMethod() {
        this(AccessModifierType.DEFAULT, null, null, null, new CodeStatement[0]);
    }

    public CodeMethod(AccessModifierType access, Class<?> returnType, String methodName, CodeParameterDeclarationExpression[] parameters, CodeStatement ... statements) {
        super(access, methodName);
        this.setReturnType(returnType);
        if (parameters != null) {
            this.parameters.addAll(Arrays.asList(parameters));
        }
        this.statements = new CodeStatementCollection(this);
        if (statements != null) {
            this.statements.addAll(statements);
        }
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class<?> value) {
        this.returnType = value != null ? value : Void.class;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean value) {
        this.override = value;
    }

    public CodeMethod withOverride() {
        this.override = true;
        return this;
    }

    public List<CodeParameterDeclarationExpression> getParameters() {
        return this.parameters;
    }

    public void addParameter(Class<?> type, String name) {
        this.addParameter(new CodeParameterDeclarationExpression(type, name));
    }

    public void addParameter(CodeParameterDeclarationExpression parameter) {
        this.parameters.add(parameter);
    }

    public List<Class<?>> getThrows() {
        return this.exceptions;
    }

    public void addThrows(Class<?> type) {
        this.exceptions.add(type);
    }

    public CodeMethod withThrows(Class<?> ... types) {
        if (types != null) {
            this.exceptions.addAll(Arrays.asList(types));
        }
        return this;
    }

    public CodeStatementCollection getStatements() {
        return this.statements;
    }

    @Override
    public void visit(CodeVisitor visitor) {
        if (visitor.visit(this)) {
            for (CodeParameterDeclarationExpression parameter : this.parameters) {
                if (parameter == null) continue;
                parameter.visit(visitor);
            }
            for (CodeStatement statement : this.statements) {
                if (statement == null) continue;
                statement.visit(visitor);
            }
        }
    }

    @Override
    public boolean equals(Object arg) {
        int i;
        if (!(arg instanceof CodeMethod)) {
            return false;
        }
        CodeMethod that = (CodeMethod)arg;
        if (this.override != that.override) {
            return false;
        }
        if (this.returnType == null ? that.returnType != null : !this.returnType.equals(that.returnType)) {
            return false;
        }
        if (!this.statements.equals(that.statements)) {
            return false;
        }
        int length = this.parameters.size();
        if (length != that.parameters.size()) {
            return false;
        }
        for (i = 0; i < length; ++i) {
            CodeParameterDeclarationExpression thisParam = this.parameters.get(i);
            CodeParameterDeclarationExpression thatParam = that.parameters.get(i);
            if (!(thisParam == null ? thatParam != null : !thisParam.equals(thatParam))) continue;
            return false;
        }
        length = this.exceptions.size();
        if (length != that.exceptions.size()) {
            return false;
        }
        for (i = 0; i < length; ++i) {
            Class<?> thisEx = this.exceptions.get(i);
            Class<?> thatEx = that.exceptions.get(i);
            if (!(thisEx == null ? thatEx != null : !thisEx.equals(thatEx))) continue;
            return false;
        }
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        int HASH_PRIME = 1000003;
        int hash = ((super.hashCode() * 1000003 + this.parameters.hashCode()) * 1000003 + this.exceptions.hashCode()) * 1000003 + this.statements.hashCode();
        if (this.returnType != null) {
            hash = hash * 1000003 + this.returnType.hashCode();
        }
        return hash;
    }
}

