/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import org.duelengine.duel.JSUtility;
import org.duelengine.duel.codedom.CodeExpression;

public class CodePrimitiveExpression
extends CodeExpression {
    public static final CodePrimitiveExpression NULL = new CodePrimitiveExpression(null);
    public static final CodePrimitiveExpression FALSE = new CodePrimitiveExpression(false);
    public static final CodePrimitiveExpression TRUE = new CodePrimitiveExpression(true);
    public static final CodePrimitiveExpression ZERO = new CodePrimitiveExpression(0);
    public static final CodePrimitiveExpression ONE = new CodePrimitiveExpression(1);
    private final Object value;

    public CodePrimitiveExpression(Object primative) {
        Class<?> type;
        Class<?> clazz = type = primative == null || primative == JSUtility.UNDEFINED ? null : primative.getClass();
        if (!(type == null || type.isPrimitive() || Boolean.class.equals(type) || String.class.equals(type) || Character.class.equals(type) || Number.class.isAssignableFrom(type))) {
            throw new IllegalArgumentException("Invalid primitive value: " + type.getName());
        }
        this.value = primative;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean hasParens() {
        return false;
    }

    @Override
    public void setParens(boolean value) {
    }

    @Override
    public CodeExpression withParens() {
        return this;
    }

    @Override
    public Class<?> getResultType() {
        return this.value == null ? Object.class : this.value.getClass();
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof CodePrimitiveExpression)) {
            return false;
        }
        CodePrimitiveExpression that = (CodePrimitiveExpression)arg;
        if (this.value == null ? that.value != null : !this.value.equals(that.value)) {
            return false;
        }
        return super.equals(arg);
    }

    @Override
    public int hashCode() {
        int HASH_PRIME = 1000003;
        int hash = super.hashCode();
        if (this.value != null) {
            hash = hash * 1000003 + this.value.hashCode();
        }
        return hash;
    }
}

