/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import java.util.HashMap;
import java.util.Map;
import org.duelengine.duel.DuelData;
import org.duelengine.duel.codedom.CodeVisitor;
import org.duelengine.duel.codegen.JavaCodeGen;

public abstract class CodeObject {
    private Map<String, Object> metaData;

    public boolean hasMetaData(String key) {
        return this.metaData != null && this.metaData.containsKey(key);
    }

    public Object getMetaData(String key) {
        if (this.metaData == null || !this.metaData.containsKey(key)) {
            return null;
        }
        return this.metaData.get(key);
    }

    public Object putMetaData(String key, Object value) {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, Object>(4, 1.0f);
        }
        return this.metaData.put(key, value);
    }

    public Object removeMetaData(String key) {
        if (this.metaData == null || !this.metaData.containsKey(key)) {
            return null;
        }
        return this.metaData.remove(key);
    }

    public CodeObject withMetaData(Object ... pairs) {
        if (pairs == null || pairs.length < 1) {
            return this;
        }
        int length = pairs.length / 2;
        if (this.metaData == null) {
            this.metaData = new HashMap<String, Object>(length, 1.0f);
        }
        for (int i = 0; i < length; ++i) {
            String key = DuelData.coerceString((Object)pairs[2 * i]);
            Object value = pairs[2 * i + 1];
            this.metaData.put(key, value);
        }
        return this;
    }

    public void visit(CodeVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object arg) {
        if (!(arg instanceof CodeObject)) {
            return false;
        }
        CodeObject that = (CodeObject)arg;
        if (this.metaData == null || this.metaData.isEmpty()) {
            return that.metaData == null || that.metaData.isEmpty();
        }
        for (String name : this.metaData.keySet()) {
            if (!that.metaData.containsKey(name)) {
                return false;
            }
            Object thisValue = this.metaData.get(name);
            Object thatValue = that.metaData.get(name);
            if (!(thisValue == null ? thatValue != null : !thisValue.equals(thatValue))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.metaData != null ? this.metaData.hashCode() : super.hashCode();
    }

    public String toString() {
        try {
            StringBuilder buffer = new StringBuilder();
            new JavaCodeGen().writeCode(buffer, this);
            return buffer.toString();
        }
        catch (Exception ex) {
            return super.toString() + '\n' + ex.getMessage();
        }
    }
}

