/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.duelengine.duel.DataEncoder;
import org.duelengine.duel.DuelContext;
import org.duelengine.duel.DuelView;
import org.duelengine.duel.HTMLFormatter;
import org.duelengine.duel.ast.CALLCommandNode;
import org.duelengine.duel.ast.CodeBlockNode;
import org.duelengine.duel.ast.CodeCommentNode;
import org.duelengine.duel.ast.CommandNode;
import org.duelengine.duel.ast.CommentNode;
import org.duelengine.duel.ast.DocTypeNode;
import org.duelengine.duel.ast.DuelNode;
import org.duelengine.duel.ast.ElementNode;
import org.duelengine.duel.ast.ExpressionNode;
import org.duelengine.duel.ast.FORCommandNode;
import org.duelengine.duel.ast.IFCommandNode;
import org.duelengine.duel.ast.LiteralNode;
import org.duelengine.duel.ast.MarkupExpressionNode;
import org.duelengine.duel.ast.PARTCommandNode;
import org.duelengine.duel.ast.UnknownNode;
import org.duelengine.duel.ast.VIEWCommandNode;
import org.duelengine.duel.ast.XORCommandNode;
import org.duelengine.duel.codedom.AccessModifierType;
import org.duelengine.duel.codedom.CodeBinaryOperatorExpression;
import org.duelengine.duel.codedom.CodeBinaryOperatorType;
import org.duelengine.duel.codedom.CodeCastExpression;
import org.duelengine.duel.codedom.CodeCommentStatement;
import org.duelengine.duel.codedom.CodeConditionStatement;
import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeExpressionStatement;
import org.duelengine.duel.codedom.CodeField;
import org.duelengine.duel.codedom.CodeFieldReferenceExpression;
import org.duelengine.duel.codedom.CodeIterationStatement;
import org.duelengine.duel.codedom.CodeMember;
import org.duelengine.duel.codedom.CodeMethod;
import org.duelengine.duel.codedom.CodeMethodInvokeExpression;
import org.duelengine.duel.codedom.CodeMethodReturnStatement;
import org.duelengine.duel.codedom.CodeObjectCreateExpression;
import org.duelengine.duel.codedom.CodeParameterDeclarationExpression;
import org.duelengine.duel.codedom.CodePrimitiveExpression;
import org.duelengine.duel.codedom.CodeStatement;
import org.duelengine.duel.codedom.CodeStatementCollection;
import org.duelengine.duel.codedom.CodeThisReferenceExpression;
import org.duelengine.duel.codedom.CodeTypeDeclaration;
import org.duelengine.duel.codedom.CodeUnaryOperatorExpression;
import org.duelengine.duel.codedom.CodeUnaryOperatorType;
import org.duelengine.duel.codedom.CodeVariableCompoundDeclarationStatement;
import org.duelengine.duel.codedom.CodeVariableDeclarationStatement;
import org.duelengine.duel.codedom.CodeVariableReferenceExpression;
import org.duelengine.duel.codedom.ScriptExpression;
import org.duelengine.duel.codegen.CodeDOMUtility;
import org.duelengine.duel.codegen.CodeGenSettings;
import org.duelengine.duel.codegen.HybridDeferredAttribute;
import org.duelengine.duel.codegen.ScriptTranslationException;
import org.duelengine.duel.codegen.ScriptTranslator;
import org.duelengine.duel.parsing.InvalidNodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeDOMBuilder {
    private final Logger log = LoggerFactory.getLogger(CodeDOMBuilder.class);
    private static final String AS_HYBRID = "CodeDOMBuilder.AS_HYBRID";
    private final CodeGenSettings settings;
    private final HTMLFormatter formatter;
    private final DataEncoder encoder;
    private final StringBuilder buffer;
    private final Stack<CodeStatementCollection> scopeStack = new Stack();
    private CodeTypeDeclaration viewType;
    private TagMode tagMode;
    private boolean needsExtrasEmitted;
    private boolean hasScripts;

    public CodeDOMBuilder() {
        this(null);
    }

    public CodeDOMBuilder(CodeGenSettings codeGenSettings) {
        this.settings = codeGenSettings != null ? codeGenSettings : new CodeGenSettings();
        this.buffer = new StringBuilder();
        this.formatter = new HTMLFormatter();
        this.encoder = new DataEncoder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeTypeDeclaration buildView(VIEWCommandNode viewNode) throws IOException {
        try {
            String fullName = this.settings.getServerName(viewNode.getName());
            int lastDot = fullName.lastIndexOf(46);
            String name = fullName.substring(lastDot + 1);
            String ns = lastDot > 0 ? fullName.substring(0, lastDot) : null;
            this.scopeStack.clear();
            this.tagMode = TagMode.NORMAL;
            this.hasScripts = false;
            this.needsExtrasEmitted = true;
            this.viewType = CodeDOMUtility.createViewType(ns, name, new CodeMember[0]);
            CodeMethod method = this.buildRenderMethod(viewNode.getChildren()).withOverride();
            method.setName("render");
            method.setAccess(AccessModifierType.PROTECTED);
            CodeTypeDeclaration codeTypeDeclaration = this.viewType;
            return codeTypeDeclaration;
        }
        finally {
            this.viewType = null;
        }
    }

    private CodeMethod buildRenderMethod(List<DuelNode> content) throws IOException {
        CodeMethod method = new CodeMethod(AccessModifierType.PRIVATE, Void.class, this.viewType.nextIdent("render_"), new CodeParameterDeclarationExpression[]{new CodeParameterDeclarationExpression(DuelContext.class, "context"), new CodeParameterDeclarationExpression(Object.class, "data"), new CodeParameterDeclarationExpression(Integer.TYPE, "index"), new CodeParameterDeclarationExpression(Integer.TYPE, "count"), new CodeParameterDeclarationExpression(String.class, "key")}, new CodeStatement[0]).withThrows(IOException.class);
        this.viewType.add(method);
        this.flushBuffer();
        this.scopeStack.push(method.getStatements());
        for (DuelNode node : content) {
            this.buildNode(node);
        }
        this.flushBuffer();
        this.scopeStack.pop();
        return method;
    }

    private void buildNode(DuelNode node) throws IOException {
        if (node instanceof LiteralNode) {
            if (node instanceof UnknownNode) {
                this.ensureExtrasEmitted(true);
            }
            String literal = ((LiteralNode)node).getValue();
            if (this.tagMode == TagMode.SUSPEND || node instanceof UnknownNode) {
                this.buffer.append(literal);
            } else {
                if (literal != null && literal.length() > 0 && this.tagMode != TagMode.PRE && this.settings.getNormalizeWhitespace() && (literal = literal.replaceAll("^[\\r\\n]+", "").replaceAll("[\\r\\n]+$", "").replaceAll("\\s+", " ")).isEmpty()) {
                    literal = " ";
                }
                this.formatter.writeLiteral((Appendable)this.buffer, literal, this.settings.getEncodeNonASCII());
            }
        } else if (node instanceof CommandNode) {
            CommandNode command = (CommandNode)node;
            switch (command.getCommand()) {
                case XOR: {
                    this.buildConditional((XORCommandNode)node);
                    break;
                }
                case IF: {
                    this.buildConditional((IFCommandNode)node, this.scopeStack.peek());
                    break;
                }
                case FOR: {
                    this.buildIteration((FORCommandNode)node);
                    break;
                }
                case CALL: {
                    this.buildCall((CALLCommandNode)node);
                    break;
                }
                case PART: {
                    this.buildPartPlaceholder((PARTCommandNode)node);
                    break;
                }
                default: {
                    InvalidNodeException ex = new InvalidNodeException("Invalid command node type: " + (Object)((Object)command.getCommand()), command);
                    this.log.error(ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        } else if (node instanceof ElementNode) {
            ElementNode element = (ElementNode)node;
            this.buildElement(element);
        } else if (node instanceof CodeBlockNode) {
            this.buildCodeBlock((CodeBlockNode)node);
        } else if (node instanceof CommentNode) {
            CommentNode comment = (CommentNode)node;
            this.formatter.writeComment((Appendable)this.buffer, comment.getValue());
        } else if (node instanceof DocTypeNode) {
            DocTypeNode doctype = (DocTypeNode)node;
            this.formatter.writeDocType((Appendable)this.buffer, doctype.getValue());
        } else if (node instanceof CodeCommentNode) {
            this.buildComment((CodeCommentNode)node);
        }
    }

    private void buildCall(CALLCommandNode node) throws IOException {
        CodeExpression keyExpr;
        CodeExpression countExpr;
        CodeExpression indexExpr;
        CodeExpression dataExpr;
        if (node.isDefer()) {
            this.buildDeferredCall(node);
            return;
        }
        CodeField field = new CodeField(AccessModifierType.PRIVATE, DuelView.class, this.viewType.nextIdent("view_"));
        this.viewType.add(field);
        String viewName = null;
        DuelNode attr = node.getAttribute("view");
        if (attr instanceof LiteralNode) {
            viewName = ((LiteralNode)attr).getValue();
        } else if (attr instanceof ExpressionNode) {
            viewName = ((ExpressionNode)attr).getValue();
        }
        if (viewName == null) {
            InvalidNodeException ex = new InvalidNodeException("Unexpected Call command view attribute: " + attr, attr);
            this.log.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        viewName = this.settings.getServerName(viewName);
        CodeExpression[] ctorArgs = new CodeExpression[node.getChildren().size()];
        int i = 0;
        for (DuelNode child : node.getChildren()) {
            ctorArgs[i++] = this.buildPart((PARTCommandNode)child);
        }
        CodeMethod initMethod = this.ensureInitMethod();
        initMethod.getStatements().add(new CodeExpressionStatement(new CodeBinaryOperatorExpression(CodeBinaryOperatorType.ASSIGN, new CodeFieldReferenceExpression(new CodeThisReferenceExpression(), field), new CodeObjectCreateExpression(viewName.trim(), ctorArgs))));
        try {
            DuelNode callData = node.getAttribute("data");
            dataExpr = callData instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callData, false) : new CodeVariableReferenceExpression(Object.class, "data");
            DuelNode callIndex = node.getAttribute("index");
            indexExpr = callIndex instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callIndex, false) : new CodeVariableReferenceExpression(Integer.TYPE, "index");
            DuelNode callCount = node.getAttribute("count");
            countExpr = callCount instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callCount, false) : new CodeVariableReferenceExpression(Integer.TYPE, "count");
            DuelNode callKey = node.getAttribute("key");
            keyExpr = callKey instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callKey, false) : new CodeVariableReferenceExpression(String.class, "key");
        }
        catch (Exception ex) {
            this.buildDeferredCall(node);
            return;
        }
        this.flushBuffer();
        CodeStatementCollection scope = this.scopeStack.peek();
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "renderView", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeFieldReferenceExpression(new CodeThisReferenceExpression(), field), dataExpr, indexExpr, countExpr, keyExpr));
    }

    private void buildDeferredCall(CALLCommandNode node) throws IOException {
        boolean prettyPrint = this.encoder.isPrettyPrint();
        CodeStatementCollection scope = this.scopeStack.peek();
        this.hasScripts = true;
        this.formatter.writeOpenElementBeginTag((Appendable)this.buffer, "script");
        if (this.settings.getScriptTypeAttr()) {
            this.formatter.writeAttribute((Appendable)this.buffer, "type", "text/javascript");
        }
        this.formatter.writeOpenAttribute((Appendable)this.buffer, "id");
        CodeVariableDeclarationStatement idVar = this.emitClientID();
        this.formatter.writeCloseAttribute((Appendable)this.buffer).writeCloseElementBeginTag((Appendable)this.buffer);
        this.ensureExtrasEmitted(false);
        String viewName = null;
        DuelNode callView = node.getAttribute("view");
        if (callView instanceof LiteralNode) {
            viewName = ((LiteralNode)callView).getValue();
        } else if (callView instanceof ExpressionNode) {
            viewName = ((ExpressionNode)callView).getValue();
        }
        if (viewName != null) {
            viewName = this.settings.getClientName(viewName);
            this.buffer.append(viewName);
        } else {
            this.buffer.append("duel(");
            if (!(callView instanceof CodeBlockNode)) {
                InvalidNodeException ex = new InvalidNodeException("Unexpected Call command view attribute: " + callView, callView);
                this.log.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            CodeExpression viewExpr = this.translateExpression((CodeBlockNode)callView, false);
            this.flushBuffer();
            scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), viewExpr, CodePrimitiveExpression.ONE));
            this.buffer.append(")");
        }
        this.buffer.append("(");
        this.flushBuffer();
        DuelNode callData = node.getAttribute("data");
        CodeExpression dataExpr = callData instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callData, false) : new CodeVariableReferenceExpression(Object.class, "data");
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), dataExpr, CodePrimitiveExpression.ONE));
        this.buffer.append(',');
        if (prettyPrint) {
            this.buffer.append(' ');
        }
        this.flushBuffer();
        DuelNode callIndex = node.getAttribute("index");
        CodeExpression indexExpr = callIndex instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callIndex, false) : new CodeVariableReferenceExpression(Integer.TYPE, "index");
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), indexExpr, CodePrimitiveExpression.ONE));
        this.buffer.append(',');
        if (prettyPrint) {
            this.buffer.append(' ');
        }
        this.flushBuffer();
        DuelNode callCount = node.getAttribute("count");
        CodeExpression countExpr = callCount instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callCount, false) : new CodeVariableReferenceExpression(Integer.TYPE, "count");
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), countExpr, CodePrimitiveExpression.ONE));
        this.buffer.append(',');
        if (prettyPrint) {
            this.buffer.append(' ');
        }
        this.flushBuffer();
        DuelNode callKey = node.getAttribute("key");
        CodeExpression keyExpr = callKey instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)callKey, false) : new CodeVariableReferenceExpression(String.class, "key");
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), keyExpr, CodePrimitiveExpression.ONE));
        this.buffer.append(").toDOM(");
        this.flushBuffer();
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(idVar), CodePrimitiveExpression.ONE));
        this.buffer.append(");");
        this.formatter.writeElementEndTag((Appendable)this.buffer, "script");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodeObjectCreateExpression buildPart(PARTCommandNode node) throws IOException {
        CodeTypeDeclaration part = CodeDOMUtility.createPartType(this.viewType.nextIdent("part_"), new CodeMember[0]);
        this.viewType.add(part);
        String partName = node.getName();
        if (partName == null) {
            InvalidNodeException ex = new InvalidNodeException("PART command is missing name", node);
            this.log.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        CodeMethod getNameMethod = new CodeMethod(AccessModifierType.PUBLIC, String.class, "getPartName", null, new CodeMethodReturnStatement(new CodePrimitiveExpression(partName))).withOverride();
        part.add(getNameMethod);
        CodeTypeDeclaration parentView = this.viewType;
        try {
            this.viewType = part;
            CodeMethod renderMethod = this.buildRenderMethod(node.getChildren()).withOverride();
            renderMethod.setName("render");
            renderMethod.setAccess(AccessModifierType.PROTECTED);
        }
        finally {
            this.viewType = parentView;
        }
        return new CodeObjectCreateExpression(part.getTypeName(), new CodeExpression[0]);
    }

    private void buildPartPlaceholder(PARTCommandNode part) throws IOException {
        CodeObjectCreateExpression createPart = this.buildPart(part);
        CodeMethod initMethod = this.ensureInitMethod();
        initMethod.getStatements().add(new CodeExpressionStatement(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "addPart", createPart)));
        CodeStatementCollection scope = this.scopeStack.peek();
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "renderPart", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodePrimitiveExpression(part.getName()), new CodeVariableReferenceExpression(Object.class, "data"), new CodeVariableReferenceExpression(Integer.TYPE, "index"), new CodeVariableReferenceExpression(Integer.TYPE, "count"), new CodeVariableReferenceExpression(String.class, "key")));
    }

    private void buildIteration(FORCommandNode node) throws IOException {
        if (!node.hasChildren()) {
            return;
        }
        CodeStatementCollection scope = this.scopeStack.peek();
        CodeMethod innerBind = this.buildRenderMethod(node.getChildren());
        DuelNode loopCount = node.getAttribute("count");
        if (loopCount instanceof CodeBlockNode) {
            CodeExpression countExpr = this.translateExpression((CodeBlockNode)loopCount, false);
            DuelNode loopData = node.getAttribute("data");
            CodeExpression dataExpr = loopData instanceof CodeBlockNode ? this.translateExpression((CodeBlockNode)loopData, false) : new CodeVariableReferenceExpression(Object.class, "data");
            this.buildIterationCount(scope, countExpr, dataExpr, innerBind);
        } else {
            DuelNode loopObj = node.getAttribute("in");
            if (loopObj instanceof CodeBlockNode) {
                CodeExpression objExpr = this.translateExpression((CodeBlockNode)loopObj, false);
                this.buildIterationObject(scope, objExpr, innerBind);
            } else {
                DuelNode loopArray = node.getAttribute("each");
                if (!(loopArray instanceof CodeBlockNode)) {
                    InvalidNodeException ex = new InvalidNodeException("FOR loop missing arguments", loopArray);
                    this.log.error(ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
                CodeExpression arrayExpr = this.translateExpression((CodeBlockNode)loopArray, false);
                this.buildIterationArray(scope, arrayExpr, innerBind);
            }
        }
    }

    private void buildIterationCount(CodeStatementCollection scope, CodeExpression count, CodeExpression data, CodeMethod innerBind) {
        CodeVariableDeclarationStatement dataDecl = new CodeVariableDeclarationStatement(Object.class, scope.nextIdent("data_"), data);
        scope.add(dataDecl);
        CodeVariableDeclarationStatement indexDecl = new CodeVariableDeclarationStatement(Integer.TYPE, scope.nextIdent("index_"), CodePrimitiveExpression.ZERO);
        CodeVariableDeclarationStatement countDecl = new CodeVariableDeclarationStatement(Integer.TYPE, scope.nextIdent("count_"), count);
        CodeVariableCompoundDeclarationStatement initStatement = new CodeVariableCompoundDeclarationStatement(indexDecl, countDecl);
        scope.add(new CodeIterationStatement(initStatement, new CodeBinaryOperatorExpression(CodeBinaryOperatorType.LESS_THAN, new CodeVariableReferenceExpression(indexDecl), new CodeVariableReferenceExpression(countDecl)), new CodeExpressionStatement(new CodeUnaryOperatorExpression(CodeUnaryOperatorType.POST_INCREMENT, new CodeVariableReferenceExpression(indexDecl))), new CodeExpressionStatement(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), innerBind.getName(), new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(dataDecl), new CodeVariableReferenceExpression(indexDecl), new CodeVariableReferenceExpression(countDecl), CodePrimitiveExpression.NULL))));
    }

    private void buildIterationObject(CodeStatementCollection scope, CodeExpression objExpr, CodeMethod innerBind) {
        CodeMethodInvokeExpression data = new CodeMethodInvokeExpression(Set.class, CodeDOMUtility.ensureMap(objExpr), "entrySet", new CodeExpression[0]);
        CodeVariableDeclarationStatement collectionDecl = new CodeVariableDeclarationStatement(Collection.class, scope.nextIdent("items_"), data);
        scope.add(collectionDecl);
        CodeVariableDeclarationStatement indexDecl = new CodeVariableDeclarationStatement(Integer.TYPE, scope.nextIdent("index_"), CodePrimitiveExpression.ZERO);
        CodeVariableDeclarationStatement countDecl = new CodeVariableDeclarationStatement(Integer.TYPE, scope.nextIdent("count_"), new CodeMethodInvokeExpression(Integer.TYPE, new CodeVariableReferenceExpression(collectionDecl), "size", new CodeExpression[0]));
        scope.add(new CodeVariableCompoundDeclarationStatement(indexDecl, countDecl));
        CodeVariableDeclarationStatement iteratorDecl = new CodeVariableDeclarationStatement(Iterator.class, scope.nextIdent("iterator_"), new CodeMethodInvokeExpression(Iterator.class, new CodeVariableReferenceExpression(collectionDecl), "iterator", new CodeExpression[0]));
        CodeVariableDeclarationStatement entryDecl = new CodeVariableDeclarationStatement(Map.Entry.class, scope.nextIdent("entry_"), new CodeCastExpression(Map.Entry.class, new CodeMethodInvokeExpression(Object.class, new CodeVariableReferenceExpression(iteratorDecl), "next", new CodeExpression[0])));
        scope.add(new CodeIterationStatement(iteratorDecl, new CodeMethodInvokeExpression(Boolean.TYPE, new CodeVariableReferenceExpression(iteratorDecl), "hasNext", new CodeExpression[0]), new CodeExpressionStatement(new CodeUnaryOperatorExpression(CodeUnaryOperatorType.POST_INCREMENT, new CodeVariableReferenceExpression(indexDecl))), entryDecl, new CodeExpressionStatement(new CodeMethodInvokeExpression(innerBind.getReturnType(), new CodeThisReferenceExpression(), innerBind.getName(), new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeMethodInvokeExpression(Object.class, new CodeVariableReferenceExpression(entryDecl), "getValue", new CodeExpression[0]), new CodeVariableReferenceExpression(indexDecl), new CodeVariableReferenceExpression(countDecl), CodeDOMUtility.ensureString(new CodeMethodInvokeExpression(Object.class, new CodeVariableReferenceExpression(entryDecl), "getKey", new CodeExpression[0]))))));
    }

    private void buildIterationArray(CodeStatementCollection scope, CodeExpression arrayExpr, CodeMethod innerBind) {
        CodeExpression items = CodeDOMUtility.ensureCollection(arrayExpr);
        CodeVariableDeclarationStatement collectionDecl = new CodeVariableDeclarationStatement(Collection.class, scope.nextIdent("items_"), items);
        scope.add(collectionDecl);
        CodeVariableDeclarationStatement indexDecl = new CodeVariableDeclarationStatement(Integer.TYPE, scope.nextIdent("index_"), CodePrimitiveExpression.ZERO);
        CodeVariableDeclarationStatement countDecl = new CodeVariableDeclarationStatement(Integer.TYPE, scope.nextIdent("count_"), new CodeMethodInvokeExpression(Integer.TYPE, new CodeVariableReferenceExpression(collectionDecl), "size", new CodeExpression[0]));
        scope.add(new CodeVariableCompoundDeclarationStatement(indexDecl, countDecl));
        CodeVariableDeclarationStatement iteratorDecl = new CodeVariableDeclarationStatement(Iterator.class, scope.nextIdent("iterator_"), new CodeMethodInvokeExpression(Iterator.class, new CodeVariableReferenceExpression(collectionDecl), "iterator", new CodeExpression[0]));
        scope.add(new CodeIterationStatement(iteratorDecl, new CodeMethodInvokeExpression(Boolean.TYPE, new CodeVariableReferenceExpression(iteratorDecl), "hasNext", new CodeExpression[0]), new CodeExpressionStatement(new CodeUnaryOperatorExpression(CodeUnaryOperatorType.POST_INCREMENT, new CodeVariableReferenceExpression(indexDecl))), new CodeExpressionStatement(new CodeMethodInvokeExpression(innerBind.getReturnType(), new CodeThisReferenceExpression(), innerBind.getName(), new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeMethodInvokeExpression(Map.Entry.class, new CodeVariableReferenceExpression(iteratorDecl), "next", new CodeExpression[0]), new CodeVariableReferenceExpression(indexDecl), new CodeVariableReferenceExpression(countDecl), CodePrimitiveExpression.NULL))));
    }

    private void buildConditional(XORCommandNode node) throws IOException {
        CodeStatementCollection scope = this.scopeStack.peek();
        for (DuelNode conditional : node.getChildren()) {
            if (!(conditional instanceof IFCommandNode)) continue;
            scope = this.buildConditional((IFCommandNode)conditional, scope);
        }
    }

    private CodeStatementCollection buildConditional(IFCommandNode node, CodeStatementCollection scope) throws IOException {
        this.flushBuffer();
        CodeBlockNode testNode = node.getTest();
        if (testNode == null) {
            if (node.hasChildren()) {
                this.scopeStack.push(scope);
                for (DuelNode child : node.getChildren()) {
                    this.buildNode(child);
                }
                this.flushBuffer();
                this.scopeStack.pop();
            }
            return scope;
        }
        CodeConditionStatement condition = new CodeConditionStatement();
        scope.add(condition);
        condition.setCondition(this.translateExpression(testNode, false));
        if (node.hasChildren()) {
            this.scopeStack.push(condition.getTrueStatements());
            for (DuelNode child : node.getChildren()) {
                this.buildNode(child);
            }
            this.flushBuffer();
            this.scopeStack.pop();
        }
        return condition.getFalseStatements();
    }

    private CodeExpression translateExpression(CodeBlockNode node, boolean canDefer) {
        try {
            boolean firstIsMethod;
            ScriptTranslator translator = new ScriptTranslator(this.viewType);
            List<CodeMember> members = translator.translate(node.getClientCode(this.encoder.isPrettyPrint()));
            boolean bl = firstIsMethod = members.size() > 0 && members.get(0) instanceof CodeMethod;
            if (!firstIsMethod) {
                InvalidNodeException ex = new InvalidNodeException("Node should start with method", node);
                this.log.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            CodeMethod method = (CodeMethod)members.get(0);
            CodeExpression expression = CodeDOMUtility.inlineMethod(method);
            if (expression != null) {
                int length = members.size();
                for (int i = 1; i < length; ++i) {
                    this.viewType.add(members.get(i));
                }
            } else {
                this.viewType.addAll(members);
                expression = new CodeMethodInvokeExpression(method.getReturnType(), new CodeThisReferenceExpression(), method.getName(), new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Object.class, "data"), new CodeVariableReferenceExpression(Integer.TYPE, "index"), new CodeVariableReferenceExpression(Integer.TYPE, "count"), new CodeVariableReferenceExpression(String.class, "key"));
            }
            if (translator.hasExtraAssign() || !translator.getExtraRefs().isEmpty()) {
                if (canDefer) {
                    this.needsExtrasEmitted = true;
                    expression.withMetaData(AS_HYBRID, true);
                } else if (!translator.getExtraRefs().isEmpty()) {
                    String viewName = this.viewType.getTypeName();
                    if (viewName == null || viewName.isEmpty()) {
                        viewName = this.viewType.getName();
                    } else if (this.viewType.getNamespace() != null && !this.viewType.getNamespace().isEmpty()) {
                        viewName = this.viewType.getNamespace() + '.' + viewName;
                    }
                    if (viewName == null || viewName.isEmpty()) {
                        viewName = "view";
                    }
                    this.log.info("Cannot defer block. Ensure extras are passed to " + viewName + ": " + node.toString());
                }
            }
            return expression;
        }
        catch (ScriptTranslationException ex) {
            throw ex.adjustErrorStatistics(node, this.encoder.isPrettyPrint());
        }
        catch (InvalidNodeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            if (message == null) {
                message = ex.toString();
            }
            InvalidNodeException ex2 = new InvalidNodeException(message, node, ex);
            this.log.error(ex.getMessage(), (Throwable)ex2);
            throw ex2;
        }
    }

    private void buildDeferredWrite(String clientCode, int argSize) throws IOException {
        boolean prettyPrint = this.encoder.isPrettyPrint();
        CodeStatementCollection scope = this.scopeStack.peek();
        this.hasScripts = true;
        this.formatter.writeOpenElementBeginTag((Appendable)this.buffer, "script");
        if (this.settings.getScriptTypeAttr()) {
            this.formatter.writeAttribute((Appendable)this.buffer, "type", "text/javascript");
        }
        this.formatter.writeCloseElementBeginTag((Appendable)this.buffer);
        this.ensureExtrasEmitted(false);
        this.buffer.append("duel(");
        this.buffer.append(clientCode);
        this.buffer.append(")(");
        if (argSize > 0) {
            this.flushBuffer();
            scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Object.class, "data"), CodePrimitiveExpression.ONE));
            if (argSize > 1) {
                this.buffer.append(',');
                if (prettyPrint) {
                    this.buffer.append(' ');
                }
                this.flushBuffer();
                scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Integer.TYPE, "index"), CodePrimitiveExpression.ONE));
                if (argSize > 2) {
                    this.buffer.append(',');
                    if (prettyPrint) {
                        this.buffer.append(' ');
                    }
                    this.flushBuffer();
                    scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Integer.TYPE, "count"), CodePrimitiveExpression.ONE));
                    if (argSize > 3) {
                        this.buffer.append(',');
                        if (prettyPrint) {
                            this.buffer.append(' ');
                        }
                        this.flushBuffer();
                        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(String.class, "key"), CodePrimitiveExpression.ONE));
                    }
                }
            }
        }
        this.buffer.append(").write();");
        this.formatter.writeElementEndTag((Appendable)this.buffer, "script");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildElement(ElementNode element) throws IOException {
        InvalidNodeException ex;
        String tagName = element.getTagName();
        if ("script".equalsIgnoreCase(tagName)) {
            this.hasScripts = true;
            this.ensureExtrasEmitted(true);
        }
        this.formatter.writeOpenElementBeginTag((Appendable)this.buffer, tagName);
        int argSize = 0;
        LinkedHashMap<String, DataEncoder.Snippet> deferredAttrs = new LinkedHashMap<String, DataEncoder.Snippet>();
        ArrayList<HybridDeferredAttribute> hybridAttrs = new ArrayList<HybridDeferredAttribute>();
        for (String attrName : element.getAttributeNames()) {
            DuelNode attrVal = element.getAttribute(attrName);
            if (attrVal == null) {
                this.formatter.writeAttribute((Appendable)this.buffer, attrName, null);
                continue;
            }
            if (element.isBoolAttribute(attrName)) {
                if (attrVal instanceof CodeBlockNode) {
                    CodeExpression attrExpr;
                    try {
                        attrExpr = this.translateExpression((CodeBlockNode)attrVal, false);
                    }
                    catch (Exception ex2) {
                        deferredAttrs.put(attrName, DataEncoder.asSnippet((String)((CodeBlockNode)attrVal).getClientCode(this.encoder.isPrettyPrint())));
                        argSize = Math.max(argSize, ((CodeBlockNode)attrVal).getArgSize());
                        continue;
                    }
                    boolean isHybrid = attrExpr.hasMetaData(AS_HYBRID);
                    attrExpr.removeMetaData(AS_HYBRID);
                    if (!isHybrid) {
                        this.flushBuffer();
                        CodeConditionStatement condition = new CodeConditionStatement();
                        this.scopeStack.peek().add(condition);
                        condition.setCondition(attrExpr);
                        this.scopeStack.push(condition.getTrueStatements());
                        this.formatter.writeAttribute((Appendable)this.buffer, attrName, attrName);
                        this.flushBuffer();
                        this.scopeStack.pop();
                        continue;
                    }
                    deferredAttrs.put(attrName, DataEncoder.asSnippet((String)((CodeBlockNode)attrVal).getClientCode(this.encoder.isPrettyPrint())));
                    argSize = Math.max(argSize, ((CodeBlockNode)attrVal).getArgSize());
                    continue;
                }
                this.formatter.writeAttribute((Appendable)this.buffer, attrName, this.settings.getXHTMLStyle() ? attrName : null);
                continue;
            }
            if (element.isLinkAttribute(attrName)) {
                CodeStatement writeStatement;
                block43: {
                    if (attrVal instanceof LiteralNode) {
                        writeStatement = this.buildLinkIntercept(((LiteralNode)attrVal).getValue());
                    } else {
                        if (attrVal instanceof CodeBlockNode) {
                            try {
                                writeStatement = this.buildLinkIntercept((CodeBlockNode)attrVal);
                                break block43;
                            }
                            catch (Exception ex3) {
                                deferredAttrs.put(attrName, DataEncoder.asSnippet((String)((CodeBlockNode)attrVal).getClientCode(this.encoder.isPrettyPrint())));
                                argSize = Math.max(argSize, ((CodeBlockNode)attrVal).getArgSize());
                                continue;
                            }
                        }
                        InvalidNodeException ex4 = new InvalidNodeException("Invalid attribute node type: " + attrVal.getClass(), attrVal);
                        this.log.error(ex4.getMessage(), (Throwable)ex4);
                        throw ex4;
                    }
                }
                this.formatter.writeOpenAttribute((Appendable)this.buffer, attrName);
                this.flushBuffer();
                this.scopeStack.peek().add(writeStatement);
                this.formatter.writeCloseAttribute((Appendable)this.buffer);
                continue;
            }
            if (attrVal instanceof LiteralNode) {
                this.formatter.writeAttribute((Appendable)this.buffer, attrName, ((LiteralNode)attrVal).getValue());
                continue;
            }
            if (attrVal instanceof CodeBlockNode) {
                CodeExpression attrExpr;
                CodeBlockNode block = (CodeBlockNode)attrVal;
                boolean htmlEncode = true;
                if (block instanceof MarkupExpressionNode) {
                    htmlEncode = false;
                    block = new ExpressionNode(block.getValue(), block.getIndex(), block.getLine(), block.getColumn());
                }
                try {
                    attrExpr = this.translateExpression(block, true);
                }
                catch (Exception ex5) {
                    deferredAttrs.put(attrName, DataEncoder.asSnippet((String)block.getClientCode(this.encoder.isPrettyPrint())));
                    argSize = Math.max(argSize, block.getArgSize());
                    continue;
                }
                if (attrExpr == null) {
                    this.formatter.writeAttribute((Appendable)this.buffer, attrName, null);
                    continue;
                }
                boolean isHybrid = attrExpr.hasMetaData(AS_HYBRID);
                attrExpr.removeMetaData(AS_HYBRID);
                if (!isHybrid) {
                    CodeStatement writeStatement = htmlEncode ? CodeDOMUtility.emitExpressionSafe(attrExpr, this.formatter, this.settings) : CodeDOMUtility.emitExpression(attrExpr);
                    this.formatter.writeOpenAttribute((Appendable)this.buffer, attrName);
                    this.flushBuffer();
                    this.scopeStack.peek().add(writeStatement);
                    this.formatter.writeCloseAttribute((Appendable)this.buffer);
                    continue;
                }
                CodeVariableDeclarationStatement valDecl = new CodeVariableDeclarationStatement(Object.class, this.scopeStack.peek().nextIdent("val_"), attrExpr);
                this.flushBuffer();
                this.scopeStack.peek().add(valDecl);
                CodeVariableReferenceExpression valRef = new CodeVariableReferenceExpression(valDecl);
                hybridAttrs.add(new HybridDeferredAttribute().setValueRef(valRef).setAttrName(attrName).setClientCode(block.getClientCode(this.encoder.isPrettyPrint())).setArgSize(block.getArgSize()));
                CodeConditionStatement hybridTest = new CodeConditionStatement((CodeExpression)new CodeBinaryOperatorExpression(CodeBinaryOperatorType.IDENTITY_INEQUALITY, valRef, ScriptExpression.UNDEFINED), new CodeStatement[0]);
                this.scopeStack.peek().add(hybridTest);
                this.scopeStack.push(hybridTest.getTrueStatements());
                this.formatter.writeOpenAttribute((Appendable)this.buffer, attrName);
                this.flushBuffer();
                this.scopeStack.peek().add(htmlEncode ? CodeDOMUtility.emitExpressionSafe(valRef, this.formatter, this.settings) : CodeDOMUtility.emitExpression(valRef));
                this.formatter.writeCloseAttribute((Appendable)this.buffer);
                this.flushBuffer();
                this.scopeStack.pop();
                continue;
            }
            ex = new InvalidNodeException("Invalid attribute node type: " + attrVal.getClass(), attrVal);
            this.log.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        CodeVariableDeclarationStatement idVar = null;
        String idValue = null;
        if (deferredAttrs.size() > 0 || hybridAttrs.size() > 0) {
            DuelNode id = element.getAttribute("id");
            if (id == null) {
                boolean testIfIdNeeded = deferredAttrs.isEmpty() && hybridAttrs.size() > 0;
                idVar = CodeDOMUtility.nextID(this.scopeStack.peek());
                this.scopeStack.peek().add(idVar);
                if (testIfIdNeeded) {
                    CodeConditionStatement hybridTest = new CodeConditionStatement();
                    for (HybridDeferredAttribute hybridAttr : hybridAttrs) {
                        CodeBinaryOperatorExpression partialTest = new CodeBinaryOperatorExpression(CodeBinaryOperatorType.IDENTITY_EQUALITY, hybridAttr.getValueRef(), ScriptExpression.UNDEFINED);
                        if (hybridTest.getCondition() == null) {
                            hybridTest.setCondition(partialTest);
                            continue;
                        }
                        hybridTest.setCondition(new CodeBinaryOperatorExpression(CodeBinaryOperatorType.BOOLEAN_OR, hybridTest.getCondition(), partialTest));
                    }
                    this.flushBuffer();
                    this.scopeStack.peek().add(hybridTest);
                    this.scopeStack.push(hybridTest.getTrueStatements());
                }
                this.formatter.writeOpenAttribute((Appendable)this.buffer, "id");
                this.flushBuffer();
                this.scopeStack.peek().add(CodeDOMUtility.emitVarValue(idVar));
                this.formatter.writeCloseAttribute((Appendable)this.buffer);
                if (testIfIdNeeded) {
                    this.flushBuffer();
                    this.scopeStack.pop();
                }
            } else if (id instanceof LiteralNode) {
                idValue = ((LiteralNode)id).getValue();
            } else {
                ex = new InvalidNodeException("Invalid ID attribute node type: " + id.getClass(), id);
                this.log.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
        if (element.canHaveChildren()) {
            this.formatter.writeCloseElementBeginTag((Appendable)this.buffer);
            TagMode prevMode = this.tagMode;
            if ("script".equalsIgnoreCase(tagName) || "style".equalsIgnoreCase(tagName)) {
                this.tagMode = TagMode.SUSPEND;
            } else if ("pre".equalsIgnoreCase(tagName)) {
                this.tagMode = TagMode.PRE;
            }
            try {
                for (DuelNode child : element.getChildren()) {
                    String lit;
                    if (!(!this.settings.getNormalizeWhitespace() || this.tagMode != TagMode.NORMAL || !(child instanceof LiteralNode) || child != element.getFirstChild() && child != element.getLastChild() || (lit = ((LiteralNode)child).getValue()) != null && !lit.matches("^[\\r\\n]*$"))) continue;
                    this.buildNode(child);
                }
            }
            finally {
                this.tagMode = prevMode;
            }
            if (this.hasScripts && "body".equalsIgnoreCase(tagName)) {
                this.ensureExtrasEmitted(true);
                this.buffer.append(this.settings.getNewline());
            }
            this.formatter.writeElementEndTag((Appendable)this.buffer, tagName);
        } else if (this.settings.getXHTMLStyle()) {
            this.formatter.writeCloseElementVoidTag((Appendable)this.buffer);
        } else {
            this.formatter.writeCloseElementBeginTag((Appendable)this.buffer);
        }
        if (deferredAttrs.size() > 0 || hybridAttrs.size() > 0) {
            this.buildDeferredAttributeExecutions(deferredAttrs, hybridAttrs, idVar, idValue, argSize);
        }
    }

    private void buildDeferredAttributeExecutions(Map<String, DataEncoder.Snippet> deferredAttrs, List<HybridDeferredAttribute> hybridAttrs, CodeVariableDeclarationStatement idVar, String idValue, int argSize) throws IOException {
        boolean hasTags = false;
        if (deferredAttrs.size() > 0) {
            hasTags = true;
            this.hasScripts = true;
            this.formatter.writeOpenElementBeginTag((Appendable)this.buffer, "script");
            if (this.settings.getScriptTypeAttr()) {
                this.formatter.writeAttribute((Appendable)this.buffer, "type", "text/javascript");
            }
            this.formatter.writeCloseElementBeginTag((Appendable)this.buffer);
            this.buildDeferredAttributeExecution(deferredAttrs, idVar, idValue, argSize);
        }
        CodeVariableDeclarationStatement hasTagsVar = null;
        if (!hasTags) {
            hasTagsVar = new CodeVariableDeclarationStatement(Boolean.TYPE, this.scopeStack.peek().nextIdent("hasTags_"), CodePrimitiveExpression.FALSE);
            this.scopeStack.peek().add(hasTagsVar);
        }
        for (HybridDeferredAttribute hybridAttr : hybridAttrs) {
            CodeConditionStatement hybridTest = new CodeConditionStatement((CodeExpression)new CodeBinaryOperatorExpression(CodeBinaryOperatorType.IDENTITY_EQUALITY, hybridAttr.getValueRef(), ScriptExpression.UNDEFINED), new CodeStatement[0]);
            this.flushBuffer();
            this.scopeStack.peek().add(hybridTest);
            this.scopeStack.push(hybridTest.getTrueStatements());
            if (!hasTags) {
                this.hasScripts = true;
                CodeConditionStatement tagsTest = new CodeConditionStatement((CodeExpression)new CodeUnaryOperatorExpression(CodeUnaryOperatorType.LOGICAL_NEGATION, new CodeVariableReferenceExpression(hasTagsVar)), new CodeExpressionStatement(new CodeBinaryOperatorExpression(CodeBinaryOperatorType.ASSIGN, new CodeVariableReferenceExpression(hasTagsVar), CodePrimitiveExpression.TRUE)));
                this.scopeStack.peek().add(tagsTest);
                this.scopeStack.push(tagsTest.getTrueStatements());
                this.formatter.writeOpenElementBeginTag((Appendable)this.buffer, "script");
                if (this.settings.getScriptTypeAttr()) {
                    this.formatter.writeAttribute((Appendable)this.buffer, "type", "text/javascript");
                }
                this.formatter.writeCloseElementBeginTag((Appendable)this.buffer);
                this.flushBuffer();
                this.scopeStack.pop();
            }
            HashMap<String, DataEncoder.Snippet> map = new HashMap<String, DataEncoder.Snippet>();
            map.put(hybridAttr.getAttrName(), DataEncoder.asSnippet((String)hybridAttr.getClientCode()));
            this.buildDeferredAttributeExecution(map, idVar, idValue, hybridAttr.getArgSize());
            this.flushBuffer();
            this.scopeStack.pop();
        }
        if (hasTags) {
            this.formatter.writeElementEndTag((Appendable)this.buffer, "script");
        } else {
            CodeConditionStatement tagsTest = new CodeConditionStatement((CodeExpression)new CodeVariableReferenceExpression(hasTagsVar), new CodeStatement[0]);
            this.scopeStack.peek().add(tagsTest);
            this.scopeStack.push(tagsTest.getTrueStatements());
            this.formatter.writeElementEndTag((Appendable)this.buffer, "script");
            this.flushBuffer();
            this.scopeStack.pop();
        }
    }

    private void buildDeferredAttributeExecution(Map<String, DataEncoder.Snippet> deferredAttrs, CodeVariableDeclarationStatement idVar, String idValue, int argSize) throws IOException {
        boolean prettyPrint = this.encoder.isPrettyPrint();
        CodeStatementCollection scope = this.scopeStack.peek();
        this.ensureExtrasEmitted(false);
        this.buffer.append("duel(");
        this.encoder.write((Appendable)this.buffer, deferredAttrs, 1);
        this.buffer.append(")(");
        if (argSize > 0) {
            this.flushBuffer();
            scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Object.class, "data"), CodePrimitiveExpression.ONE));
            if (argSize > 1) {
                this.buffer.append(',');
                if (prettyPrint) {
                    this.buffer.append(' ');
                }
                this.flushBuffer();
                scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Integer.TYPE, "index"), CodePrimitiveExpression.ONE));
                if (argSize > 2) {
                    this.buffer.append(',');
                    if (prettyPrint) {
                        this.buffer.append(' ');
                    }
                    this.flushBuffer();
                    scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Integer.TYPE, "count"), CodePrimitiveExpression.ONE));
                    if (argSize > 3) {
                        this.buffer.append(',');
                        if (prettyPrint) {
                            this.buffer.append(' ');
                        }
                        this.flushBuffer();
                        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(String.class, "key"), CodePrimitiveExpression.ONE));
                    }
                }
            }
        }
        this.buffer.append(").toDOM(");
        if (idVar != null) {
            this.flushBuffer();
            scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(idVar), CodePrimitiveExpression.ONE));
        } else {
            this.encoder.write((Appendable)this.buffer, (Object)idValue, 1);
        }
        this.buffer.append(',');
        if (prettyPrint) {
            this.buffer.append(" true");
        } else {
            this.buffer.append('1');
        }
        this.buffer.append(");");
    }

    private void buildCodeBlock(CodeBlockNode node) throws IOException {
        try {
            CodeExpression codeExpr;
            boolean htmlEncode = true;
            if (node instanceof MarkupExpressionNode) {
                htmlEncode = false;
                node = new ExpressionNode(node.getValue(), node.getIndex(), node.getLine(), node.getColumn());
            }
            if ((codeExpr = this.translateExpression(node, true)) == null) {
                return;
            }
            boolean isHybrid = codeExpr.hasMetaData(AS_HYBRID);
            codeExpr.removeMetaData(AS_HYBRID);
            CodeStatementCollection scope = this.scopeStack.peek();
            if (!isHybrid) {
                CodeStatement writeStatement = htmlEncode ? CodeDOMUtility.emitExpressionSafe(codeExpr, this.formatter, this.settings) : CodeDOMUtility.emitExpression(codeExpr);
                this.flushBuffer();
                scope.add(writeStatement);
                return;
            }
            CodeVariableDeclarationStatement valDecl = new CodeVariableDeclarationStatement(Object.class, scope.nextIdent("val_"), codeExpr);
            this.flushBuffer();
            scope.add(valDecl);
            CodeVariableReferenceExpression valRef = new CodeVariableReferenceExpression(valDecl);
            CodeConditionStatement hybridTest = new CodeConditionStatement((CodeExpression)new CodeBinaryOperatorExpression(CodeBinaryOperatorType.IDENTITY_INEQUALITY, valRef, ScriptExpression.UNDEFINED), htmlEncode ? CodeDOMUtility.emitExpressionSafe(valRef, this.formatter, this.settings) : CodeDOMUtility.emitExpression(valRef));
            scope.add(hybridTest);
            this.scopeStack.push(hybridTest.getFalseStatements());
            this.buildDeferredCodeBlock(node.getClientCode(this.encoder.isPrettyPrint()), node.getArgSize());
            this.flushBuffer();
            this.scopeStack.pop();
        }
        catch (Exception ex) {
            this.buildDeferredCodeBlock(node.getClientCode(this.encoder.isPrettyPrint()), node.getArgSize());
        }
    }

    private void buildDeferredCodeBlock(String clientCode, int argSize) throws IOException {
        boolean prettyPrint = this.encoder.isPrettyPrint();
        CodeStatementCollection scope = this.scopeStack.peek();
        this.hasScripts = true;
        this.formatter.writeOpenElementBeginTag((Appendable)this.buffer, "script");
        if (this.settings.getScriptTypeAttr()) {
            this.formatter.writeAttribute((Appendable)this.buffer, "type", "text/javascript");
        }
        this.formatter.writeOpenAttribute((Appendable)this.buffer, "id");
        CodeVariableDeclarationStatement idVar = this.emitClientID();
        this.formatter.writeCloseAttribute((Appendable)this.buffer).writeCloseElementBeginTag((Appendable)this.buffer);
        this.ensureExtrasEmitted(false);
        this.buffer.append("duel(");
        this.buffer.append(clientCode);
        this.buffer.append(")(");
        if (argSize > 0) {
            this.flushBuffer();
            scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Object.class, "data"), CodePrimitiveExpression.ONE));
            if (argSize > 1) {
                this.buffer.append(',');
                if (prettyPrint) {
                    this.buffer.append(' ');
                }
                this.flushBuffer();
                scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Integer.TYPE, "index"), CodePrimitiveExpression.ONE));
                if (argSize > 2) {
                    this.buffer.append(',');
                    if (prettyPrint) {
                        this.buffer.append(' ');
                    }
                    this.flushBuffer();
                    scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(Integer.TYPE, "count"), CodePrimitiveExpression.ONE));
                    if (argSize > 3) {
                        this.buffer.append(',');
                        if (prettyPrint) {
                            this.buffer.append(' ');
                        }
                        this.flushBuffer();
                        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(String.class, "key"), CodePrimitiveExpression.ONE));
                    }
                }
            }
        }
        this.buffer.append(").toDOM(");
        this.flushBuffer();
        scope.add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "dataEncode", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodeVariableReferenceExpression(idVar), CodePrimitiveExpression.ONE));
        this.buffer.append(");");
        this.formatter.writeElementEndTag((Appendable)this.buffer, "script");
    }

    private CodeVariableDeclarationStatement emitClientID() {
        this.flushBuffer();
        CodeStatementCollection scope = this.scopeStack.peek();
        CodeVariableDeclarationStatement localVar = CodeDOMUtility.nextID(scope);
        scope.add(localVar);
        CodeStatement emitVar = CodeDOMUtility.emitVarValue(localVar);
        scope.add(emitVar);
        return localVar;
    }

    private CodeStatement buildLinkIntercept(Object literal) {
        CodeMethodInvokeExpression codeExpr = new CodeMethodInvokeExpression(String.class, new CodeThisReferenceExpression(), "transformURL", new CodeVariableReferenceExpression(DuelContext.class, "context"), CodeDOMUtility.ensureString(new CodePrimitiveExpression(literal)));
        return CodeDOMUtility.emitExpressionSafe(codeExpr, this.formatter, this.settings);
    }

    private CodeStatement buildLinkIntercept(CodeBlockNode block) {
        CodeExpression codeExpr;
        boolean htmlEncode = true;
        if (block instanceof MarkupExpressionNode) {
            htmlEncode = false;
            block = new ExpressionNode(block.getValue(), block.getIndex(), block.getLine(), block.getColumn());
        }
        if ((codeExpr = this.translateExpression(block, true)) == null) {
            return null;
        }
        codeExpr = new CodeMethodInvokeExpression(String.class, new CodeThisReferenceExpression(), "transformURL", new CodeVariableReferenceExpression(DuelContext.class, "context"), CodeDOMUtility.ensureString(codeExpr));
        return htmlEncode ? CodeDOMUtility.emitExpressionSafe(codeExpr, this.formatter, this.settings) : CodeDOMUtility.emitExpression(codeExpr);
    }

    private void ensureExtrasEmitted(boolean needsTags) {
        if (!this.needsExtrasEmitted) {
            return;
        }
        this.flushBuffer();
        this.scopeStack.peek().add(new CodeMethodInvokeExpression(Void.class, new CodeThisReferenceExpression(), "writeExtras", new CodeVariableReferenceExpression(DuelContext.class, "context"), new CodePrimitiveExpression(needsTags)));
        for (CodeStatementCollection scope : this.scopeStack) {
            if (scope.getOwner() instanceof CodeMethod) continue;
            return;
        }
        this.needsExtrasEmitted = false;
    }

    private CodeMethod ensureInitMethod() {
        for (CodeMember member : this.viewType.getMembers()) {
            if (!(member instanceof CodeMethod) || !"init".equals(((CodeMethod)member).getName())) continue;
            return (CodeMethod)member;
        }
        CodeMethod initMethod = new CodeMethod(AccessModifierType.PROTECTED, Void.class, "init", null, new CodeStatement[0]).withOverride();
        this.viewType.add(initMethod);
        return initMethod;
    }

    private void buildComment(CodeCommentNode comment) {
        this.flushBuffer();
        CodeStatementCollection scope = this.scopeStack.peek();
        scope.add(new CodeCommentStatement(comment.getValue()));
    }

    private void flushBuffer() {
        if (this.buffer.length() < 1) {
            return;
        }
        CodeStatement emitLit = CodeDOMUtility.emitLiteralValue(this.buffer.toString());
        this.scopeStack.peek().add(emitLit);
        this.buffer.setLength(0);
    }

    private static enum TagMode {
        NORMAL,
        PRE,
        SUSPEND;

    }
}

