/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codegen;

import java.util.Locale;
import org.duelengine.duel.codegen.CodeGenerator;

public class CodeGenSettings {
    private static final char NAMESPACE_DELIM = '.';
    private static final char DIR_DELIM = '/';
    private String clientPrefix;
    private String serverPrefix;
    private String indent = "\t";
    private String newline = "\n";
    private boolean convertLineEndings;
    private boolean normalizeWhitespace;
    private boolean xhtmlStyle;
    private boolean encodeNonASCII = true;
    private boolean scriptTypeAttr;
    private boolean lowercaseClientPaths = true;

    public void setClientNamePrefix(String value) {
        this.clientPrefix = value == null ? null : value.trim();
    }

    public String getClientNamePrefix() {
        return this.clientPrefix;
    }

    public boolean hasClientNamePrefix() {
        return this.clientPrefix != null && this.clientPrefix.length() > 0;
    }

    public void setServerNamePrefix(String value) {
        this.serverPrefix = value;
    }

    public String getServerNamePrefix() {
        return this.serverPrefix;
    }

    public boolean hasServerNamePrefix() {
        return this.serverPrefix != null && this.serverPrefix.length() > 0;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String value) {
        this.indent = value != null ? value : "";
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String value) {
        this.newline = value != null ? value : "";
    }

    public boolean getConvertLineEndings() {
        return this.convertLineEndings;
    }

    public void setConvertLineEndings(boolean value) {
        this.convertLineEndings = value;
    }

    public boolean getXHTMLStyle() {
        return this.xhtmlStyle;
    }

    public void setXHTMLStyle(boolean value) {
        this.xhtmlStyle = value;
    }

    public boolean getEncodeNonASCII() {
        return this.encodeNonASCII;
    }

    public void setEncodeNonASCII(boolean value) {
        this.encodeNonASCII = value;
    }

    public boolean getScriptTypeAttr() {
        return this.scriptTypeAttr;
    }

    public void setScriptTypeAttr(boolean value) {
        this.scriptTypeAttr = value;
    }

    public boolean getNormalizeWhitespace() {
        return this.normalizeWhitespace;
    }

    public void setNormalizeWhitespace(boolean value) {
        this.normalizeWhitespace = value;
    }

    public boolean getLowercaseClientPaths() {
        return this.lowercaseClientPaths;
    }

    public void setLowercaseClientPaths(boolean value) {
        this.lowercaseClientPaths = value;
    }

    String getServerName(String viewName) {
        String string = viewName = viewName != null ? viewName.trim() : "";
        if (this.serverPrefix == null || this.serverPrefix.length() < 1) {
            return viewName;
        }
        return this.serverPrefix + '.' + viewName;
    }

    public String getServerPath(String viewName, CodeGenerator codegen) {
        if (viewName == null) {
            throw new NullPointerException("viewName");
        }
        if (codegen == null) {
            throw new NullPointerException("codegen");
        }
        return this.getServerName(viewName).replace('.', '/') + codegen.getFileExtension();
    }

    String getClientName(String viewName) {
        if (viewName != null) {
            viewName = viewName.trim();
        }
        if (this.clientPrefix == null || this.clientPrefix.length() < 1) {
            return viewName;
        }
        return this.clientPrefix + '.' + viewName;
    }

    public String getClientPath(String viewName) {
        if (viewName == null) {
            throw new NullPointerException("viewName");
        }
        String clientPath = this.getClientName(viewName);
        if (this.lowercaseClientPaths) {
            clientPath = clientPath.toLowerCase(Locale.ROOT);
        }
        return clientPath.replace('.', '/');
    }
}

