/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.parsing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.duelengine.duel.ast.CALLCommandNode;
import org.duelengine.duel.ast.CodeCommentNode;
import org.duelengine.duel.ast.CommandNode;
import org.duelengine.duel.ast.CommentNode;
import org.duelengine.duel.ast.ContainerNode;
import org.duelengine.duel.ast.DocTypeNode;
import org.duelengine.duel.ast.DuelNode;
import org.duelengine.duel.ast.ElementNode;
import org.duelengine.duel.ast.ExpressionNode;
import org.duelengine.duel.ast.FORCommandNode;
import org.duelengine.duel.ast.IFCommandNode;
import org.duelengine.duel.ast.LiteralNode;
import org.duelengine.duel.ast.MarkupExpressionNode;
import org.duelengine.duel.ast.MetaElementNode;
import org.duelengine.duel.ast.PARTCommandNode;
import org.duelengine.duel.ast.StatementNode;
import org.duelengine.duel.ast.UnknownNode;
import org.duelengine.duel.ast.VIEWCommandNode;
import org.duelengine.duel.ast.XORCommandNode;
import org.duelengine.duel.parsing.BlockValue;
import org.duelengine.duel.parsing.CharUtility;
import org.duelengine.duel.parsing.DuelLexer;
import org.duelengine.duel.parsing.DuelToken;
import org.duelengine.duel.parsing.InvalidNodeException;
import org.duelengine.duel.parsing.InvalidTokenException;

public class DuelParser {
    private DuelToken next;
    private Iterator<DuelToken> tokens;

    public List<VIEWCommandNode> parse(DuelToken ... tokenSequence) throws Exception {
        return this.parse(tokenSequence != null ? Arrays.asList(tokenSequence).iterator() : null);
    }

    public List<VIEWCommandNode> parse(Iterable<DuelToken> tokenSequence) throws Exception {
        return this.parse(tokenSequence != null ? tokenSequence.iterator() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VIEWCommandNode> parse(Iterator<DuelToken> tokenSequence) throws IOException {
        if (tokenSequence == null) {
            throw new NullPointerException("tokenSequence");
        }
        this.tokens = tokenSequence;
        try {
            ContainerNode document = new ContainerNode(0, 0, 0);
            while (this.hasNext()) {
                this.parseNext(document);
            }
            ArrayList<VIEWCommandNode> views = new ArrayList<VIEWCommandNode>(1);
            for (DuelNode node : document.getChildren()) {
                String text;
                if (node instanceof VIEWCommandNode) {
                    views.add(this.scrubView((VIEWCommandNode)node));
                    continue;
                }
                if (node instanceof LiteralNode && ((text = ((LiteralNode)node).getValue()) == null || text.trim().isEmpty())) continue;
                throw new InvalidNodeException("Content must sit within a named view.", node);
            }
            ArrayList<VIEWCommandNode> arrayList = views;
            return arrayList;
        }
        finally {
            this.tokens = null;
            this.next = null;
        }
    }

    private void parseNext(ContainerNode parent) throws IOException {
        switch (this.next.getToken()) {
            case LITERAL: {
                this.parseLiteral(parent);
                break;
            }
            case ELEM_BEGIN: {
                this.parseElem(parent);
                break;
            }
            case ELEM_END: {
                ElementNode parentElem;
                if (parent instanceof ElementNode && (parentElem = (ElementNode)parent).isAncestorOrSelf(this.next.getValue())) {
                    return;
                }
                this.next = null;
                break;
            }
            case BLOCK: {
                this.parseBlock(parent);
                break;
            }
            case ERROR: {
                if (this.tokens instanceof DuelLexer) {
                    throw new InvalidTokenException("Syntax error: " + this.next.getValue(), this.next, ((DuelLexer)this.tokens).getLastError());
                }
                throw new InvalidTokenException("Syntax error: " + this.next.getValue(), this.next);
            }
            default: {
                throw new InvalidTokenException("Invalid token: " + this.next, this.next);
            }
        }
    }

    private void parseLiteral(ContainerNode parent) {
        DuelNode last = parent.getLastChild();
        if (last instanceof LiteralNode) {
            LiteralNode lastLit = (LiteralNode)last;
            lastLit.setValue(lastLit.getValue() + this.next.getValue());
        } else {
            parent.appendChild(new LiteralNode(this.next.getValue(), this.next.getIndex(), this.next.getLine(), this.next.getColumn()));
        }
        this.next = null;
    }

    private void parseElem(ContainerNode parent) throws IOException {
        String tagName = this.next.getValue();
        ElementNode elem = DuelParser.createElement(tagName, this.next.getIndex(), this.next.getLine(), this.next.getColumn());
        parent.appendChild(elem);
        this.next = null;
        String attrName = null;
        block5: while (this.hasNext()) {
            switch (this.next.getToken()) {
                case ATTR_NAME: {
                    attrName = this.next.getValue();
                    elem.setAttribute(attrName, null);
                    this.next = null;
                    continue block5;
                }
                case ATTR_VALUE: {
                    if (attrName == null) {
                        throw new InvalidTokenException("Attribute name was missing", this.next);
                    }
                    BlockValue block = this.next.getBlock();
                    DuelNode attrVal = block != null ? this.createBlock(block, this.next.getIndex(), this.next.getLine(), this.next.getColumn()) : new LiteralNode(this.next.getValue(), this.next.getIndex(), this.next.getLine(), this.next.getColumn());
                    elem.setAttribute(attrName, attrVal);
                    attrName = null;
                    this.next = null;
                    continue block5;
                }
                case ELEM_END: {
                    String tag = this.next.getValue();
                    if (tag != null) {
                        if (elem.isSelf(tag = tag.toLowerCase())) {
                            this.next = null;
                            this.rewriteConditionalAttr(elem);
                            return;
                        }
                        if (elem.isAncestor(tag)) {
                            this.rewriteConditionalAttr(elem);
                            return;
                        }
                    }
                    this.next = null;
                    continue block5;
                }
            }
            if (!elem.canHaveChildren()) {
                this.rewriteConditionalAttr(elem);
                return;
            }
            this.parseNext(elem);
        }
    }

    private void parseBlock(ContainerNode parent) {
        DuelNode node;
        BlockValue block = this.next.getBlock();
        if (block != null && (node = this.createBlock(block, this.next.getIndex(), this.next.getLine(), this.next.getColumn())) != null) {
            parent.appendChild(node);
        }
        this.next = null;
    }

    private void rewriteConditionalAttr(ElementNode elem) {
        if (elem instanceof CommandNode && !(elem instanceof CALLCommandNode) && !(elem instanceof FORCommandNode)) {
            return;
        }
        DuelNode attr = elem.removeAttribute("if");
        if (attr == null) {
            return;
        }
        IFCommandNode conditional = new IFCommandNode(attr.getIndex(), attr.getLine(), attr.getColumn());
        conditional.setAttribute("test", attr);
        ContainerNode parent = elem.getParent();
        if (!parent.replaceChild(conditional, elem)) {
            throw new IllegalStateException("Conditional rewrite failed inside " + parent.getClass().getSimpleName());
        }
        conditional.appendChild(elem);
    }

    private VIEWCommandNode scrubView(VIEWCommandNode node) {
        String text;
        if (node.getName() == null || node.getName().isEmpty()) {
            throw new InvalidNodeException("View is missing name attribute", node);
        }
        DuelNode child = node.getLastChild();
        if (child instanceof LiteralNode && CharUtility.isNullOrWhiteSpace(text = ((LiteralNode)child).getValue())) {
            node.removeChild(child);
        }
        if ((child = node.getFirstChild()) instanceof LiteralNode && CharUtility.isNullOrWhiteSpace(text = ((LiteralNode)child).getValue())) {
            node.removeChild(child);
        }
        return node;
    }

    private boolean hasNext() {
        while (this.next == null && this.tokens.hasNext()) {
            this.next = this.tokens.next();
        }
        return this.next != null;
    }

    public static ElementNode createElement(String tagName, int index, int line, int column) {
        if (tagName == null) {
            return null;
        }
        if (tagName.equalsIgnoreCase("for")) {
            return new FORCommandNode(index, line, column);
        }
        if (tagName.equalsIgnoreCase("if")) {
            return new XORCommandNode(index, line, column);
        }
        if (tagName.equalsIgnoreCase("else")) {
            return new IFCommandNode(index, line, column);
        }
        if (tagName.equalsIgnoreCase("call")) {
            return new CALLCommandNode(index, line, column);
        }
        if (tagName.equalsIgnoreCase("part")) {
            return new PARTCommandNode(index, line, column);
        }
        if (tagName.equalsIgnoreCase("view")) {
            return new VIEWCommandNode(index, line, column);
        }
        if (tagName.equalsIgnoreCase("meta")) {
            return new MetaElementNode(index, line, column);
        }
        return new ElementNode(tagName.toLowerCase(), index, line, column);
    }

    private DuelNode createBlock(BlockValue block, int index, int line, int column) {
        String begin = block.getBegin();
        if (begin == null) {
            return null;
        }
        String value = block.getValue();
        if (begin.equals("<%=")) {
            return new ExpressionNode(value, index, line, column);
        }
        if (begin.equals("<%")) {
            return new StatementNode(value, index, line, column);
        }
        if (begin.equals("<%#")) {
            return new MarkupExpressionNode(value, index, line, column);
        }
        if (begin.equalsIgnoreCase("<!doctype")) {
            return new DocTypeNode(value, index, line, column);
        }
        if (begin.equalsIgnoreCase("<!--")) {
            return new CommentNode(value, index, line, column);
        }
        if (begin.equalsIgnoreCase("<%--")) {
            return new CodeCommentNode(value, index, line, column);
        }
        return new UnknownNode(begin + value + block.getEnd(), column, column, column);
    }
}

