/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeVisitor;

public class CodeObjectCreateExpression
extends CodeExpression {
    private String typeName;
    private final List<CodeExpression> arguments = new ArrayList<CodeExpression>();

    public CodeObjectCreateExpression() {
    }

    public CodeObjectCreateExpression(String typeName, CodeExpression ... args) {
        this.typeName = typeName;
        if (args != null) {
            this.arguments.addAll(Arrays.asList(args));
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String value) {
        this.typeName = value;
    }

    public List<CodeExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public Class<?> getResultType() {
        return Object.class;
    }

    @Override
    public void visit(CodeVisitor visitor) {
        if (visitor.visit(this)) {
            for (CodeExpression expression : this.arguments) {
                if (expression == null) continue;
                expression.visit(visitor);
            }
        }
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof CodeObjectCreateExpression)) {
            return false;
        }
        CodeObjectCreateExpression that = (CodeObjectCreateExpression)arg;
        if (this.typeName == null ? that.typeName != null : !this.typeName.equals(that.typeName)) {
            return false;
        }
        int length = this.arguments.size();
        if (length != that.arguments.size()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            CodeExpression thisArg = this.arguments.get(i);
            CodeExpression thatArg = that.arguments.get(i);
            if (!(thisArg == null ? thatArg != null : !thisArg.equals(thatArg))) continue;
            return false;
        }
        return super.equals(arg);
    }

    @Override
    public int hashCode() {
        int HASH_PRIME = 1000003;
        int hash = super.hashCode() * 1000003 + this.arguments.hashCode();
        if (this.typeName != null) {
            hash = hash * 1000003 + this.typeName.hashCode();
        }
        return hash;
    }
}

