/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codedom;

import java.util.ArrayList;
import java.util.Iterator;
import org.duelengine.duel.codedom.CodeExpression;
import org.duelengine.duel.codedom.CodeExpressionStatement;
import org.duelengine.duel.codedom.CodeObject;
import org.duelengine.duel.codedom.CodeStatement;
import org.duelengine.duel.codedom.CodeStatementBlock;

public class CodeStatementCollection
extends ArrayList<CodeStatement> {
    private final CodeObject owner;

    public CodeStatementCollection(CodeObject owner) {
        this.owner = owner;
    }

    public CodeObject getOwner() {
        return this.owner;
    }

    public boolean addAll(CodeStatementBlock block) {
        if (block == null) {
            return false;
        }
        for (CodeStatement statement : block.getStatements()) {
            super.add(statement);
        }
        return true;
    }

    public boolean addAll(CodeStatement[] statements) {
        if (statements == null) {
            return false;
        }
        for (CodeStatement statement : statements) {
            super.add(statement);
        }
        return true;
    }

    @Override
    public boolean add(CodeExpression expression) {
        return this.add(new CodeExpressionStatement(expression));
    }

    public CodeStatement getFirstStatement() {
        if (this.isEmpty()) {
            return null;
        }
        return (CodeStatement)this.get(0);
    }

    public CodeStatement getLastStatement() {
        if (this.isEmpty()) {
            return null;
        }
        return (CodeStatement)this.get(this.size() - 1);
    }

    @Override
    public Iterator<CodeStatement> iterator() {
        return super.iterator();
    }

    @Override
    public boolean equals(Object arg) {
        if (!(arg instanceof CodeStatementCollection)) {
            return false;
        }
        CodeStatementCollection that = (CodeStatementCollection)arg;
        int length = this.size();
        if (length != that.size()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            CodeStatement thisStatement = (CodeStatement)this.get(i);
            CodeStatement thatStatement = (CodeStatement)that.get(i);
            if (!(thisStatement == null ? thatStatement != null : !thisStatement.equals(thatStatement))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

