/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.duelengine.duel.DataEncoder;
import org.duelengine.duel.ast.CALLCommandNode;
import org.duelengine.duel.ast.CodeBlockNode;
import org.duelengine.duel.ast.CodeCommentNode;
import org.duelengine.duel.ast.CommentNode;
import org.duelengine.duel.ast.DuelNode;
import org.duelengine.duel.ast.ElementNode;
import org.duelengine.duel.ast.ExpressionNode;
import org.duelengine.duel.ast.LiteralNode;
import org.duelengine.duel.ast.SpecialNode;
import org.duelengine.duel.ast.VIEWCommandNode;
import org.duelengine.duel.codegen.CodeGenSettings;
import org.duelengine.duel.codegen.CodeGenerator;
import org.duelengine.duel.parsing.InvalidNodeException;

public class ClientCodeGen
implements CodeGenerator {
    private final CodeGenSettings settings;
    private final DataEncoder encoder;

    public ClientCodeGen() {
        this(null);
    }

    public ClientCodeGen(CodeGenSettings codeGenSettings) {
        this.settings = codeGenSettings != null ? codeGenSettings : new CodeGenSettings();
        this.encoder = new DataEncoder(this.settings.getNewline(), this.settings.getIndent());
    }

    @Override
    public String getFileExtension() {
        return ".js";
    }

    @Override
    public void write(Appendable output, VIEWCommandNode ... views) throws IOException {
        this.write(output, views != null ? Arrays.asList(views) : null);
    }

    @Override
    public void write(Appendable output, Iterable<VIEWCommandNode> views) throws IOException {
        if (output == null) {
            throw new NullPointerException("output");
        }
        if (views == null) {
            throw new NullPointerException("views");
        }
        output.append("/*global duel */");
        this.writeln(output, 0);
        ArrayList namespaces = new ArrayList();
        for (VIEWCommandNode view : views) {
            if (view == null || view.isServerOnly()) continue;
            this.writeln(output, 0);
            String viewName = this.settings.getClientName(view.getName());
            try {
                if (this.encoder.writeNamespace(output, namespaces, viewName)) {
                    this.writeln(output, 0);
                }
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidNodeException("Invalid view name: " + viewName, view.getAttribute("name"), ex);
            }
            this.writeView(output, view, viewName);
        }
    }

    private void writeView(Appendable output, VIEWCommandNode view, String viewName) throws IOException {
        if (viewName.indexOf(46) < 0) {
            output.append("var ");
        }
        output.append(viewName);
        output.append(" = duel(");
        if (view.childCount() == 1) {
            DuelNode child = view.getFirstChild();
            if (child instanceof ElementNode && (((ElementNode)child).hasChildren() || ((ElementNode)child).hasAttributes())) {
                this.writeln(output, 1);
            }
            this.writeNode(output, child, 1, false);
        } else {
            this.writeElement(output, "", view, 0, false);
        }
        output.append(");");
        this.writeln(output, 0);
    }

    private void writeNode(Appendable output, DuelNode node, int depth, boolean preMode) throws IOException {
        if (node instanceof LiteralNode) {
            this.writeString(output, ((LiteralNode)node).getValue(), preMode);
        } else if (node instanceof ElementNode) {
            this.writeElement(output, ((ElementNode)node).getTagName(), (ElementNode)node, depth, preMode);
        } else if (node instanceof CodeBlockNode) {
            this.writeCodeBlock(output, (CodeBlockNode)node);
        } else if (node instanceof CodeCommentNode) {
            this.writeComment(output, ((CodeCommentNode)node).getValue());
        } else if (node instanceof SpecialNode) {
            this.writeSpecialNode(output, (SpecialNode)node, depth, preMode);
        } else if (node != null) {
            throw new UnsupportedOperationException("Node type not yet implemented: " + node.getClass());
        }
    }

    private void writeComment(Appendable output, String value) throws IOException {
        output.append("/*");
        if (value != null) {
            output.append(value.replace("*/", "*\\/"));
        }
        output.append("*/");
    }

    private void writeCodeBlock(Appendable output, CodeBlockNode node) throws IOException {
        output.append(node.getClientCode(this.encoder.isPrettyPrint()));
    }

    private void writeSpecialNode(Appendable output, SpecialNode node, int depth, boolean preMode) throws IOException {
        output.append('[');
        ++depth;
        this.writeString(output, node.getName(), preMode);
        if (node.hasValue()) {
            output.append(',');
            this.writeln(output, depth);
            this.writeString(output, node.getValue(), preMode);
        }
        --depth;
        if (node.hasValue()) {
            this.writeln(output, depth);
        }
        output.append(']');
    }

    private void writeElement(Appendable output, String tagName, ElementNode node, int depth, boolean preMode) throws IOException {
        if (!preMode) {
            preMode = "pre".equalsIgnoreCase(tagName) || "script".equalsIgnoreCase(tagName);
        }
        output.append('[');
        ++depth;
        this.writeString(output, tagName, preMode);
        if (node.hasAttributes()) {
            Set<String> attrs = node.getAttributeNames();
            boolean singleAttr = attrs.size() == 1;
            output.append(", {");
            ++depth;
            boolean addPrefix = node instanceof CALLCommandNode && this.settings.hasClientNamePrefix();
            boolean needsDelim = false;
            for (String attr : attrs) {
                if (singleAttr) {
                    output.append(' ');
                } else {
                    if (needsDelim) {
                        output.append(',');
                    } else {
                        needsDelim = true;
                    }
                    this.writeln(output, depth);
                }
                this.writeString(output, attr, preMode);
                output.append(" : ");
                DuelNode attrVal = node.getAttribute(attr);
                if (node.isBoolAttribute(attr)) {
                    if (attrVal instanceof CodeBlockNode) {
                        this.writeNode(output, attrVal, depth, preMode);
                        continue;
                    }
                    output.append("true");
                    continue;
                }
                if (attrVal == null) {
                    output.append("null");
                    continue;
                }
                if (attrVal instanceof CommentNode) {
                    output.append("\"\"");
                    continue;
                }
                if (addPrefix && "view".equalsIgnoreCase(attr) && attrVal instanceof ExpressionNode) {
                    ExpressionNode nameAttr = (ExpressionNode)attrVal;
                    attrVal = new ExpressionNode(this.settings.getClientName(nameAttr.getValue()), nameAttr.getIndex(), nameAttr.getLine(), nameAttr.getColumn());
                }
                this.writeNode(output, attrVal, depth, preMode);
            }
            --depth;
            if (singleAttr) {
                output.append(' ');
            } else {
                this.writeln(output, depth);
            }
            output.append('}');
        }
        boolean hasChildren = false;
        boolean needsDelim = false;
        List<DuelNode> children = node.getChildren();
        int length = children.size();
        for (int j = 0; j < length; ++j) {
            if (children.get(j) instanceof CodeCommentNode) continue;
            needsDelim = true;
            break;
        }
        block2: for (int i = 0; i < length; ++i) {
            String lit;
            DuelNode child = children.get(i);
            if (this.settings.getNormalizeWhitespace() && !preMode && child instanceof LiteralNode && (child == node.getFirstChild() || child == node.getLastChild()) && ((lit = ((LiteralNode)child).getValue()) == null || lit.matches("^[\\r\\n]*$"))) continue;
            if (needsDelim) {
                output.append(',');
            }
            needsDelim = false;
            hasChildren = true;
            this.writeln(output, depth);
            this.writeNode(output, child, depth, preMode);
            if (child instanceof CodeCommentNode) continue;
            for (int j = i + 1; j < length; ++j) {
                if (children.get(j) instanceof CodeCommentNode) continue;
                needsDelim = true;
                continue block2;
            }
        }
        --depth;
        if (hasChildren) {
            this.writeln(output, depth);
        }
        output.append(']');
    }

    private void writeString(Appendable output, String value, boolean preMode) throws IOException {
        if (value == null) {
            output.append("null");
            return;
        }
        if (!preMode && this.settings.getNormalizeWhitespace() && !value.isEmpty()) {
            if ((value = value.replaceAll("^[\\r\\n]+", "").replaceAll("[\\r\\n]+$", "").replaceAll("\\s+", " ")).isEmpty()) {
                value = " ";
            }
        } else if (this.settings.getConvertLineEndings()) {
            if (!"\t".equals(this.settings.getIndent())) {
                value = value.replace("\t", this.settings.getIndent());
            }
            if (!"\n".equals(this.settings.getNewline())) {
                value = value.replace("\n", this.settings.getNewline());
            }
        }
        int start = 0;
        int length = value.length();
        output.append('\'');
        block9: for (int i = start; i < length; ++i) {
            String escape;
            char ch = value.charAt(i);
            switch (ch) {
                case '\'': {
                    escape = "\\'";
                    break;
                }
                case '\\': {
                    escape = "\\\\";
                    break;
                }
                case '\t': {
                    escape = "\\t";
                    break;
                }
                case '\n': {
                    escape = "\\n";
                    break;
                }
                case '\r': {
                    escape = "\\r";
                    break;
                }
                case '\f': {
                    escape = "\\f";
                    break;
                }
                case '\b': {
                    escape = "\\b";
                    break;
                }
                default: {
                    if (ch >= ' ' && ch < '\u007f') continue block9;
                    escape = String.format("\\u%04X", value.codePointAt(i));
                }
            }
            if (i > start) {
                output.append(value, start, i);
            }
            start = i + 1;
            output.append(escape);
        }
        if (length > start) {
            output.append(value, start, length);
        }
        output.append('\'');
    }

    private void writeln(Appendable output, int depth) throws IOException {
        output.append(this.settings.getNewline());
        String indent = this.settings.getIndent();
        while (depth-- > 0) {
            output.append(indent);
        }
    }
}

