/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.maven;

import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.duelengine.duel.compiler.DuelCompiler;

public class DuelMojo
extends AbstractMojo {
    private MavenProject project;
    private String inputDir;
    private String outputDir;
    private String outputClientPath;
    private String outputServerDir;
    private String clientPrefix;
    private String serverPrefix;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        log.info((CharSequence)("\tinputDir=" + this.inputDir));
        log.info((CharSequence)("\toutputServerDir=" + this.outputServerDir));
        if (this.outputClientPath == null || this.outputClientPath.isEmpty()) {
            this.outputClientPath = "/js/views/";
        } else {
            if (!this.outputClientPath.startsWith("/")) {
                this.outputClientPath = '/' + this.outputClientPath;
            }
            if (!this.outputClientPath.endsWith("/")) {
                this.outputClientPath = this.outputClientPath + '/';
            }
        }
        log.info((CharSequence)("\toutputClientDir=" + this.outputDir + this.outputClientPath));
        log.info((CharSequence)("\tclientPrefix=" + this.clientPrefix));
        log.info((CharSequence)("\tserverPrefix=" + this.serverPrefix));
        DuelCompiler compiler = new DuelCompiler();
        compiler.setInputDir(this.inputDir);
        compiler.setOutputClientDir(this.outputDir + this.outputClientPath);
        if (this.outputServerDir != null && !this.outputServerDir.isEmpty()) {
            compiler.setOutputServerDir(this.outputServerDir);
        }
        if (this.clientPrefix != null && !this.clientPrefix.isEmpty()) {
            compiler.setClientPrefix(this.clientPrefix);
        }
        if (this.serverPrefix != null && !this.serverPrefix.isEmpty()) {
            compiler.setServerPrefix(this.serverPrefix);
        }
        try {
            compiler.execute();
            this.project.addCompileSourceRoot(compiler.getOutputServerDir());
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }
}

