/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.mvc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

final class ClassEnumerator {
    private static final String CLASS_FILE = ".class";
    private static final String JAR_FILE = ".jar";

    ClassEnumerator() {
    }

    public static Set<Class<?>> getClasses(String packageName) throws IOException, ClassNotFoundException {
        return ClassEnumerator.getClasses(packageName, Thread.currentThread().getContextClassLoader());
    }

    public static Set<Class<?>> getClasses(String packageName, ClassLoader loader) throws IOException, ClassNotFoundException {
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = loader.getResources(path);
        if (resources == null) {
            return Collections.emptySet();
        }
        HashSet classes = new HashSet();
        while (resources.hasMoreElements()) {
            String filePath = resources.nextElement().getPath();
            if (filePath == null) continue;
            int bang = (filePath = URLDecoder.decode(filePath, "UTF-8")).indexOf(33);
            if (bang > 0 & filePath.lastIndexOf(JAR_FILE) > 0) {
                String jarPath = filePath.substring(0, bang).substring(filePath.lastIndexOf(58) + 1);
                classes.addAll(ClassEnumerator.getFromJAR(path, jarPath));
                continue;
            }
            classes.addAll(ClassEnumerator.getFromDirectory(packageName, new File(filePath)));
        }
        return classes;
    }

    public static Set<Class<?>> getFromDirectory(String packageName, File directory) throws ClassNotFoundException {
        HashSet classes = new HashSet();
        if (directory.exists()) {
            for (String file : directory.list()) {
                if (!file.endsWith(CLASS_FILE)) continue;
                String name = packageName + '.' + file.substring(0, file.lastIndexOf(46));
                classes.add(Class.forName(name));
            }
        }
        return classes;
    }

    public static Set<Class<?>> getFromJAR(String packageName, String jar) throws FileNotFoundException, IOException, ClassNotFoundException {
        JarEntry jarEntry;
        JarInputStream jarFile = new JarInputStream(new FileInputStream(jar));
        HashSet classes = new HashSet();
        while ((jarEntry = jarFile.getNextJarEntry()) != null) {
            String className = jarEntry.getName();
            if (!className.endsWith(CLASS_FILE) || !(className = className.substring(0, className.lastIndexOf(46))).startsWith(packageName)) continue;
            classes.add(Class.forName(className.replace('/', '.')));
        }
        return classes;
    }
}

