/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.duel.mvc;

import com.google.inject.Inject;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.duelengine.duel.mvc.DuelMvcContext;
import org.duelengine.duel.mvc.ErrorFilterInterceptor;
import org.duelengine.duel.mvc.ResultFilter;
import org.duelengine.duel.mvc.ResultFilterContext;
import org.duelengine.duel.mvc.ResultFilterContextFactory;
import org.duelengine.duel.mvc.ViewResult;

final class ResultFilterInterceptor
implements MethodInterceptor {
    private ResultFilterContextFactory factory;

    ResultFilterInterceptor() {
    }

    @Inject
    void init(ResultFilterContextFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        int index;
        ResultFilterContext context = this.factory.create((ViewResult)invocation.getThis());
        DuelMvcContext mvcContext = context.getMvcContext();
        mvcContext.ensureFilters();
        Throwable error = null;
        List<ResultFilter> renderChain = mvcContext.getResultFilters();
        try {
            int count = renderChain.size();
            for (index = 0; index < count; ++index) {
                renderChain.get(index).onResultRendering(context);
            }
            invocation.proceed();
        }
        catch (Throwable ex) {
            error = ex;
        }
        --index;
        while (index >= 0) {
            block7: {
                try {
                    renderChain.get(index).onResultRendered(context);
                }
                catch (Throwable ex) {
                    if (error != null) break block7;
                    error = ex;
                }
            }
            --index;
        }
        if (error != null) {
            ErrorFilterInterceptor.processErrors(mvcContext, error, null);
            return null;
        }
        return null;
    }
}

